/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.gui.GuideBaseScreen;
import net.kaneka.planttech2.gui.buttons.CustomButton;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuidePlantsScreen
extends GuideBaseScreen {
    private final String[] buttonEntryNames = new String[8];
    private Component selectedName = new TextComponent("");
    protected ItemStack primarySeed = ItemStack.f_41583_;
    protected ItemStack soil = ItemStack.f_41583_;
    protected ItemStack[] seeds = new ItemStack[9];
    protected DropEntry[] drops = new DropEntry[9];
    protected ItemStack[][] parents = new ItemStack[4][2];
    protected EnumTemperature temp = EnumTemperature.NORMAL;

    public GuidePlantsScreen() {
        super(PlantTechMain.getCropList().getLengthEnabledOnly() - 8, true, "screen.guideplants");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int xPos = this.guiLeft + 28;
        int baseYPos = this.guiTop + 10;
        int width = 100;
        int height = 20;
        for (int id = 0; id < 8; ++id) {
            this.m_142416_((GuiEventListener)new CustomButton(id, xPos, baseYPos + id * 22, 100, 20, "Button " + (id + 1), this::buttonClicked));
        }
        this.updateButtons();
    }

    @Override
    protected void drawForeground(PoseStack pStack) {
        if (this.hasSelection) {
            int i;
            GuidePlantsScreen.m_93133_((PoseStack)pStack, (int)(this.guiLeft + 307), (int)(this.guiTop + 65), (float)0.0f, (float)(196 + 16 * this.temp.ordinal()), (int)16, (int)16, (int)512, (int)512);
            this.renderItem(this.primarySeed, 261, 32);
            if (!this.soil.m_41619_()) {
                this.renderItem(this.soil, 217, 65);
            }
            for (i = 0; i < 9; ++i) {
                if (!this.seeds[i].m_41619_()) {
                    this.renderItem(this.seeds[i], 189 + 18 * i, 98);
                }
                if (this.drops[i] == DropEntry.EMPTY) continue;
                this.renderItem(this.drops[i].getItemStack(), 189 + 18 * i, 131);
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0].m_41619_()) continue;
                this.renderItem(this.parents[i][0], 162 + 56 * i, 164);
                this.renderItem(this.parents[i][1], 192 + 56 * i, 164);
            }
        }
    }

    @Override
    protected void updateButtons() {
        List<CropEntry> list = PlantTechMain.getCropList().values(false);
        for (int i = 0; i < 8; ++i) {
            if (this.scrollPos + i >= list.size()) continue;
            CropEntry entry = list.get(this.scrollPos + i);
            Object e = this.f_169369_.get(i);
            if (e instanceof AbstractWidget) {
                AbstractWidget aWidget = (AbstractWidget)e;
                aWidget.m_93666_(entry.getDisplayName());
            }
            this.buttonEntryNames[i] = entry.getName();
        }
    }

    @Override
    protected void drawStrings(PoseStack mStack) {
        if (!this.hasSelection) {
            GuidePlantsScreen.m_93215_((PoseStack)mStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.non_selected"), (int)(this.guiLeft + 255), (int)(this.guiTop + 90), (int)59395);
        } else {
            GuidePlantsScreen.m_93215_((PoseStack)mStack, (Font)this.f_96547_, (Component)this.selectedName, (int)(this.guiLeft + 263), (int)(this.guiTop + 15), (int)59395);
            GuidePlantsScreen.m_93215_((PoseStack)mStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.soil"), (int)(this.guiLeft + 223), (int)(this.guiTop + 54), (int)59395);
            GuidePlantsScreen.m_93215_((PoseStack)mStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.temperature"), (int)(this.guiLeft + 306), (int)(this.guiTop + 54), (int)59395);
            GuidePlantsScreen.m_93215_((PoseStack)mStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.seeds"), (int)(this.guiLeft + 263), (int)(this.guiTop + 87), (int)59395);
            GuidePlantsScreen.m_93215_((PoseStack)mStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.drops"), (int)(this.guiLeft + 263), (int)(this.guiTop + 120), (int)59395);
            GuidePlantsScreen.m_93215_((PoseStack)mStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.parents"), (int)(this.guiLeft + 263), (int)(this.guiTop + 153), (int)59395);
        }
    }

    protected void buttonClicked(CustomButton button) {
        int buttonID = button.id;
        if (buttonID >= 0 && buttonID < 8) {
            this.setItems(this.buttonEntryNames[buttonID]);
        }
    }

    protected void setItems(String entryName) {
        int j;
        CropEntry entry = PlantTechMain.getCropList().getByName(entryName);
        boolean bl = this.hasSelection = entry != null;
        if (!this.hasSelection) {
            return;
        }
        this.selectedName = entry.getDisplayName();
        this.primarySeed = entry.getPrimarySeed().getItemStack();
        this.temp = entry.getConfiguration().getTemperature();
        this.soil = new ItemStack((ItemLike)entry.getConfiguration().getSoil().get());
        Arrays.fill(this.seeds, ItemStack.f_41583_);
        Arrays.fill(this.drops, DropEntry.EMPTY);
        for (int k = 0; k < 4; ++k) {
            Arrays.fill(this.parents[k], ItemStack.f_41583_);
        }
        List<Supplier<Item>> seeds = entry.getSeeds();
        List<DropEntry> drops = entry.getAdditionalDrops();
        List<ParentPair> parents = entry.getParents();
        this.seeds[0] = entry.getPrimarySeed().getItemStack();
        for (j = 0; j < 8 && j < seeds.size(); ++j) {
            this.seeds[j + 1] = new ItemStack((ItemLike)seeds.get(j).get());
        }
        this.drops[0] = entry.getPrimarySeed();
        for (j = 0; j < 8 && j < drops.size(); ++j) {
            this.drops[j + 1] = drops.get(j);
        }
        for (j = 0; j < 4 && j < parents.size(); ++j) {
            ParentPair pair = parents.get(j);
            this.parents[j][0] = PlantTechMain.getCropList().getByName(pair.getFirstParent()).getPrimarySeed().getItemStack();
            this.parents[j][1] = PlantTechMain.getCropList().getByName(pair.getSecondParent()).getPrimarySeed().getItemStack();
        }
    }

    @Override
    protected void drawTooltips(PoseStack mStack, int mouseX, int mouseY) {
        if (this.hasSelection) {
            int i;
            this.drawTooltip(mStack, this.primarySeed.m_41786_(), mouseX, mouseY, 261, 32);
            if (!this.soil.m_41619_()) {
                this.drawTooltip(mStack, this.soil.m_41786_(), mouseX, mouseY, 217, 65);
            }
            this.drawTooltip(mStack, (Component)this.temp.getDisplayString(), mouseX, mouseY, 307, 65);
            for (i = 0; i < 9; ++i) {
                if (!this.seeds[i].m_41619_()) {
                    this.drawTooltip(mStack, this.seeds[i].m_41786_(), mouseX, mouseY, 189 + 18 * i, 98);
                }
                if (this.drops[i] == DropEntry.EMPTY) continue;
                this.drawTooltip(mStack, (Component)new TextComponent("").m_130946_(this.drops[i].getMin() + "-" + this.drops[i].getMax() + "x ").m_7220_(this.drops[i].getItem().get().m_5456_().m_41466_()), mouseX, mouseY, 189 + 18 * i, 131);
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0].m_41619_()) continue;
                this.drawTooltip(mStack, this.parents[i][0].m_41786_(), mouseX, mouseY, 162 + 56 * i, 164);
                this.drawTooltip(mStack, this.parents[i][1].m_41786_(), mouseX, mouseY, 192 + 56 * i, 164);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.hasSelection && mouseButton == 0) {
            CropEntry entry;
            int i;
            Item clickedOn = null;
            if (this.inItemStackArea(mouseX, mouseY, 261, 32)) {
                clickedOn = this.primarySeed.m_41720_();
            }
            if (this.inItemStackArea(mouseX, mouseY, 217, 65) && this.soil != null && !this.soil.m_41619_()) {
                clickedOn = this.soil.m_41720_();
            }
            for (i = 0; i < 9; ++i) {
                if (this.seeds[i] != null && this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 98)) {
                    clickedOn = this.seeds[i].m_41720_();
                }
                if (this.drops[i] == null || !this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 131)) continue;
                clickedOn = this.drops[i].getItem().get().m_5456_();
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0] == null) continue;
                if (this.inItemStackArea(mouseX, mouseY, 162 + 56 * i, 164)) {
                    clickedOn = this.parents[i][0].m_41720_();
                }
                if (!this.inItemStackArea(mouseX, mouseY, 192 + 56 * i, 164)) continue;
                clickedOn = this.parents[i][1].m_41720_();
            }
            if (clickedOn != null && (entry = PlantTechMain.getCropList().getBySeed(clickedOn)) != null) {
                this.setItems(entry.getName());
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    private boolean inArea(double mouseX, double mouseY, int posX, int posY, int width, int height) {
        return mouseX >= (double)(posX += this.guiLeft) && mouseX <= (double)(posX + width) && mouseY >= (double)(posY += this.guiTop) && mouseY <= (double)(posY + height);
    }

    private boolean inItemStackArea(double mouseX, double mouseY, int posX, int posY) {
        return this.inArea(mouseX, mouseY, posX, posY, 16, 16);
    }

    @Override
    protected void drawBackground(PoseStack mStack) {
        if (!this.hasSelection) {
            GuidePlantsScreen.m_93133_((PoseStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)0.0f, (int)300, (int)this.ySize, (int)512, (int)512);
        } else {
            GuidePlantsScreen.m_93133_((PoseStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)196.0f, (int)300, (int)this.ySize, (int)512, (int)512);
        }
        GuidePlantsScreen.m_93133_((PoseStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }
}

