/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.kaneka.planttech2.inventory.ItemUpgradeableContainer;
import net.kaneka.planttech2.items.upgradeable.BaseUpgradeableItem;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemUpgradeableScreen
extends AbstractContainerScreen<ItemUpgradeableContainer> {
    protected static final Map<Integer, ResourceLocation> BACKGROUND = new HashMap<Integer, ResourceLocation>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(10, new ResourceLocation("planttech2:textures/gui/container/itemupgradeable_10.png"));
        }
    };
    protected final Inventory player;
    protected ItemStack stack;
    protected int invsize;
    protected IEnergyStorage energystorage;

    public ItemUpgradeableScreen(ItemUpgradeableContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.player = inv;
        this.stack = container.getStack();
        this.invsize = BaseUpgradeableItem.getInventorySize(this.stack);
        this.energystorage = BaseUpgradeableItem.getEnergyCap(this.stack);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97726_ = 205;
        this.f_97727_ = 202;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
    }

    public void m_6305_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pStack);
        super.m_6305_(pStack, mouseX, mouseY, partialTicks);
        this.drawTooltips(pStack, mouseX, mouseY);
        this.m_7025_(pStack, mouseX, mouseY);
    }

    protected void drawTooltips(PoseStack pStack, int mouseX, int mouseY) {
        if (this.energystorage != null) {
            this.drawTooltip(pStack, this.energystorage.getEnergyStored() + "/" + this.energystorage.getMaxEnergyStored(), mouseX, mouseY, 162, 28, 16, 74);
        }
    }

    public void drawTooltip(PoseStack mStack, String lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.f_97735_) && mouseX <= posX + width && mouseY >= (posY += this.f_97736_) && mouseY <= posY + height) {
            this.m_96570_(mStack, null, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack pStack, float partialTicks, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96541_.m_91097_().m_118506_(BACKGROUND.get(this.invsize));
        this.m_93228_(pStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int k = this.getEnergyStoredScaled(55);
        this.m_93228_(pStack, this.f_97735_ + 149, this.f_97736_ + 28 + (55 - k), 208, 55 - k, 16, 0 + k);
    }

    protected int getEnergyStoredScaled(int pixels) {
        if (this.energystorage != null) {
            int i = this.energystorage.getEnergyStored();
            int j = this.energystorage.getMaxEnergyStored();
            return i != 0 && j != 0 ? i * pixels / j : 0;
        }
        return 0;
    }

    protected boolean m_97805_(int keyCode, int scanCode) {
        return false;
    }
}

