/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui.guide;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.gui.buttons.CustomButton;
import net.kaneka.planttech2.gui.guide.Guide;
import net.kaneka.planttech2.gui.guide.GuideEntry;
import net.kaneka.planttech2.gui.guide.GuideMenu;
import net.kaneka.planttech2.gui.guide.GuidePicture;
import net.kaneka.planttech2.gui.guide.GuideString;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class GuideScreen
extends Screen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2:textures/gui/guide.png");
    protected int xSize = 441;
    protected int ySize = 258;
    protected int guiLeft;
    protected int guiTop;
    protected final List<AbstractWidget> buttons_mainmenu = Lists.newArrayList();
    protected final List<AbstractWidget> buttons_entry = Lists.newArrayList();
    protected final List<AbstractWidget> buttons_navigation = Lists.newArrayList();
    private Guide guide = new Guide();
    int mode = 0;
    int menuid = 0;
    int entryid = 0;
    int page = 0;
    int maxPages = 0;
    int linesPerPage = 19;
    private List<GuideString> lines = new ArrayList<GuideString>();
    private List<GuidePicture> pics;

    public GuideScreen() {
        super((Component)new TranslatableComponent("planttech2.guide"));
    }

    public GuideScreen(int menuid, int entryid) {
        this();
        this.mode = 2;
        this.menuid = menuid;
        this.entryid = entryid;
    }

    public void m_7856_() {
        int y;
        int x;
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 5; ++y) {
                this.addButtonList(this.buttons_mainmenu, 1, x * 5 + y, this.guiLeft + 50 + x * 200, this.guiTop + 35 + y * 37, 150, 35, this.translateUnformated("guide.planttech2.amenu"));
            }
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 5; ++y) {
                this.addButtonList(this.buttons_entry, 2, x * 5 + y, this.guiLeft + 50 + x * 200, this.guiTop + 35 + y * 37, 150, 20, this.translateUnformated("guide.planttech2.submenu"));
            }
        }
        this.addButtonList(this.buttons_navigation, 0, 0, this.guiLeft + 170, this.guiTop + 230, 100, 20, this.translateUnformated("gui.back"));
        this.addButtonList(this.buttons_navigation, 0, 1, this.guiLeft + 15, this.guiTop + 230, 100, 20, this.translateUnformated("gui.last"));
        this.addButtonList(this.buttons_navigation, 0, 2, this.guiLeft + 320, this.guiTop + 230, 100, 20, this.translateUnformated("gui.next"));
        this.deactivateButtonList(this.buttons_entry);
        this.deactivateButtonList(this.buttons_navigation);
        this.update(true);
    }

    protected void addButtonList(List<AbstractWidget> list, int buttontype, int id, int xPos, int yPos, int width, int height, String displayString) {
        CustomButton button = (CustomButton)this.m_142416_((GuiEventListener)new CustomButton(id, xPos, yPos, width, height, this.translateUnformated(displayString), btn -> this.buttonClicked(buttontype, id)));
        list.add((AbstractWidget)button);
    }

    protected void buttonClicked(int buttontype, int buttonid) {
        boolean modechange = false;
        if (buttontype == 0) {
            if (buttonid == 0) {
                if (this.mode >= 1) {
                    --this.mode;
                    this.page = 0;
                }
            } else if (buttonid == 1) {
                --this.page;
            } else if (buttonid == 2) {
                ++this.page;
            }
        } else {
            modechange = true;
            this.mode = buttontype;
            if (this.mode == 1) {
                this.menuid = buttonid;
            } else if (this.mode == 2) {
                this.entryid = buttonid + this.page * 10;
            }
        }
        this.update(modechange);
    }

    private void activateButton(AbstractWidget button) {
        button.f_93623_ = true;
        button.f_93624_ = true;
    }

    private void deactivateButton(AbstractWidget button) {
        button.f_93623_ = false;
        button.f_93624_ = false;
    }

    private void activateButtonList(List<AbstractWidget> list) {
        for (AbstractWidget button : list) {
            this.activateButton(button);
        }
    }

    private void deactivateButtonList(List<? extends Widget> list) {
        for (Widget widget : list) {
            Widget widget2 = widget;
            if (!(widget2 instanceof AbstractWidget)) continue;
            AbstractWidget aWidget = (AbstractWidget)widget2;
            this.deactivateButton(aWidget);
        }
    }

    private void update(boolean modechange) {
        this.deactivateButtonList(this.f_169369_);
        if (this.mode == 0) {
            for (int i = 0; i < this.buttons_mainmenu.size(); ++i) {
                AbstractWidget button = this.buttons_mainmenu.get(i);
                if (i >= this.guide.getAmountMainMenus()) continue;
                this.activateButton(button);
                button.m_93666_((Component)new TextComponent(this.guide.getMenuById(i).getName()));
            }
        } else if (this.mode == 1) {
            GuideMenu menu = this.guide.getMenuById(this.menuid);
            this.maxPages = menu.getAmountEntrys() / 8;
            for (int i = 0; i < this.buttons_entry.size(); ++i) {
                AbstractWidget button = this.buttons_entry.get(i);
                if (i + this.page * 10 >= menu.getAmountEntrys()) continue;
                this.activateButton(button);
                button.m_93666_((Component)new TextComponent(menu.getEntryById(i + this.page * 10).getName()));
            }
            this.activateButton(this.buttons_navigation.get(0));
            if (this.page > 0) {
                this.activateButton(this.buttons_navigation.get(1));
            }
            if (this.maxPages - 1 > this.page) {
                this.activateButton(this.buttons_navigation.get(2));
            }
        } else if (this.mode == 2) {
            this.activateButton(this.buttons_navigation.get(0));
            if (modechange) {
                this.loadEntry();
            }
            if (this.page > 0) {
                this.activateButton(this.buttons_navigation.get(1));
            }
            if (this.maxPages - 1 > this.page) {
                this.activateButton(this.buttons_navigation.get(2));
            }
        }
    }

    public void m_6305_(PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96541_.m_91097_().m_118506_(BACKGROUND);
        this.drawBackground(mStack);
        this.drawForeground(mStack);
        this.drawButtons(mStack, mouseX, mouseY, partialTicks);
        this.drawStrings(mStack);
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawButtons(PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.f_169369_.size(); ++i) {
            ((Widget)this.f_169369_.get(i)).m_6305_(mStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground(PoseStack mStack) {
        GuideScreen.m_93133_((PoseStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)512, (int)512);
    }

    protected void drawForeground(PoseStack mStack) {
        if (this.mode == 2 && !this.pics.isEmpty() && this.page == 0) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (GuidePicture pic : this.pics) {
                this.f_96541_.m_91097_().m_118506_(pic.getResloc());
                GuideScreen.m_93133_((PoseStack)mStack, (int)(this.guiLeft + pic.getXStart() + 25), (int)(this.guiTop + pic.getYStart() + 30), (float)0.0f, (float)0.0f, (int)pic.getWidth(), (int)pic.getHeight(), (int)pic.getWidth(), (int)pic.getHeight());
            }
        }
    }

    protected void drawStrings(PoseStack mStack) {
        if (this.mode == 0) {
            this.drawCenteredString(mStack, this.translateUnformated("guide.planttech2.header"), this.guiLeft + this.xSize / 2, this.guiTop + 15);
        } else if (this.mode == 1) {
            this.drawCenteredString(mStack, this.guide.getMenuById(this.menuid).getName(), this.guiLeft + this.xSize / 2, this.guiTop + 15);
        } else if (this.mode == 2) {
            this.drawCenteredString(mStack, this.guide.getMenuById(this.menuid).getEntryById(this.entryid).getHeader().getString(), this.guiLeft + this.xSize / 2, this.guiTop + 15);
            for (int i = 0; i < this.lines.size(); ++i) {
                GuideString guideString = this.lines.get(i);
                if (this.page * 19 > guideString.getLine() || guideString.getLine() >= this.page * 19 + 19) continue;
                this.drawLine(mStack, guideString.getString(), this.guiLeft + 25 + guideString.getX(), this.guiTop + 30 + 10 * (guideString.getLine() - 19 * this.page));
            }
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
    }

    protected String translateUnformated(String name) {
        return new TranslatableComponent(name).getString();
    }

    protected void drawCenteredString(PoseStack mStack, String string, int posX, int posY) {
        this.f_96547_.m_92883_(mStack, string, (float)(posX - this.f_96547_.m_92895_(string) / 2), (float)posY, Integer.parseInt("000000", 16));
    }

    protected void drawLine(PoseStack mStack, String text, int x, int y) {
        this.f_96547_.m_92883_(mStack, text, (float)x, (float)y, Integer.parseInt("000000", 16));
    }

    protected void loadEntry() {
        GuideEntry entry = this.guide.getMenuById(this.menuid).getEntryById(this.entryid);
        this.pics = entry.getPictures();
        this.lines = entry.getTextFormated(this.f_96547_);
        this.page = 0;
        this.maxPages = (int)Math.ceil((double)this.lines.size() / (double)this.linesPerPage);
    }
}

