/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.inventory;

import java.util.Arrays;
import java.util.function.Predicate;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BaseMenu
extends AbstractContainerMenu {
    protected final EnergyInventoryBlockEntity BlockEntity;
    protected final ContainerData data;

    public BaseMenu(int id, MenuType<?> type, Inventory player, EnergyInventoryBlockEntity BlockEntity2, int slots) {
        super(type, id);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)player, x + y * 9 + 9, 23 + x * 18, 106 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)player, x, 23 + x * 18, 164));
        }
        this.BlockEntity = BlockEntity2;
        this.data = BlockEntity2.getContainerData();
        this.m_38884_(this.data);
    }

    public boolean m_6875_(Player playerIn) {
        return this.BlockEntity.isUsableByPlayer(playerIn);
    }

    public EnergyBlockEntity getTE() {
        return this.BlockEntity;
    }

    public int getValue(int id) {
        return this.data.m_6413_(id);
    }

    protected LimitedItemInfoSlot createSpeedUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.speedupgrade").setConditions(stack -> {
            Item item = stack.m_41720_();
            return item instanceof TierItem && ((TierItem)item).getItemType() == TierItem.ItemType.SPEED_UPGRADE;
        }).setLimited();
    }

    protected LimitedItemInfoSlot createRangeUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.rangeupgrade").setConditions(stack -> {
            Item item = stack.m_41720_();
            return item instanceof TierItem && ((TierItem)item).getItemType() == TierItem.ItemType.RANGE_UPGRADE;
        }).setLimited();
    }

    protected LimitedItemInfoSlot createKnowledgeChipSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, this.BlockEntity.getKnowledgeChipSlot(), xPosition, yPosition, "slot.util.knowledgechip").setConditions(stack -> stack.m_41720_() instanceof KnowledgeChip);
    }

    protected LimitedItemInfoSlot createCapacityChipSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return (LimitedItemInfoSlot)new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.energystorageupgrade").setConditions(stack -> {
            Item item = stack.m_41720_();
            return item instanceof TierItem && ((TierItem)item).getItemType() == TierItem.ItemType.CAPACITY_UPGRADE;
        }).setLimited().setShouldListen();
    }

    protected LimitedItemInfoSlot createEnergyInSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, this.BlockEntity.getEnergyInSlot(), xPosition, yPosition, "slot.util.energyin").setConditions(stack -> stack.m_41720_() instanceof IItemChargeable);
    }

    protected LimitedItemInfoSlot createEnergyOutSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, this.BlockEntity.getEnergyOutSlot(), xPosition, yPosition, "slot.util.energyout").setConditions(stack -> stack.m_41720_() instanceof IItemChargeable);
    }

    protected LimitedItemInfoSlot createFluidInSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, ((EnergyInventoryFluidBlockEntity)this.BlockEntity).getFluidInSlot(), xPosition, yPosition, "slot.util.fluidin");
    }

    protected LimitedItemInfoSlot createFluidOutSlot(IItemHandler itemHandler, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, ((EnergyInventoryFluidBlockEntity)this.BlockEntity).getFluidOutSlot(), xPosition, yPosition, "slot.util.fluidout");
    }

    protected LimitedItemInfoSlot createFakeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, usage).setConditions(false).setCanTake(false);
    }

    protected LimitedItemInfoSlot createOutoutSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        return new LimitedItemInfoSlot(itemHandler, index, xPosition, yPosition, "slot.util.output").setConditions(false);
    }

    protected LimitedItemInfoSlot createDNAContainerSlot(IItemHandler handler, int index, int xPosition, int yPosition, String usage, boolean isEmpty) {
        return new LimitedItemInfoSlot(handler, index, xPosition, yPosition, usage).setConditions(stack -> isEmpty && stack.m_41720_() == ModItems.DNA_CONTAINER_EMPTY || !isEmpty && stack.m_41720_() == ModItems.DNA_CONTAINER && stack.m_41782_());
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            if (index > 35) {
                if (!this.m_38903_(stack1, 0, 34, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(stack1, 36, 37, false) && stack1.m_41720_() instanceof CropSeedItem) {
                    return ItemStack.f_41583_;
                }
                if (index >= 0 && index < 27 ? !this.m_38903_(stack1, 27, 35, false) : index >= 27 && !this.m_38903_(stack1, 0, 26, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stack1);
        }
        return stack;
    }

    public class LimitedItemInfoSlot
    extends SlotItemHandlerWithInfo {
        private Predicate<ItemStack> conditions;
        private Predicate<Player> canTake;
        private boolean limited;

        public LimitedItemInfoSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition, usage);
            this.conditions = stack -> true;
            this.canTake = stack -> true;
            this.limited = false;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.conditions.test(stack);
        }

        public boolean m_8010_(Player playerIn) {
            return this.canTake.test(playerIn);
        }

        public int m_5866_(ItemStack stack) {
            return this.limited ? 1 : super.m_5866_(stack);
        }

        public LimitedItemInfoSlot setLimited() {
            this.limited = true;
            return this;
        }

        public LimitedItemInfoSlot setConditions(boolean enabled) {
            return this.setConditions((ItemStack stack) -> enabled);
        }

        public LimitedItemInfoSlot setConditions(Item ... acceptableItems) {
            return this.setConditions((ItemStack stack) -> acceptableItems.length == 0 || Arrays.stream(acceptableItems).anyMatch(item -> stack.m_41720_() == item));
        }

        public LimitedItemInfoSlot setConditions(Predicate<ItemStack> conditions) {
            this.conditions = conditions;
            return this;
        }

        public LimitedItemInfoSlot setCanTake(boolean enabled) {
            return this.setCanTake(stack -> enabled);
        }

        public LimitedItemInfoSlot setCanTake(Predicate<Player> conditions) {
            this.canTake = conditions;
            return this;
        }
    }

    public class SlotItemHandlerWithInfo
    extends SlotItemHandler {
        private final String usage;
        protected boolean listening;

        public SlotItemHandlerWithInfo(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition);
            this.listening = false;
            this.usage = usage;
        }

        public String getUsageString() {
            return this.usage;
        }

        public void m_6654_() {
            super.m_6654_();
            if (this.listening) {
                BaseMenu.this.m_38946_();
                BaseMenu.this.BlockEntity.onContainerUpdated(this.getSlotIndex());
            }
        }

        public SlotItemHandlerWithInfo setShouldListen() {
            this.listening = true;
            return this;
        }
    }
}

