/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.inventory;

import java.util.HashMap;
import java.util.Map;
import net.kaneka.planttech2.items.upgradeable.IUpgradeable;
import net.kaneka.planttech2.registries.ModContainers;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ItemUpgradeableContainer
extends AbstractContainerMenu {
    public static final Map<Integer, Integer[]> settings = new HashMap<Integer, Integer[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(10, new Integer[]{2, 5, 20, 20});
        }
    };
    private int slot;
    private final ItemStack stack;

    public ItemUpgradeableContainer(int id, Inventory inv) {
        this(id, inv, new ItemStack((ItemLike)ModItems.CYBERBOW), -1);
    }

    public ItemUpgradeableContainer(int id, Inventory playerInv, ItemStack itemInv, int slot) {
        super(ModContainers.UPGRADEABLEITEM, id);
        int x;
        int y;
        this.stack = itemInv;
        LazyOptional provider = itemInv.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        IItemHandler handler = (IItemHandler)provider.orElseThrow(NullPointerException::new);
        int invsize = handler.getSlots();
        Integer[] setting = settings.get(invsize);
        if (setting != null) {
            for (y = 0; y < setting[0]; ++y) {
                for (x = 0; x < setting[1]; ++x) {
                    this.m_38897_((Slot)new ChangeCheckSlot(itemInv, handler, x + y * setting[1], 47 + x * 18, 39 + y * 18, "slot.upgradeableitem.chipslot"));
                }
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInv, x + y * 9 + 9, 24 + x * 18, 107 + y * 18));
            }
        }
        if (slot == -1) {
            slot = playerInv.m_36030_(this.stack) + 1;
        }
        this.slot = slot;
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)playerInv, x2, 24 + x2 * 18, 165));
        }
        this.slot = this.f_38839_.size() - 9 + slot;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId != this.slot) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    class ChangeCheckSlot
    extends SlotItemHandlerWithInfo {
        private ItemStack stack;

        public ChangeCheckSlot(ItemStack stack, IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition, usage);
            this.stack = stack;
        }

        public int m_6641_() {
            return 1;
        }

        public void m_6654_() {
            if (this.stack.m_41720_() instanceof IUpgradeable) {
                ((IUpgradeable)this.stack.m_41720_()).updateNBTValues(this.stack);
            }
            super.m_6654_();
        }
    }

    public class SlotItemHandlerWithInfo
    extends SlotItemHandler {
        private final String usage;

        public SlotItemHandlerWithInfo(IItemHandler itemHandler, int index, int xPosition, int yPosition, String usage) {
            super(itemHandler, index, xPosition, yPosition);
            this.usage = usage;
        }

        public String getUsageString() {
            return this.usage;
        }
    }
}

