/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.EnergyStorageItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdvancedAnalyserItem
extends EnergyStorageItem {
    private static final int capacity = 1000;

    public AdvancedAnalyserItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(ModCreativeTabs.MAIN), 1000);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity blockEntity;
        ItemStack stack = ctx.m_43722_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        if (!level.f_46443_ && !stack.m_41619_() && player != null && (blockEntity = level.m_7702_(pos)) instanceof CropsBlockEntity) {
            CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
            if (cbe.isAnalysed()) {
                traits = cbe.getTraits();
                this.sendTraits(player, traits);
            } else if (this.currentEnergy(stack) >= AdvancedAnalyserItem.getEnergyCosts()) {
                this.extractEnergy(stack, AdvancedAnalyserItem.getEnergyCosts(), false);
                traits = cbe.setAnalysedAndGetTraits();
                this.sendTraits(player, traits);
            } else {
                player.m_6352_((Component)new TextComponent("Not enough energy"), player.m_142081_());
            }
        }
        return super.m_6225_(ctx);
    }

    private void sendTraits(Player player, HashMapCropTraits traits) {
        player.m_6352_((Component)new TextComponent("--------------------------------------"), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.type").getString() + ": " + traits.getType()), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.soil").getString() + ": " + CropSeedItem.getSoilString(traits.getType())), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.growspeed").getString() + ": " + traits.getTrait(EnumTraitsInt.GROWSPEED)), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.sensitivity").getString() + ": " + traits.getTrait(EnumTraitsInt.SENSITIVITY)), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.needed_lightlevel").getString() + ": " + (14 - traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.waterrange").getString() + ": " + (1 + traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.temperature").getString() + ": ").m_7220_(CropSeedItem.temperatureString(traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE))), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.productivity").getString() + ": " + traits.getTrait(EnumTraitsInt.PRODUCTIVITY)), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.fertility").getString() + ": " + traits.getTrait(EnumTraitsInt.FERTILITY)), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.spreedingspeed").getString() + ": " + traits.getTrait(EnumTraitsInt.SPREEDINGSPEED)), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.genestrength").getString() + ": " + traits.getTrait(EnumTraitsInt.GENESTRENGHT)), player.m_142081_());
        player.m_6352_((Component)new TextComponent(new TranslatableComponent("info.energyvalue").getString() + ": " + traits.getTrait(EnumTraitsInt.ENERGYVALUE) * 20), player.m_142081_());
    }

    private static int getEnergyCosts() {
        return 100;
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add((Component)new TextComponent("Rightclick on a crop to analyse traits"));
        tooltip.add((Component)new TextComponent("Analysing unknown traits consumes " + AdvancedAnalyserItem.getEnergyCosts() + " BE"));
    }
}

