/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class AuraCoreItem
extends Item {
    private final int tier;
    private final EnumTemperature temperature;
    private final int lightValueDecrease;
    private final int waterRangeDecrease;
    private final Block soil;
    private final int fertility;
    private final int productivity;
    private final int energyCostPerTick;

    public AuraCoreItem(Builder builder) {
        super(new Item.Properties().m_41491_(ModCreativeTabs.CHIPS));
        this.tier = builder.tier;
        this.temperature = builder.temperature;
        this.lightValueDecrease = builder.lightValueDecrease;
        this.waterRangeDecrease = builder.waterRangeDecrease;
        this.soil = builder.soil;
        this.fertility = builder.fertility;
        this.productivity = builder.productivity;
        this.energyCostPerTick = builder.energyCostPerTick == 0 ? this.tier * 1000 : builder.energyCostPerTick;
    }

    public static boolean doesModifyTemperature(ItemStack stack) {
        return AuraCoreItem.getTemperature(stack).isPresent();
    }

    public static boolean doesModifyLightValue(ItemStack stack) {
        return AuraCoreItem.getLightValueDecrease(stack).isPresent();
    }

    public static boolean doesModifyWaterRange(ItemStack stack) {
        return AuraCoreItem.getWaterRangeDecrease(stack).isPresent();
    }

    public static boolean doesModifySoil(ItemStack stack) {
        return AuraCoreItem.getSoil(stack).isPresent();
    }

    public static boolean doesModifyFertility(ItemStack stack) {
        return AuraCoreItem.getFertilityValueIncrease(stack).isPresent();
    }

    public static boolean doesModifyProductivity(ItemStack stack) {
        return AuraCoreItem.getProductivityValueIncrease(stack).isPresent();
    }

    public static Optional<EnumTemperature> getTemperature(ItemStack stack) {
        return AuraCoreItem.check(stack, item -> item.temperature, null);
    }

    public static Optional<Integer> getLightValueDecrease(ItemStack stack) {
        return AuraCoreItem.check(stack, item -> item.lightValueDecrease, 0);
    }

    public static Optional<Integer> getWaterRangeDecrease(ItemStack stack) {
        return AuraCoreItem.check(stack, item -> item.waterRangeDecrease, 0);
    }

    public static Optional<Block> getSoil(ItemStack stack) {
        return AuraCoreItem.check(stack, block -> block.soil, Blocks.f_50016_);
    }

    public static Optional<Integer> getFertilityValueIncrease(ItemStack stack) {
        return AuraCoreItem.check(stack, item -> item.fertility, 0);
    }

    public static Optional<Integer> getProductivityValueIncrease(ItemStack stack) {
        return AuraCoreItem.check(stack, item -> item.productivity, 0);
    }

    public static Optional<Integer> getEnergyCostPerTick(ItemStack stack) {
        return AuraCoreItem.check(stack, item -> item.energyCostPerTick, 0);
    }

    private static boolean checkExist(ItemStack stack, Function<AuraCoreItem, Boolean> exist) {
        return stack.m_41720_() instanceof AuraCoreItem && exist.apply((AuraCoreItem)stack.m_41720_()) != false;
    }

    private static <V> Optional<V> check(ItemStack stack, Function<AuraCoreItem, V> getter, V defaultV) {
        Object value = null;
        Item item = stack.m_41720_();
        if (item instanceof AuraCoreItem) {
            AuraCoreItem item2 = (AuraCoreItem)item;
            value = getter.apply(item2);
        }
        return value != null && value != defaultV ? Optional.of(value) : Optional.empty();
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltips, TooltipFlag flagIn) {
        String tooltip = "";
        if (AuraCoreItem.doesModifyTemperature(stack)) {
            tooltip = "Change the temperature";
        }
    }

    public static class Builder {
        private final int tier;
        private EnumTemperature temperature;
        private int lightValueDecrease;
        private int waterRangeDecrease;
        private Block soil;
        private int fertility;
        private int productivity;
        private int energyCostPerTick = 0;

        public Builder(int tier) {
            this.tier = tier;
        }

        public Builder setTemperature(EnumTemperature temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setLightValueDecrease(int lightValueDecrease) {
            this.lightValueDecrease = lightValueDecrease;
            return this;
        }

        public Builder setWaterRangeDecrease(int waterRangeDecrease) {
            this.waterRangeDecrease = waterRangeDecrease;
            return this;
        }

        public Builder setSoil(Block soil) {
            this.soil = soil;
            return this;
        }

        public Builder setIncreaseFertility(int fertility) {
            this.fertility = fertility;
            return this;
        }

        public Builder setIncreaseProductivity(int productivity) {
            this.productivity = productivity;
            return this;
        }

        public Builder setEnergyCostPerTick(int energyCostPerTick) {
            this.energyCostPerTick = energyCostPerTick;
            return this;
        }
    }
}

