/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.fluids.capability.BiomassFluidEnergy;
import net.kaneka.planttech2.fluids.capability.IBiomassFluidEnergy;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BiomassContainerItem
extends Item {
    private static final int CAPACITY = 1000;

    public BiomassContainerItem() {
        super(new Item.Properties().m_41491_(ModCreativeTabs.MAIN).m_41487_(1));
    }

    public static float getFillLevelModel(ItemStack stack) {
        int capacity;
        int biomass = BiomassFluidEnergy.getItemStackCap(stack).getCurrentStorage();
        if (biomass > (capacity = BiomassFluidEnergy.getItemStackCap(stack).getMaxStorage()) / 9 * 9) {
            return 9.0f;
        }
        if (biomass > capacity / 9 * 8) {
            return 8.0f;
        }
        if (biomass > capacity / 9 * 7) {
            return 7.0f;
        }
        if (biomass > capacity / 9 * 6) {
            return 6.0f;
        }
        if (biomass > capacity / 9 * 5) {
            return 5.0f;
        }
        if (biomass > capacity / 9 * 4) {
            return 4.0f;
        }
        if (biomass > capacity / 9 * 3) {
            return 3.0f;
        }
        if (biomass > capacity / 9 * 2) {
            return 2.0f;
        }
        if (biomass > capacity / 9) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new BiomassFluidEnergy();
    }

    public static int extractBiomass(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        if (current < amount) {
            BiomassContainerItem.changeCurrentStorage(stack, -current);
            return current;
        }
        BiomassContainerItem.changeCurrentStorage(stack, -amount);
        return amount;
    }

    public static int receiveBiomass(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        if (current + amount > 1000) {
            BiomassContainerItem.changeCurrentStorage(stack, 1000 - current);
            return -1000 + current;
        }
        BiomassContainerItem.changeCurrentStorage(stack, amount);
        return -amount;
    }

    public static void changeCurrentStorage(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        current = current + amount < 0 ? 0 : (current + amount > 1000 ? 1000 : (current += amount));
        BiomassContainerItem.setCurrentStorage(stack, current);
    }

    public static void setCurrentStorage(ItemStack stack, int value) {
        BiomassContainerItem.initTag(stack).m_128405_("biomass", value < 0 ? 0 : Math.min(value, 1000));
    }

    public static int getCurrentStorage(ItemStack stack) {
        return BiomassContainerItem.initTag(stack).m_128451_("biomass");
    }

    public static int getCapacity() {
        return 1000;
    }

    private static CompoundTag initTag(ItemStack stack) {
        CompoundTag CompoundTag2;
        if (stack.m_41782_()) {
            CompoundTag2 = stack.m_41783_();
        } else {
            CompoundTag2 = new CompoundTag();
            CompoundTag2.m_128405_("biomass", 0);
            stack.m_41751_(CompoundTag2);
        }
        return CompoundTag2;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        IBiomassFluidEnergy cap = BiomassFluidEnergy.getItemStackCap(stack);
        tooltip.add((Component)new TextComponent(cap.getCurrentStorage() + "/" + cap.getMaxStorage()));
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        CompoundTag compound2 = BiomassFluidEnergy.write((IBiomassFluidEnergy)stack.getCapability(BiomassFluidEnergy.BIOMASS_FLUID_ENERGY).orElseThrow(NullPointerException::new));
        compound.m_128365_("biomass", (Tag)compound2);
        return compound;
    }

    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("biomass")) {
            BiomassFluidEnergy.read((IBiomassFluidEnergy)stack.getCapability(BiomassFluidEnergy.BIOMASS_FLUID_ENERGY).orElseThrow(NullPointerException::new), nbt.m_128469_("biomass"));
        }
        super.readShareTag(stack, nbt);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == this.f_41377_) {
            items.add((Object)new ItemStack((ItemLike)ModItems.BIOMASSCONTAINER));
            ItemStack full = new ItemStack((ItemLike)ModItems.BIOMASSCONTAINER);
            BiomassFluidEnergy.getItemStackCap(full).setCurrentStorage(BiomassFluidEnergy.getItemStackCap(full).getMaxStorage());
            items.add((Object)full);
        }
    }
}

