/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CreditCardItem
extends Item {
    public CreditCardItem(Item.Properties property) {
        super(property);
    }

    public static boolean hasCredits(ItemStack stack) {
        CompoundTag nbt = CreditCardItem.getNBT(stack);
        return nbt.m_128441_("credits");
    }

    public static int getCredits(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof CreditCardItem && CreditCardItem.hasCredits(stack)) {
            return CreditCardItem.getNBT(stack).m_128451_("credits");
        }
        return 0;
    }

    public static CompoundTag getNBT(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            return nbt;
        }
        return new CompoundTag();
    }

    public static int addCredits(ItemStack stack, int amount) {
        int newValue = CreditCardItem.getCredits(stack) + amount;
        CreditCardItem.setCredits(stack, newValue);
        return newValue;
    }

    public static int shrinkCredits(ItemStack stack, int amount) {
        int newValue = Math.max(CreditCardItem.getCredits(stack) - amount, 0);
        CreditCardItem.setCredits(stack, newValue);
        return newValue;
    }

    public static void setCredits(ItemStack stack, int amount) {
        CompoundTag nbt = CreditCardItem.getNBT(stack);
        nbt.m_128405_("credits", amount);
        stack.m_41751_(nbt);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("Plantcredits: " + CreditCardItem.getCredits(stack)));
        super.m_7373_(stack, level, tooltip, flagIn);
    }
}

