/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CropSeedItem
extends Item {
    private final String entryName;
    private int TRAIT_MIN = 0;
    private int TRAIT_MAX = 1;

    public CropSeedItem(String entryName) {
        super(new Item.Properties().m_41491_(ModCreativeTabs.SEEDS));
        this.entryName = entryName;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                ServerLevel level = source.m_7727_();
                BlockPos target = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                this.m_123573_(CropSeedItem.plant((Level)level, target, stack));
                if (!level.m_5776_() && this.m_123570_()) {
                    level.m_46796_(2005, target, 0);
                }
                return stack;
            }
        });
    }

    public String getEntryName() {
        return this.entryName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            if (nbt.m_128471_("analysed")) {
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.type").getString() + ": " + nbt.m_128461_("type")));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.soil").getString() + ": " + CropSeedItem.getSoilString(nbt.m_128461_("type"))));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.temperature").getString() + ": ").m_7220_(CropSeedItem.temperatureString(nbt.m_128461_("type"), nbt.m_128451_("temperaturetolerance"))));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "growspeed") + new TranslatableComponent("info.growspeed").getString() + ": " + nbt.m_128451_("growspeed")));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "sensitivity") + new TranslatableComponent("info.sensitivity").getString() + ": " + nbt.m_128451_("sensitivity")));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "lightsensitivity") + new TranslatableComponent("info.needed_lightlevel").getString() + ": " + (14 - nbt.m_128451_("lightsensitivity"))));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "watersensitivity") + new TranslatableComponent("info.waterrange").getString() + ": " + (1 + nbt.m_128451_("watersensitivity"))));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "productivity") + new TranslatableComponent("info.productivity").getString() + ": " + nbt.m_128451_("productivity")));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "fertility") + new TranslatableComponent("info.fertility").getString() + ": " + nbt.m_128451_("fertility")));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "spreedingspeed") + new TranslatableComponent("info.spreedingspeed").getString() + ": " + nbt.m_128451_("spreedingspeed")));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "genestrenght") + new TranslatableComponent("info.genestrength").getString() + ": " + nbt.m_128451_("genestrenght")));
                tooltip.add((Component)new TextComponent(this.getTraitColor(nbt, "energyvalue") + new TranslatableComponent("info.energyvalue").getString() + ": " + nbt.m_128451_("energyvalue") * 20));
            } else {
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.type").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.soil").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.temperaturetolerance").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.growspeed").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.sensitivity").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.needed_lightlevel").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.waterrange").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.productivity").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.fertility").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.spreedingspeed").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.genestrength").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
                tooltip.add((Component)new TextComponent(new TranslatableComponent("info.energyvalue").getString() + ": " + new TranslatableComponent("info.unknown").getString()));
            }
        } else {
            tooltip.add((Component)new TextComponent(new TranslatableComponent("info.type").getString() + ": " + this.entryName));
            tooltip.add((Component)new TextComponent(new TranslatableComponent("info.soil").getString() + ": " + CropSeedItem.getSoilString(this.entryName)));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.growspeed").getString() + ": 0"));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.sensitivity").getString() + ": 0"));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.needed_lightlevel").getString() + ": 14"));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.waterrange").getString() + ": 1"));
            tooltip.add((Component)new TextComponent(new TranslatableComponent("info.temperaturetolerance").getString() + ": ").m_7220_(CropSeedItem.temperatureString(this.entryName, 0)));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.productivity").getString() + ": 0"));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.fertility").getString() + ": 0"));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.spreedingspeed").getString() + ": 0"));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.genestrength").getString() + ": 0"));
            tooltip.add((Component)new TextComponent(this.getTraitColor(this.TRAIT_MIN) + new TranslatableComponent("info.energyvalue").getString() + ": 20"));
        }
    }

    public static Component temperatureString(String type, int tolerance) {
        if (tolerance == 0) {
            return PlantTechMain.getCropList().getByName(type).getConfiguration().getTemperature().getDisplayString();
        }
        int id = PlantTechMain.getCropList().getByName(type).getConfiguration().getTemperature().ordinal();
        int min = id - tolerance;
        int max = id + tolerance;
        if (min < 0) {
            min = 0;
        }
        if (max > 4) {
            max = 4;
        }
        return EnumTemperature.values()[min].getDisplayString().m_130946_(" - ").m_7220_((Component)EnumTemperature.values()[max].getDisplayString());
    }

    public static String getSoilString(String type) {
        CropEntry soil = PlantTechMain.getCropList().getByName(type);
        return soil == null ? "" : new TranslatableComponent(soil.getConfiguration().getSoil().get().m_7705_()).m_6111_();
    }

    private ChatFormatting getTraitColor(CompoundTag nbt, String trait) {
        if (nbt.m_128451_(trait) == Objects.requireNonNull(EnumTraitsInt.getByName(trait)).getMax()) {
            return this.getTraitColor(this.TRAIT_MAX);
        }
        if (nbt.m_128451_(trait) == Objects.requireNonNull(EnumTraitsInt.getByName(trait)).getMin()) {
            return this.getTraitColor(this.TRAIT_MIN);
        }
        return ChatFormatting.RESET;
    }

    private ChatFormatting getTraitColor(int level) {
        if (level == this.TRAIT_MIN) {
            return ChatFormatting.GRAY;
        }
        if (level == this.TRAIT_MAX) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.RESET;
    }

    public static boolean plant(Level world, BlockPos pos, ItemStack stack) {
        CropEntry entry = PlantTechMain.getCropList().getBySeed(stack.m_41720_());
        if (entry == null) {
            return false;
        }
        world.m_46597_(pos, ModBlocks.CROPS.get(entry.getName()).m_49966_());
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CropsBlockEntity) {
            CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
            HashMapCropTraits toPass = new HashMapCropTraits();
            toPass.setType(entry.getName());
            if (stack.m_41782_()) {
                toPass.fromStack(stack);
            } else {
                toPass.setAnalysed(true);
            }
            cbe.setTraits(toPass);
            cbe.setStartTick();
            return true;
        }
        return false;
    }

    public static class ColorHandler
    implements ItemColor {
        public int m_92671_(ItemStack stack, int color) {
            return PlantTechMain.getCropList().getByName(((CropSeedItem)stack.m_41720_()).getEntryName()).getSeedColor();
        }
    }
}

