/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.energy.EnergyProvider;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageItem
extends Item
implements IItemChargeable {
    private int basecapacity;

    public EnergyStorageItem(Item.Properties property, int basecapacity) {
        super(property.m_41487_(1));
        this.basecapacity = basecapacity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new EnergyProvider(this.basecapacity);
    }

    @Override
    public int extractEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.extractEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int receiveEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.receiveEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int maxEnergy(ItemStack stack) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public int currentEnergy(ItemStack stack) {
        IEnergyStorage storage = EnergyStorageItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public static IEnergyStorage getEnergyCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityEnergy.ENERGY);
        if (provider.isPresent()) {
            return (IEnergyStorage)provider.orElse(null);
        }
        return null;
    }

    protected void updateEnergy(ItemStack stack) {
        IEnergyStorage storage;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        if ((storage = EnergyStorageItem.getEnergyCap(stack)) instanceof BioEnergyStorage) {
            tag.m_128405_("current_energy", ((BioEnergyStorage)storage).getEnergyStored());
            tag.m_128405_("max_energy", ((BioEnergyStorage)storage).getMaxEnergyStored());
        }
        stack.m_41751_(tag);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tooltip.add((Component)new TextComponent(tag.m_128451_("current_energy") + "/" + tag.m_128451_("max_energy") + " BE"));
        } else {
            this.updateEnergy(stack);
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return 1.0 - (double)tag.m_128451_("current_energy") / (double)tag.m_128451_("max_energy");
        }
        this.updateEnergy(stack);
        return 1.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Integer.parseInt("06bc00", 16);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == this.f_41377_) {
            items.add((Object)new ItemStack((ItemLike)this));
            ItemStack full = new ItemStack((ItemLike)this);
            this.receiveEnergy(full, this.maxEnergy(full), false);
            items.add((Object)full);
        }
    }
}

