/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import java.util.Random;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class FertilizerItem
extends Item {
    public FertilizerItem(CreativeModeTab group) {
        super(new Item.Properties().m_41491_(group));
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                ServerLevel level = source.m_7727_();
                BlockPos target = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                this.m_123573_(FertilizerItem.applyFertillizer((Level)level, target, stack));
                if (!level.m_5776_() && this.m_123570_()) {
                    level.m_46796_(2005, target, 0);
                }
                return stack;
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (!level.m_5776_() && FertilizerItem.applyFertillizer(level, pos, stack)) {
            if (context.m_43723_() != null && !context.m_43723_().m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }

    public static float getIncreaseChance(Item item) {
        if (item == ModItems.FERTILIZER_TIER_1) {
            return 0.05f;
        }
        if (item == ModItems.FERTILIZER_TIER_2) {
            return 0.15f;
        }
        if (item == ModItems.FERTILIZER_TIER_3) {
            return 0.35f;
        }
        if (item == ModItems.FERTILIZER_TIER_4) {
            return 0.75f;
        }
        if (item == ModItems.FERTILIZER_CREATIVE) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent(new TranslatableComponent("info.fertilizer").getString() + ": " + (int)(FertilizerItem.getIncreaseChance(stack.m_41720_()) * 100.0f) + "%"));
        if (stack.m_41720_() == ModItems.FERTILIZER_CREATIVE) {
            tooltip.add((Component)new TextComponent(new TranslatableComponent("info.fertilizer_creative").getString()));
        }
    }

    public static boolean applyFertillizer(Level world, BlockPos pos, ItemStack stack) {
        Block block = world.m_8055_(pos).m_60734_();
        if (block instanceof CropBaseBlock) {
            CropBaseBlock cbb = (CropBaseBlock)block;
            Random rand = new Random();
            if (rand.nextFloat() < FertilizerItem.getIncreaseChance(stack.m_41720_())) {
                if (stack.m_41720_() != ModItems.FERTILIZER_CREATIVE) {
                    BlockEntity blockEntity = world.m_7702_(pos);
                    if (blockEntity instanceof CropsBlockEntity) {
                        CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
                        cbb.updateCrop(world, pos, cbe.getTraits());
                    }
                } else {
                    cbb.updateCreative(world, pos);
                }
            }
            return true;
        }
        return false;
    }
}

