/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class KnowledgeChip
extends Item {
    private final int tier;
    private final int maxKnowledge;

    public KnowledgeChip(int tier, int maxKnowledge) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModCreativeTabs.MAIN));
        this.tier = tier;
        this.maxKnowledge = maxKnowledge;
    }

    public int getTier() {
        return this.tier;
    }

    public int getMaxKnowledge() {
        return this.maxKnowledge;
    }

    public static int getMaxTier() {
        return 5;
    }

    public static ItemStack addKnowledge(ItemStack stack, int amount, int maxTier) {
        KnowledgeChip chip;
        Item item;
        Item item2;
        if (!stack.m_41619_() && (item2 = (item = stack.m_41720_())) instanceof KnowledgeChip && (chip = (KnowledgeChip)item2).getTier() <= maxTier) {
            CompoundTag nbt = stack.m_41784_();
            int newknowledge = nbt.m_128441_("knowledge") ? nbt.m_128451_("knowledge") + amount : amount;
            if (newknowledge < chip.getMaxKnowledge()) {
                nbt.m_128405_("knowledge", newknowledge);
                stack.m_41751_(nbt);
            } else {
                ItemStack nextChip = KnowledgeChip.getByTier(chip.tier + 1);
                if (!nextChip.m_41619_()) {
                    return nextChip;
                }
                nbt.m_128405_("knowledge", chip.getMaxKnowledge());
                stack.m_41751_(nbt);
            }
        }
        return stack;
    }

    public static ItemStack getByTier(int tier) {
        switch (tier) {
            case 0: {
                return new ItemStack((ItemLike)ModItems.KNOWLEDGECHIP_TIER_0);
            }
            case 1: {
                return new ItemStack((ItemLike)ModItems.KNOWLEDGECHIP_TIER_1);
            }
            case 2: {
                return new ItemStack((ItemLike)ModItems.KNOWLEDGECHIP_TIER_2);
            }
            case 3: {
                return new ItemStack((ItemLike)ModItems.KNOWLEDGECHIP_TIER_3);
            }
            case 4: {
                return new ItemStack((ItemLike)ModItems.KNOWLEDGECHIP_TIER_4);
            }
            case 5: {
                return new ItemStack((ItemLike)ModItems.KNOWLEDGECHIP_TIER_5);
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("knowledge")) {
            tooltip.add((Component)new TextComponent(new TranslatableComponent("info.knowledge").getString() + ": " + nbt.m_128451_("knowledge") + "/" + this.getMaxKnowledge()));
        } else {
            tooltip.add((Component)new TextComponent(new TranslatableComponent("info.knowledge").getString() + ": 0/" + this.getMaxKnowledge()));
        }
    }
}

