/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.baseclasses.NaturalPlants;
import net.kaneka.planttech2.blocks.interfaces.IObtainable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PlantObtainerItem
extends Item {
    public PlantObtainerItem(Item.Properties property) {
        super(property.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IObtainable block;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21205_();
        PlantObtainerItem.initTags(stack);
        Block block2 = state.m_60734_();
        if (block2 instanceof IObtainable) {
            IObtainable block3 = (IObtainable)block2;
            if (!PlantObtainerItem.isFilled(stack) && block3.isObtainable(context)) {
                PlantObtainerItem.setBlockFilled(stack, block3.getObtainedBlockState(state));
                block3.onObtained(level, player, stack, pos);
                return InteractionResult.SUCCESS;
            }
        } else if (PlantObtainerItem.isFilled(stack) && ((NaturalPlants)((Object)(block = (IObtainable)PlantObtainerItem.getBlockStateFilled(stack).m_60734_()))).canPlaceAt(level, pos.m_142300_(context.m_43719_()))) {
            block.onReleased(context, PlantObtainerItem.getBlockStateFilled(stack));
            PlantObtainerItem.setBlockFilled(stack, null);
            PlantObtainerItem.setFilled(stack, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static ItemStack setBlockFilled(ItemStack stack, BlockState state) {
        CompoundTag compound;
        CompoundTag compoundTag = compound = stack.m_41782_() ? stack.m_41783_() : PlantObtainerItem.initTags(stack).m_41783_();
        if (state == Blocks.f_50016_.m_49966_() || state != null) {
            compound.m_128391_(NbtUtils.m_129202_((BlockState)state));
            PlantObtainerItem.setFilled(stack, true);
        } else {
            NbtUtils.m_129202_((BlockState)Blocks.f_50016_.m_49966_());
            PlantObtainerItem.setFilled(stack, false);
        }
        stack.m_41751_(compound);
        return stack;
    }

    public static BlockState getBlockStateFilled(ItemStack stack) {
        CompoundTag compound = stack.m_41782_() ? stack.m_41783_() : PlantObtainerItem.initTags(stack).m_41783_();
        BlockState state = NbtUtils.m_129241_((CompoundTag)compound);
        if (state.m_60734_() == Blocks.f_50016_) {
            return null;
        }
        PlantObtainerItem.setFilled(stack, true);
        return state;
    }

    public static ItemStack setFilled(ItemStack stack, boolean filled) {
        CompoundTag compound;
        CompoundTag compoundTag = compound = stack.m_41782_() ? stack.m_41783_() : PlantObtainerItem.initTags(stack).m_41783_();
        if (!filled) {
            compound.m_128391_(NbtUtils.m_129202_((BlockState)Blocks.f_50016_.m_49966_()));
        }
        compound.m_128379_("filled", filled);
        stack.m_41751_(compound);
        return stack;
    }

    public static boolean isFilled(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("filled") && PlantObtainerItem.getBlockStateFilled(stack) != null;
    }

    public static ItemStack initTags(ItemStack stack) {
        CompoundTag compound = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        stack.m_41751_(compound);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("Right click on an unique plants found planttopia to obtain and store it in the void"));
        tooltip.add((Component)new TextComponent("Right click again to get it back"));
        PlantObtainerItem.initTags(stack);
        if (PlantObtainerItem.isFilled(stack)) {
            tooltip.add((Component)new TextComponent("Plant Obtained: ").m_7220_((Component)PlantObtainerItem.getBlockStateFilled(stack).m_60734_().m_49954_().m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)))));
        } else {
            tooltip.add((Component)new TextComponent("Empty").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"BLUE")).m_131136_(Boolean.valueOf(true))));
        }
    }
}

