/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.inventory.ItemUpgradeableContainer;
import net.kaneka.planttech2.items.upgradeable.IUpgradeable;
import net.kaneka.planttech2.items.upgradeable.InventoryEnergyProvider;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BaseUpgradeableItem
extends Item
implements IItemChargeable,
IUpgradeable {
    private final int basecapacity;
    private final int maxInvSize;
    private final int slotId;
    private final float baseAttack;
    private final float baseAttackSpeed;

    public BaseUpgradeableItem(Item.Properties property, int basecapacity, int maxInvSize, float baseAttack, float baseAttackSpeed, int slotId) {
        super(property.m_41487_(1));
        this.basecapacity = basecapacity;
        this.maxInvSize = maxInvSize;
        this.baseAttack = baseAttack;
        this.baseAttackSpeed = baseAttackSpeed;
        this.slotId = slotId;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new InventoryEnergyProvider(this.basecapacity, this.maxInvSize);
    }

    @Override
    public int extractEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = BaseUpgradeableItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.extractEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int receiveEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = BaseUpgradeableItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.receiveEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int maxEnergy(ItemStack stack) {
        return BaseUpgradeableItem.getEnergyCap(stack, IEnergyStorage::getMaxEnergyStored, 0);
    }

    @Override
    public int currentEnergy(ItemStack stack) {
        return BaseUpgradeableItem.getEnergyCap(stack, IEnergyStorage::getEnergyStored, 0);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!((Player)attacker).m_150110_().f_35937_) {
            this.extractEnergy(stack, BaseUpgradeableItem.getEnergyCost(stack), false);
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f && !((Player)entityLiving).m_150110_().f_35937_) {
            this.extractEnergy(stack, BaseUpgradeableItem.getEnergyCost(stack), false);
            this.updateEnergy(stack);
        }
        return true;
    }

    protected static int getEnergyCost(ItemStack stack) {
        return 20 + NBTHelper.getInt(stack, "energycost", 0);
    }

    private double getAttackSpeed(ItemStack stack) {
        return Math.min((double)(this.baseAttackSpeed + NBTHelper.getFloat(stack, "attackspeed", 0)), -0.4);
    }

    private double getAttDamage(ItemStack stack) {
        return Math.min(this.baseAttack + NBTHelper.getFloat(stack, "attack", 0), UpgradeChipItem.getAttackMax());
    }

    public static <T> T getEnergyCap(ItemStack stack, Function<IEnergyStorage, T> getter, T defau1t) {
        IEnergyStorage cap = BaseUpgradeableItem.getEnergyCap(stack);
        if (cap != null) {
            return getter.apply(cap);
        }
        return defau1t;
    }

    @Nullable
    public static IEnergyStorage getEnergyCap(ItemStack stack) {
        return (IEnergyStorage)BaseUpgradeableItem.getCap(stack, CapabilityEnergy.ENERGY);
    }

    @Nullable
    public static IItemHandler getInvCap(ItemStack stack) {
        return (IItemHandler)BaseUpgradeableItem.getCap(stack, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Nullable
    private static <C> C getCap(ItemStack stack, Capability<C> cap) {
        return (C)stack.getCapability(cap).orElse(null);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", this.getAttDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected void updateEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        IEnergyStorage storage = BaseUpgradeableItem.getEnergyCap(stack);
        if (storage instanceof BioEnergyStorage) {
            tag.m_128405_("current_energy", storage.getEnergyStored());
            tag.m_128405_("max_energy", storage.getMaxEnergyStored());
        }
        stack.m_41751_(tag);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41784_();
        tooltip.add((Component)new TranslatableComponent("info.energy", new Object[]{tag.m_128451_("current_energy") + "/" + tag.m_128451_("max_energy")}));
        tooltip.add((Component)new TranslatableComponent("info.energycosts", new Object[]{BaseUpgradeableItem.getEnergyCost(stack)}));
        tooltip.add((Component)new TranslatableComponent("info.openwithshift"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !(this.getDurabilityForDisplay(stack) >= 1.0);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return 1.0 - (double)tag.m_128451_("current_energy") / (double)tag.m_128451_("max_energy");
        }
        return 1.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Integer.parseInt("06bc00", 16);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public static int getInventorySize(ItemStack stack) {
        IItemHandler handler = BaseUpgradeableItem.getInvCap(stack);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        Player player2;
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && !world.f_46443_ && (player2 = player) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player2;
            NetworkHooks.openGui((ServerPlayer)sp, (MenuProvider)new NamedContainerProvider(stack, player.m_150109_().f_35977_), buffer -> buffer.m_130055_(stack));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void updateNBTValues(ItemStack stack) {
        IItemHandler inv = BaseUpgradeableItem.getInvCap(stack);
        if (inv != null) {
            int energyCost = 0;
            int increaseCapacity = 0;
            int energyProduction = 0;
            int increaseHarvestlevel = 0;
            float increaseAttack = 0.0f;
            float increaseAttackSpeed = 0.0f;
            float increaseBreakdownRate = 0.0f;
            boolean unlockShovelFeat = false;
            boolean unlockAxeFeat = false;
            boolean unlockHoeFeat = false;
            boolean unlockShearsFeat = false;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (int i = 0; i < inv.getSlots(); ++i) {
                Item item;
                ItemStack slot = inv.getStackInSlot(i);
                if (slot.m_41619_() || !((item = slot.m_41720_()) instanceof UpgradeChipItem)) continue;
                UpgradeChipItem uci = (UpgradeChipItem)item;
                energyCost += uci.getEnergyCost();
                increaseCapacity += uci.getIncreaseCapacity();
                energyProduction += uci.getEnergyProduction();
                increaseHarvestlevel += uci.getIncreaseHarvestlevel();
                increaseAttack += uci.getIncreaseAttack();
                increaseAttackSpeed += uci.getIncreaseAttackSpeed();
                increaseBreakdownRate += uci.getIncreaseBreakdownRate();
                if (uci.isUnlockShovelFeat()) {
                    unlockShovelFeat = true;
                }
                if (uci.isUnlockAxeFeat()) {
                    unlockAxeFeat = true;
                }
                if (uci.isUnlockHoeFeat()) {
                    unlockHoeFeat = true;
                }
                if (uci.isUnlockShearsFeat()) {
                    unlockShearsFeat = true;
                }
                Enchantment ench = uci.getEnchantment();
                if (!uci.isAllowed(this.getSlotId()) || ench == null) continue;
                if (enchantments.containsKey(ench)) {
                    int nextlevel = (Integer)enchantments.get(ench) + 1;
                    enchantments.put(ench, nextlevel);
                    continue;
                }
                enchantments.put(ench, 1);
            }
            stack.m_41785_().clear();
            for (Enchantment ench : enchantments.keySet()) {
                int level = (Integer)enchantments.get(ench);
                stack.m_41663_(ench, Math.min(ench.m_6586_(), level));
            }
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128405_("energycost", energyCost);
            nbt.m_128405_("energyproduction", energyProduction);
            nbt.m_128405_("harvestlevel", increaseHarvestlevel);
            nbt.m_128350_("attack", increaseAttack);
            nbt.m_128350_("attackspeed", increaseAttackSpeed);
            nbt.m_128350_("breakdownrate", 0.5f + increaseBreakdownRate);
            nbt.m_128379_("unlockshovel", unlockShovelFeat);
            nbt.m_128379_("unlockaxe", unlockAxeFeat);
            nbt.m_128379_("unlockhoe", unlockHoeFeat);
            nbt.m_128379_("unlockshears", unlockShearsFeat);
            stack.m_41751_(nbt);
            IEnergyStorage energy = BaseUpgradeableItem.getEnergyCap(stack);
            if (energy != null && energy instanceof BioEnergyStorage) {
                ((BioEnergyStorage)energy).setEnergyMaxStored(this.basecapacity + increaseCapacity);
                this.updateEnergy(stack);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!world.f_46443_ && !stack.m_41619_() && world.m_46467_() % 200L == 0L) {
            this.receiveEnergy(stack, NBTHelper.getInt(stack, "energyproduction", 0), false);
        }
    }

    @Override
    public int getSlotId() {
        return this.slotId;
    }

    public static class NamedContainerProvider
    implements MenuProvider {
        private final int slot;
        private final ItemStack stack;

        public NamedContainerProvider(ItemStack stack, int slot) {
            this.stack = stack;
            this.slot = slot;
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inv, Player entity) {
            return new ItemUpgradeableContainer(id, inv, this.stack, this.slot);
        }

        public Component m_5446_() {
            return new TranslatableComponent("container.upgradeableitem");
        }
    }
}

