/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.items.upgradeable.UpgradeableHandItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolType;

public class MultitoolItem
extends UpgradeableHandItem {
    private static final Set<Block> EFFECTIVE_ON_SPADE = Set.of(Blocks.f_50129_, Blocks.f_50493_, Blocks.f_50546_, Blocks.f_50599_, Blocks.f_50093_, Blocks.f_50440_, Blocks.f_49994_, Blocks.f_50195_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_50127_, Blocks.f_50125_, Blocks.f_50135_, Blocks.f_152481_, Blocks.f_50506_, Blocks.f_50507_, Blocks.f_50508_, Blocks.f_50509_, Blocks.f_50510_, Blocks.f_50511_, Blocks.f_50512_, Blocks.f_50513_, Blocks.f_50514_, Blocks.f_50515_, Blocks.f_50516_, Blocks.f_50517_, Blocks.f_50518_, Blocks.f_50519_, Blocks.f_50573_, Blocks.f_50574_);
    private static final Set<Block> EFFECTIVE_ON_PICKAXE = Set.of(Blocks.f_50285_, Blocks.f_49997_, Blocks.f_50652_, Blocks.f_50031_, Blocks.f_50090_, Blocks.f_50089_, Blocks.f_50030_, Blocks.f_50074_, Blocks.f_49995_, Blocks.f_50126_, Blocks.f_50075_, Blocks.f_49996_, Blocks.f_50060_, Blocks.f_50059_, Blocks.f_50079_, Blocks.f_50134_, Blocks.f_50354_, Blocks.f_50568_, Blocks.f_50156_, Blocks.f_50173_, Blocks.f_50062_, Blocks.f_50063_, Blocks.f_50064_, Blocks.f_50395_, Blocks.f_50396_, Blocks.f_50394_, Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50175_, Blocks.f_50228_, Blocks.f_50281_, Blocks.f_50334_, Blocks.f_50387_, Blocks.f_50404_, Blocks.f_50406_, Blocks.f_50408_, Blocks.f_50409_, Blocks.f_50410_, Blocks.f_50411_, Blocks.f_50412_, Blocks.f_50413_, Blocks.f_50467_, Blocks.f_50469_, Blocks.f_50472_, Blocks.f_50473_, Blocks.f_50471_, Blocks.f_50470_, Blocks.f_50124_, Blocks.f_50165_);
    private static final Set<Block> EFFECTIVE_ON_AXE = Set.of(Blocks.f_50705_, Blocks.f_50741_, Blocks.f_50742_, Blocks.f_50743_, Blocks.f_50744_, Blocks.f_50745_, Blocks.f_50078_, Blocks.f_50011_, Blocks.f_50012_, Blocks.f_50013_, Blocks.f_50014_, Blocks.f_50015_, Blocks.f_50043_, Blocks.f_49999_, Blocks.f_50000_, Blocks.f_50001_, Blocks.f_50002_, Blocks.f_50003_, Blocks.f_50004_, Blocks.f_50087_, Blocks.f_50133_, Blocks.f_50143_, Blocks.f_50144_, Blocks.f_50186_, Blocks.f_50155_, Blocks.f_50251_, Blocks.f_50252_, Blocks.f_50253_, Blocks.f_50254_, Blocks.f_50309_, Blocks.f_50308_, Blocks.f_50167_, Blocks.f_50168_, Blocks.f_50169_, Blocks.f_50170_, Blocks.f_50172_, Blocks.f_50171_);
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).build();
    protected static final Map<Block, BlockState> PATH_MAP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.f_50440_, (Object)Blocks.f_152481_.m_49966_()));
    protected static final Map<Block, BlockState> FARMLAND_MAP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.f_50440_, (Object)Blocks.f_50093_.m_49966_(), (Object)Blocks.f_152481_, (Object)Blocks.f_50093_.m_49966_(), (Object)Blocks.f_50493_, (Object)Blocks.f_50093_.m_49966_(), (Object)Blocks.f_50546_, (Object)Blocks.f_50493_.m_49966_()));
    protected static final Set<Material> MATERIAL_EFFECT_ON = Sets.newHashSet((Object[])new Material[]{Material.f_76279_, Material.f_76281_, Material.f_76278_, Material.f_76320_, Material.f_76300_});

    public MultitoolItem() {
        super(new Item.Properties().m_41491_(ModCreativeTabs.TOOLS_AND_ARMOR), 10000, 10, 2.0f, 2.4f, UpgradeChipItem.TOOL);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        if (this.extractEnergy(stack, MultitoolItem.getEnergyCost(stack), true) >= MultitoolItem.getEnergyCost(stack)) {
            Block block = state.m_60734_();
            int i = this.getHarvestLevel(stack);
            if (state.getHarvestTool() == ToolType.PICKAXE) {
                return i >= state.getHarvestLevel();
            }
            Material material = state.m_60767_();
            return material == Material.f_76278_ || material == Material.f_76279_ || material == Material.f_76281_ || block == Blocks.f_50125_ || block == Blocks.f_50127_ || block == Blocks.f_50033_;
        }
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.extractEnergy(stack, MultitoolItem.getEnergyCost(stack), true) >= MultitoolItem.getEnergyCost(stack)) {
            Material material = state.m_60767_();
            if (EFFECTIVE_ON_AXE.contains(state.m_60734_()) || EFFECTIVE_ON_PICKAXE.contains(state.m_60734_()) || EFFECTIVE_ON_SPADE.contains(state.m_60734_())) {
                return this.getEfficiency(stack);
            }
            if (state.m_60734_() == Blocks.f_50033_) {
                return 15.0f;
            }
            return !MATERIAL_EFFECT_ON.contains(material) ? super.m_8102_(stack, state) : this.getEfficiency(stack);
        }
        return super.m_8102_(stack, state);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (this.extractEnergy(ctx.m_43722_(), MultitoolItem.getEnergyCost(ctx.m_43722_()), true) >= MultitoolItem.getEnergyCost(ctx.m_43722_())) {
            Level level = ctx.m_43725_();
            BlockPos blockpos = ctx.m_8083_();
            BlockState state = level.m_8055_(blockpos);
            BlockState state_for_spade = PATH_MAP.get(level.m_8055_(blockpos).m_60734_());
            BlockState state_for_hoe = FARMLAND_MAP.get(level.m_8055_(blockpos).m_60734_());
            Block block_for_strinping = BLOCK_STRIPPING_MAP.get(state.m_60734_());
            Player PlayerEntity = ctx.m_43723_();
            if (ctx.m_43719_() != Direction.DOWN && level.m_8055_(blockpos.m_7494_()).m_60795_() && state_for_spade != null) {
                if (NBTHelper.getBoolean(ctx.m_43722_(), "unlockshovel", false)) {
                    level.m_5594_(PlayerEntity, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!level.f_46443_) {
                        level.m_7731_(blockpos, state_for_spade, 11);
                        if (PlayerEntity != null && !PlayerEntity.m_7500_()) {
                            this.extractEnergy(ctx.m_43722_(), MultitoolItem.getEnergyCost(ctx.m_43722_()), false);
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (block_for_strinping != null) {
                if (NBTHelper.getBoolean(ctx.m_43722_(), "unlockaxe", false)) {
                    level.m_5594_(PlayerEntity, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!level.f_46443_) {
                        level.m_7731_(blockpos, (BlockState)block_for_strinping.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))), 11);
                        if (PlayerEntity != null && !PlayerEntity.m_7500_()) {
                            this.extractEnergy(ctx.m_43722_(), MultitoolItem.getEnergyCost(ctx.m_43722_()), false);
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (ctx.m_43719_() != Direction.DOWN && level.m_46859_(blockpos.m_7494_()) && state_for_hoe != null && NBTHelper.getBoolean(ctx.m_43722_(), "unlockhoe", false)) {
                level.m_5594_(PlayerEntity, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.f_46443_) {
                    level.m_7731_(blockpos, state_for_hoe, 11);
                    if (PlayerEntity != null && !PlayerEntity.m_7500_()) {
                        this.extractEnergy(ctx.m_43722_(), MultitoolItem.getEnergyCost(ctx.m_43722_()), false);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public int getHarvestLevel(ItemStack stack) {
        return NBTHelper.getInt(stack, "harvestlevel", 0);
    }

    public float getEfficiency(ItemStack stack) {
        return Math.min(NBTHelper.getFloat(stack, "breakdownrate", 4), UpgradeChipItem.getBreakdownRateMax());
    }

    @Override
    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return super.m_6813_(stack, level, state, pos, entityLiving);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        LivingEntity livingEntity = entity;
        if (livingEntity instanceof IForgeShearable) {
            IForgeShearable fs = (IForgeShearable)livingEntity;
            BlockPos pos = new BlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (fs.isShearable(stack, entity.f_19853_, pos)) {
                List drops = fs.onSheared(player, stack, entity.f_19853_, pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                stack.m_41622_(1, entity, e -> e.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

