/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.configuration.PlantTech2Configuration;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class UpgradeChipItem
extends Item {
    public static int HELMET = 0;
    public static int CHEST = 1;
    public static int LEGGINGS = 2;
    public static int BOOTS = 3;
    public static int RANGED_WEAPON = 4;
    public static int MELEE_WEAPON = 5;
    public static int TOOL = 6;
    private int energyCost = 0;
    private int increaseCapacity = 0;
    private int energyProduction = 0;
    private int increaseHarvestlevel = 0;
    private int increaseArmor = 0;
    private float increaseAttack = 0.0f;
    private float increaseAttackSpeed = 0.0f;
    private float increaseBreakdownRate = 0.0f;
    private float increaseToughness = 0.0f;
    private boolean unlockShovelFeat = false;
    private boolean unlockAxeFeat = false;
    private boolean unlockHoeFeat = false;
    private boolean unlockShearFeat = false;
    private Enchantment enchantment;
    private final List<Integer> restrictions = new ArrayList<Integer>();

    public UpgradeChipItem(String name) {
        super(new Item.Properties().m_41491_(ModCreativeTabs.CHIPS));
    }

    public int getEnergyCost() {
        return (int)((double)this.energyCost * (Double)PlantTech2Configuration.MULTIPLIER_ENERGYCOSTS.get());
    }

    public UpgradeChipItem setEnergyCost(int energyCost) {
        this.energyCost = energyCost;
        return this;
    }

    public int getIncreaseCapacity() {
        return (int)((double)this.increaseCapacity * (Double)PlantTech2Configuration.MULTIPLIER_CAPACITY.get());
    }

    public UpgradeChipItem setIncreaseCapacity(int increaseCapacity) {
        this.increaseCapacity = increaseCapacity;
        return this;
    }

    public static int getCapacityMax() {
        return (int)(50000.0 * (Double)PlantTech2Configuration.MULTIPLIER_CAPACITY_MAX.get());
    }

    public int getEnergyProduction() {
        return (int)((double)this.energyProduction * (Double)PlantTech2Configuration.MULTIPLIER_ENERGYPRODUCTION.get());
    }

    public UpgradeChipItem setEnergyProduction(int energyProduction) {
        this.energyProduction = energyProduction;
        return this;
    }

    public int getIncreaseHarvestlevel() {
        return this.increaseHarvestlevel;
    }

    public UpgradeChipItem setIncreaseHarvestlevel(int increaseHarvestlevel) {
        this.increaseHarvestlevel = increaseHarvestlevel;
        return this;
    }

    public float getIncreaseAttack() {
        return (float)((double)this.increaseAttack * (Double)PlantTech2Configuration.MULTIPLIER_ATTACK.get());
    }

    public UpgradeChipItem setIncreaseAttack(float increaseAttack) {
        this.increaseAttack = increaseAttack;
        return this;
    }

    public static float getAttackMax() {
        return (float)(20.0 * (Double)PlantTech2Configuration.MULTIPLIER_ATTACK_MAX.get());
    }

    public float getIncreaseAttackSpeed() {
        return (float)((double)this.increaseAttackSpeed * (Double)PlantTech2Configuration.MULTIPLIER_ATTACKSPEED.get());
    }

    public UpgradeChipItem setIncreaseAttackSpeed(float increaseAttackSpeed) {
        this.increaseAttackSpeed = increaseAttackSpeed;
        return this;
    }

    public static float getAttackSpeedMax() {
        return (float)(2.0 * (Double)PlantTech2Configuration.MULTIPLIER_ATTACKSPEED_MAX.get());
    }

    public float getIncreaseBreakdownRate() {
        return (float)((double)this.increaseBreakdownRate * (Double)PlantTech2Configuration.MULTIPLIER_BREAKDOWNRATE.get());
    }

    public UpgradeChipItem setIncreaseBreakdownRate(float increaseBreakdownRate) {
        this.increaseBreakdownRate = increaseBreakdownRate;
        return this;
    }

    public static float getBreakdownRateMax() {
        return (float)(10.0 * (Double)PlantTech2Configuration.MULTIPLIER_BREAKDOWNRATE_MAX.get());
    }

    public UpgradeChipItem setIncreaseArmor(int increaseArmor) {
        this.increaseArmor = increaseArmor;
        return this;
    }

    public int getIncreaseArmor() {
        return (int)((double)this.increaseArmor * (Double)PlantTech2Configuration.MULTIPLIER_ARMOR.get());
    }

    public UpgradeChipItem setIncreaseToughness(float increaseToughness) {
        this.increaseToughness = increaseToughness;
        return this;
    }

    public float getIncreaseToughness() {
        return (float)((double)this.increaseToughness * (Double)PlantTech2Configuration.MULTIPLIER_THOUGHNESS.get());
    }

    public static float getToughnessMax() {
        return (float)(6.0 * (Double)PlantTech2Configuration.MULTIPLIER_THOUGHNESS_MAX.get());
    }

    public boolean isUnlockShovelFeat() {
        return this.unlockShovelFeat;
    }

    public UpgradeChipItem setUnlockShovelFeat() {
        this.unlockShovelFeat = true;
        return this;
    }

    public boolean isUnlockAxeFeat() {
        return this.unlockAxeFeat;
    }

    public UpgradeChipItem setUnlockAxeFeat() {
        this.unlockAxeFeat = true;
        return this;
    }

    public boolean isUnlockHoeFeat() {
        return this.unlockHoeFeat;
    }

    public UpgradeChipItem setUnlockHoeFeat() {
        this.unlockHoeFeat = true;
        return this;
    }

    public boolean isUnlockShearsFeat() {
        return this.unlockShearFeat;
    }

    public UpgradeChipItem setUnlockShearsFeat() {
        this.unlockShearFeat = true;
        return this;
    }

    public UpgradeChipItem setEnchantment(Enchantment ench) {
        this.enchantment = ench;
        return this;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public UpgradeChipItem addRestriction(int ... ids) {
        for (int id : ids) {
            this.restrictions.add(id);
        }
        return this;
    }

    public boolean isAllowed(int id) {
        if (this.restrictions.isEmpty()) {
            return true;
        }
        return this.restrictions.contains(id);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.increaseCapacity > 0) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increasecapacity", new Object[]{this.getIncreaseCapacity()}));
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increasecapacitymax", new Object[]{UpgradeChipItem.getCapacityMax()}));
        }
        if (this.energyProduction > 0) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.energyproduction", new Object[]{this.getEnergyProduction()}));
        }
        if (this.increaseHarvestlevel > 0) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increaseharvestlevel", new Object[]{this.increaseHarvestlevel}));
        }
        if (this.increaseArmor > 0) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increasearmor", new Object[]{this.getIncreaseArmor()}));
        }
        if (this.increaseAttack > 0.0f) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increaseattack", new Object[]{Float.valueOf(this.getIncreaseAttack())}));
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increaseattackmax", new Object[]{Float.valueOf(UpgradeChipItem.getAttackMax())}));
        }
        if (this.increaseAttackSpeed > 0.0f) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increaseattackspeed", new Object[]{Float.valueOf(this.getIncreaseAttackSpeed())}));
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increaseattackspeedmax", new Object[]{Float.valueOf(UpgradeChipItem.getAttackSpeedMax())}));
        }
        if (this.increaseBreakdownRate > 0.0f) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increasebreakdownrate", new Object[]{Float.valueOf(this.getIncreaseBreakdownRate())}));
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increasebreakdownratemax", new Object[]{Float.valueOf(UpgradeChipItem.getBreakdownRateMax())}));
        }
        if (this.increaseToughness > 0.0f) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increasetougness", new Object[]{Float.valueOf(this.getIncreaseToughness())}));
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.increasetougnessmax", new Object[]{Float.valueOf(UpgradeChipItem.getToughnessMax())}));
        }
        if (this.unlockAxeFeat) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.unlockaxefeat"));
        }
        if (this.unlockShovelFeat) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.unlockshovelfeat"));
        }
        if (this.unlockShearFeat) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.unlockshearsfeat"));
        }
        if (this.unlockHoeFeat) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.unlockhoefeat"));
        }
        if (this.enchantment != null) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.add").m_130946_(" ").m_7220_(this.enchantment.m_44700_(0)));
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.stackable"));
        }
        if (this.energyCost > 0) {
            tooltip.add((Component)new TranslatableComponent("info.upgradechip.energycosts", new Object[]{this.getEnergyCost()}));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }
}

