/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.items.armors.ArmorBaseItem;
import net.kaneka.planttech2.items.armors.CustomArmorMaterial;
import net.kaneka.planttech2.items.upgradeable.BaseUpgradeableItem;
import net.kaneka.planttech2.items.upgradeable.IUpgradeable;
import net.kaneka.planttech2.items.upgradeable.InventoryEnergyProvider;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class UpgradeableArmorItem
extends ArmorBaseItem
implements IItemChargeable,
IUpgradeable {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private int basecapacity;
    private int maxInvSize;
    private int baseDamageReduction;
    private int slotId;
    private float baseToughness;

    public UpgradeableArmorItem(String resname, EquipmentSlot slot, int basecapacity, int maxInvSize, int baseDamageReduction, float baseToughness, int slotId) {
        super(resname, CustomArmorMaterial.UNNECESSARY, slot, new Item.Properties().m_41491_(ModCreativeTabs.TOOLS_AND_ARMOR));
        this.basecapacity = basecapacity;
        this.maxInvSize = maxInvSize;
        this.baseDamageReduction = baseDamageReduction;
        this.baseToughness = baseToughness;
        this.slotId = slotId;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new InventoryEnergyProvider(this.basecapacity, this.maxInvSize);
    }

    public void updateEnergy(ItemStack stack) {
        IEnergyStorage storage;
        IEnergyStorage iEnergyStorage;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        if ((iEnergyStorage = (storage = UpgradeableArmorItem.getEnergyCap(stack))) instanceof BioEnergyStorage) {
            BioEnergyStorage bes = (BioEnergyStorage)iEnergyStorage;
            tag.m_128405_("current_energy", bes.getEnergyStored());
            tag.m_128405_("max_energy", bes.getMaxEnergyStored());
        }
        stack.m_41751_(tag);
    }

    @Override
    public int receiveEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.receiveEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.extractEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int maxEnergy(ItemStack stack) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public int currentEnergy(ItemStack stack) {
        IEnergyStorage storage = UpgradeableArmorItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public static IEnergyStorage getEnergyCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityEnergy.ENERGY);
        if (provider != null) {
            return (IEnergyStorage)provider.orElse(null);
        }
        return null;
    }

    public static IItemHandler getInvCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (provider != null) {
            return (IItemHandler)provider.orElse(null);
        }
        return null;
    }

    public static int getEnergyCost(ItemStack stack) {
        return 20 + NBTHelper.getInt(stack, "energycost", 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !(this.getDurabilityForDisplay(stack) >= 1.0);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return 1.0 - (double)tag.m_128451_("current_energy") / (double)tag.m_128451_("max_energy");
        }
        return 1.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Integer.parseInt("06bc00", 16);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public static int getInventorySize(ItemStack stack) {
        IItemHandler handler = UpgradeableArmorItem.getInvCap(stack);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        Player player2;
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && !world.f_46443_ && (player2 = player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new BaseUpgradeableItem.NamedContainerProvider(stack, player.m_150109_().f_35977_), buffer -> buffer.m_130055_(stack));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void updateNBTValues(ItemStack stack) {
        IItemHandler inv = UpgradeableArmorItem.getInvCap(stack);
        if (inv != null) {
            IEnergyStorage iEnergyStorage;
            int energyCost = 0;
            int increaseCapacity = 0;
            int energyProduction = 0;
            int increaseArmor = 0;
            float increaseToughness = 0.0f;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (int i = 0; i < inv.getSlots(); ++i) {
                Item item;
                ItemStack slot = inv.getStackInSlot(i);
                if (slot.m_41619_() || !((item = slot.m_41720_()) instanceof UpgradeChipItem)) continue;
                UpgradeChipItem item2 = (UpgradeChipItem)item;
                energyCost += item2.getEnergyCost();
                increaseCapacity += item2.getIncreaseCapacity();
                energyProduction += item2.getEnergyProduction();
                increaseArmor += item2.getIncreaseArmor();
                increaseToughness += item2.getIncreaseToughness();
                Enchantment ench = item2.getEnchantment();
                if (!item2.isAllowed(this.getSlotId()) || ench == null) continue;
                if (enchantments.containsKey(ench)) {
                    int nextlevel = (Integer)enchantments.get(ench) + 1;
                    enchantments.put(ench, nextlevel);
                    continue;
                }
                enchantments.put(ench, 1);
            }
            stack.m_41785_().clear();
            for (Enchantment ench : enchantments.keySet()) {
                int level = (Integer)enchantments.get(ench);
                if (ench.m_6586_() < level) {
                    stack.m_41663_(ench, ench.m_6586_());
                    continue;
                }
                stack.m_41663_(ench, level);
            }
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            nbt.m_128405_("energycost", energyCost);
            nbt.m_128405_("energyproduction", energyProduction);
            nbt.m_128405_("increasearmor", increaseArmor);
            nbt.m_128350_("increasetoughness", increaseToughness);
            stack.m_41751_(nbt);
            IEnergyStorage energy = UpgradeableArmorItem.getEnergyCap(stack);
            if (energy != null && (iEnergyStorage = energy) instanceof BioEnergyStorage) {
                BioEnergyStorage bes = (BioEnergyStorage)iEnergyStorage;
                bes.setEnergyMaxStored(this.basecapacity + increaseCapacity);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == this.f_40377_) {
            multimap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.m_20749_()], "Armor modifier", (double)this.getDamageReduceAmount(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.m_20749_()], "Armor toughness", (double)this.getToughness(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int getDamageReduceAmount(ItemStack stack) {
        return this.baseDamageReduction + NBTHelper.getInt(stack, "increasearmor", 0);
    }

    public float getToughness(ItemStack stack) {
        return this.baseToughness + NBTHelper.getFloat(stack, "increasetoughness", 0);
    }

    public boolean m_41465_() {
        return false;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_ && !stack.m_41619_() && world.m_46467_() % 200L == 0L) {
            this.receiveEnergy(stack, NBTHelper.getInt(stack, "energyproduction", 0), false);
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tooltip.add((Component)new TranslatableComponent("info.energy", new Object[]{tag.m_128451_("current_energy") + "/" + tag.m_128451_("max_energy")}));
            tooltip.add((Component)new TranslatableComponent("info.energycosts", new Object[]{UpgradeableArmorItem.getEnergyCost(stack)}));
            tooltip.add((Component)new TranslatableComponent("info.openwithshift"));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    @Override
    public int getSlotId() {
        return this.slotId;
    }
}

