/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class CropConfigChangeMessage {
    private final Map<ResourceLocation, CropEntryConfigData> configData;

    public CropConfigChangeMessage(Map<ResourceLocation, CropEntryConfigData> configData) {
        this.configData = configData;
    }

    public static void encode(CropConfigChangeMessage pkt, FriendlyByteBuf buf) {
        buf.m_130130_(pkt.configData.size());
        for (Map.Entry<ResourceLocation, CropEntryConfigData> entry : pkt.configData.entrySet()) {
            buf.m_130085_(entry.getKey());
            CropEntryConfigData.Serializer.INSTANCE.write(entry.getValue(), buf);
        }
    }

    public static CropConfigChangeMessage decode(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, CropEntryConfigData> configData = new HashMap<ResourceLocation, CropEntryConfigData>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation name = buf.m_130281_();
            configData.put(name, CropEntryConfigData.Serializer.INSTANCE.read(buf));
        }
        return new CropConfigChangeMessage(configData);
    }

    public static void handle(CropConfigChangeMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlantTechMain.LOGGER.debug("Syncing crop configurations from server");
            PlantTechMain.getCropList().configureFromConfigData(pkt.configData.values());
        });
        ctx.get().setPacketHandled(true);
    }
}

