/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import java.util.function.Supplier;
import net.kaneka.planttech2.blocks.entity.machine.PlantTopiaTeleporterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class TeleporterBlockButtonPressMessage {
    private final int x;
    private final int y;
    private final int z;
    private final int buttonId;

    public TeleporterBlockButtonPressMessage(int x, int y, int z, int buttonId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.buttonId = buttonId;
    }

    public static void encode(TeleporterBlockButtonPressMessage pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.x);
        buf.writeInt(pkt.y);
        buf.writeInt(pkt.z);
        buf.writeInt(pkt.buttonId);
    }

    public static TeleporterBlockButtonPressMessage decode(FriendlyByteBuf buf) {
        return new TeleporterBlockButtonPressMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(TeleporterBlockButtonPressMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity tbe$temp;
            BlockEntity te;
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos pos = new BlockPos(pkt.x, pkt.y, pkt.z);
            if (serverPlayer != null && serverPlayer.f_19853_.isAreaLoaded(pos, 0) && (te = serverPlayer.f_19853_.m_7702_(pos)) != null && (tbe$temp = te) instanceof PlantTopiaTeleporterBlockEntity) {
                PlantTopiaTeleporterBlockEntity tbe = (PlantTopiaTeleporterBlockEntity)tbe$temp;
                tbe.doTeleportation();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

