/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.utilities.TagUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChipalyzerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack chip;
    private final ItemStack input;
    @Nullable
    private final Enchantment enchantment;
    private final ItemStack output;

    public ChipalyzerRecipe(ResourceLocation id, ItemStack chip, @Nullable ItemStack input, @Nullable Enchantment enchantment, ItemStack output) {
        this.id = id;
        this.chip = chip;
        this.input = input == null ? new ItemStack((ItemLike)Items.f_41852_) : input;
        this.enchantment = enchantment;
        this.output = output;
    }

    public ItemStack getChip() {
        return this.chip;
    }

    public ItemStack getInput() {
        return this.input;
    }

    @Nullable
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean compare(ItemStack chip, ItemStack stack) {
        if (!stack.m_41619_() && !chip.m_41619_()) {
            List<Enchantment> stackench;
            if (this.enchantment != null && (stackench = this.getEnchList(stack)).contains(this.enchantment)) {
                return true;
            }
            if (!this.input.m_41619_()) {
                return this.input.m_41720_() == stack.m_41720_();
            }
        }
        return false;
    }

    public List<Enchantment> getEnchList(ItemStack stack) {
        ArrayList<Enchantment> list;
        block4: {
            list = new ArrayList<Enchantment>();
            if (stack == null || stack.m_41619_()) break block4;
            if (stack.m_41720_() == Items.f_42690_) {
                for (Tag nbt : EnchantedBookItem.m_41163_((ItemStack)stack)) {
                    CompoundTag compoundTag;
                    Tag tag = nbt;
                    if (!(tag instanceof CompoundTag) || !(compoundTag = (CompoundTag)tag).m_128441_("id") || !ForgeRegistries.ENCHANTMENTS.containsKey(new ResourceLocation(compoundTag.m_128461_("id")))) continue;
                    list.add((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(compoundTag.m_128461_("id"))));
                }
            } else {
                for (Enchantment entry : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
                    list.add(entry);
                }
            }
        }
        return list;
    }

    public boolean compareEnchantment(ListTag nbt) {
        return this.input.m_41785_() == nbt;
    }

    public List<ItemStack> getComponents() {
        ArrayList<ItemStack> components = new ArrayList<ItemStack>();
        components.add(this.chip);
        if (this.input == ItemStack.f_41583_) {
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            book.m_41663_(this.enchantment, 1);
            components.add(book);
        } else {
            components.add(this.input);
        }
        return components;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.input.m_41720_() == inv.m_8020_(0).m_41720_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return width == height && width == 1;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.CHIPALYZER;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.CHIPALYZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ChipalyzerRecipe> {
        public ChipalyzerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputobject;
            ItemStack chip = ItemStack.f_41583_;
            if (json.has("chip") && (inputobject = json.getAsJsonObject("chip")).has("item")) {
                chip = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("item").getAsString())));
            }
            ItemStack input = ItemStack.f_41583_;
            Enchantment enchantment = null;
            if (json.has("input")) {
                ResourceLocation namespaced_id;
                JsonObject inputobject2 = json.getAsJsonObject("input");
                if (inputobject2.has("item")) {
                    input = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject2.get("item").getAsString())));
                } else if (inputobject2.has("block")) {
                    input = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject2.get("block").getAsString())));
                } else if (inputobject2.has("tag")) {
                    input = new ItemStack((ItemLike)TagUtils.getAnyTagItem(new ResourceLocation(inputobject2.get("tag").getAsString())));
                }
                if (inputobject2.has("enchantment") && ForgeRegistries.ENCHANTMENTS.containsKey(namespaced_id = new ResourceLocation(inputobject2.get("enchantment").getAsString()))) {
                    enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(namespaced_id);
                }
            }
            JsonObject resultobject = json.getAsJsonObject("result");
            Item result = null;
            if (resultobject.has("item")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("item").getAsString()));
            } else if (resultobject.has("block")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("block").getAsString()));
            } else if (resultobject.has("tag")) {
                result = TagUtils.getAnyTagItem(new ResourceLocation(resultobject.get("tag").getAsString()));
            }
            if (result != null) {
                return new ChipalyzerRecipe(recipeId, chip, input, enchantment, new ItemStack((ItemLike)result));
            }
            throw new IllegalStateException("Item did not exist:" + recipeId.toString());
        }

        public ChipalyzerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack chip = buffer.m_130267_();
            ItemStack input = buffer.m_130267_();
            String ench = buffer.m_130277_();
            Enchantment enchantment = null;
            if (!ench.equals("null")) {
                enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(ench));
            }
            ItemStack result = buffer.m_130267_();
            return new ChipalyzerRecipe(recipeId, chip, input, enchantment, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, ChipalyzerRecipe recipe) {
            buffer.m_130055_(recipe.chip);
            buffer.m_130055_(recipe.input);
            if (recipe.enchantment != null) {
                buffer.m_130070_(recipe.enchantment.getRegistryName().toString());
            } else {
                buffer.m_130070_("null");
            }
            buffer.m_130055_(recipe.output);
        }
    }
}

