/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonObject;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.utilities.TagUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CompressorRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack input;
    private final ItemStack output;

    public CompressorRecipe(ResourceLocation id, ItemStack input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.input.m_41720_() == inv.m_8020_(0).m_41720_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output.m_41777_();
    }

    public ItemStack getInput() {
        return this.input.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public int getAmountInput() {
        return this.input.m_41613_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.COMPRESSOR;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.COMPRESSING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CompressorRecipe> {
        public CompressorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputobject = json.getAsJsonObject("input");
            Item inputitem = null;
            Potion effect = null;
            Enchantment enchantType = null;
            int enchantLevel = 0;
            if (inputobject.has("item")) {
                inputitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("item").getAsString()));
            } else if (inputobject.has("block")) {
                inputitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("block").getAsString()));
            } else if (inputobject.has("tag")) {
                inputitem = TagUtils.getAnyTagItem(new ResourceLocation(inputobject.get("tag").getAsString()));
            }
            ItemStack inputstack = null;
            if (inputitem != null) {
                inputstack = new ItemStack((ItemLike)inputitem, GsonHelper.m_13824_((JsonObject)inputobject, (String)"amount", (int)1));
            }
            JsonObject resultobject = json.getAsJsonObject("result");
            Item resultitem = null;
            if (resultobject.has("item")) {
                resultitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("item").getAsString()));
                if (resultobject.has("potion_effect")) {
                    effect = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(resultobject.get("potion_effect").getAsString()));
                }
                if (resultobject.has("enchantment")) {
                    JsonObject enchantment = resultobject.getAsJsonObject("enchantment");
                    enchantType = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantment.get("type").getAsString()));
                    enchantLevel = GsonHelper.m_13824_((JsonObject)enchantment, (String)"level", (int)1);
                }
            } else if (resultobject.has("block")) {
                resultitem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("block").getAsString()));
            } else if (resultobject.has("tag")) {
                resultitem = TagUtils.getAnyTagItem(new ResourceLocation(resultobject.get("tag").getAsString()));
            }
            ItemStack resultstack = null;
            if (resultitem != null) {
                resultstack = new ItemStack((ItemLike)resultitem, GsonHelper.m_13824_((JsonObject)resultobject, (String)"amount", (int)1));
                if (effect != null) {
                    PotionUtils.m_43549_((ItemStack)resultstack, (Potion)effect);
                } else if (enchantType != null) {
                    resultstack.m_41663_(enchantType, enchantLevel);
                }
            }
            if (inputstack != null && resultstack != null) {
                return new CompressorRecipe(recipeId, inputstack, resultstack);
            }
            throw new IllegalStateException("Item did not exist:" + recipeId.toString());
        }

        public CompressorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack input = buffer.m_130267_();
            ItemStack result = buffer.m_130267_();
            return new CompressorRecipe(recipeId, input, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, CompressorRecipe recipe) {
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.output);
        }
    }
}

