/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.recipes.recipeclasses;

import com.google.gson.JsonObject;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.utilities.TagUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfuserRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Item input;
    private final Item output;
    private final int biomass;

    public InfuserRecipe(ResourceLocation id, Item input, Item output, int biomass) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.biomass = biomass;
    }

    public Item getInput() {
        return this.input;
    }

    public ItemStack getInputStack() {
        return new ItemStack((ItemLike)this.input);
    }

    public Item getOutput() {
        return this.output;
    }

    public int getBiomass() {
        return this.biomass;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.input.m_5456_() == inv.m_8020_(0).m_41720_();
    }

    public ItemStack m_5874_(Container inv) {
        return new ItemStack((ItemLike)this.output);
    }

    public boolean m_8004_(int width, int height) {
        return width == height && width == 1;
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.output);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.INFUSER;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.INFUSING;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<InfuserRecipe> {
        public InfuserRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputobject = json.getAsJsonObject("input");
            Item input = null;
            if (inputobject.has("item")) {
                input = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("item").getAsString()));
            } else if (inputobject.has("block")) {
                input = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inputobject.get("block").getAsString()));
            } else if (inputobject.has("tag")) {
                input = TagUtils.getAnyTagItem(new ResourceLocation(inputobject.get("tag").getAsString()));
            }
            int biomass = inputobject.get("biomass").getAsInt();
            JsonObject resultobject = json.getAsJsonObject("result");
            Item result = null;
            if (resultobject.has("item")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("item").getAsString()));
            } else if (resultobject.has("block")) {
                result = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resultobject.get("block").getAsString()));
            } else if (resultobject.has("tag")) {
                result = TagUtils.getAnyTagItem(new ResourceLocation(resultobject.get("tag").getAsString()));
            }
            if (input != null && result != null) {
                return new InfuserRecipe(recipeId, input, result, biomass);
            }
            throw new IllegalStateException("Item did not exist:" + recipeId.toString());
        }

        public InfuserRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Item input = buffer.m_130267_().m_41720_();
            Item result = buffer.m_130267_().m_41720_();
            int biomass = buffer.readInt();
            return new InfuserRecipe(recipeId, input, result, biomass);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfuserRecipe recipe) {
            buffer.m_130055_(new ItemStack((ItemLike)recipe.input));
            buffer.m_130055_(new ItemStack((ItemLike)recipe.output));
            buffer.writeInt(recipe.biomass);
        }
    }
}

