/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NBTHelper {
    public static int getInt(ItemStack stack, String key, int defaultValue) {
        return NBTHelper.getInt(stack.m_41783_(), key, defaultValue);
    }

    public static int getInt(CompoundTag nbt, String key, int defaultValue) {
        return NBTHelper.get(nbt, key, CompoundTag::m_128451_, defaultValue, 99);
    }

    public static float getFloat(ItemStack stack, String key, int defaultValue) {
        return NBTHelper.getFloat(stack.m_41783_(), key, (float)defaultValue);
    }

    public static float getFloat(CompoundTag nbt, String key, float defaultValue) {
        return NBTHelper.get(nbt, key, CompoundTag::m_128457_, Float.valueOf(defaultValue), 99).floatValue();
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultValue) {
        return NBTHelper.getBoolean(stack.m_41783_(), key, defaultValue);
    }

    public static boolean getBoolean(CompoundTag nbt, String key, boolean defaultValue) {
        return NBTHelper.get(nbt, key, CompoundTag::m_128471_, defaultValue);
    }

    private static <T> T get(CompoundTag compound, String key, BiFunction<CompoundTag, String, T> getter, T defaultValue) {
        return compound != null && compound.m_128441_(key) ? getter.apply(compound, key) : defaultValue;
    }

    private static <T> T get(CompoundTag compound, String key, BiFunction<CompoundTag, String, T> getter, T defaultValue, Integer type) {
        return compound != null && compound.m_128425_(key, type.intValue()) ? getter.apply(compound, key) : defaultValue;
    }

    public static <E extends ISerializable> void putSerilizableList(CompoundTag compound, String key, Collection<E> collection) {
        NBTHelper.putList(compound, key, collection, ISerializable::save);
    }

    public static <E> void putList(CompoundTag compound, String key, Collection<E> collection, Function<E, Tag> serializer) {
        ListTag list = new ListTag();
        for (E e : collection) {
            list.add((Object)serializer.apply(e));
        }
        compound.m_128365_(key, (Tag)list);
    }

    public static <E> List<E> constructListFromCompound(CompoundTag compound, String key, Function<CompoundTag, E> constructor) {
        return NBTHelper.constructListNotNull(compound, key, nbt -> (CompoundTag)nbt, constructor, 10);
    }

    public static <E> List<E> constructListFromString(CompoundTag compound, String key, Function<String, E> constructor) {
        return NBTHelper.constructListNotNull(compound, key, nbt -> ((StringTag)nbt).m_7916_(), constructor, 8);
    }

    public static <E> List<E> constructListFromInteger(CompoundTag compound, String key, Function<Integer, E> constructor) {
        return NBTHelper.constructListNotNull(compound, key, nbt -> ((IntTag)nbt).m_7047_(), constructor, 3);
    }

    private static <E, T> List<E> constructListNotNull(CompoundTag compound, String key, Function<Tag, T> typeGetter, Function<T, E> constructor, int type) {
        ListTag list = compound.m_128437_(key, type);
        ArrayList<E> results = new ArrayList<E>();
        for (Tag tag : list) {
            T t = typeGetter.apply(tag);
            if (t != null) {
                E e = constructor.apply(t);
                if (e != null) {
                    results.add(e);
                    continue;
                }
                PlantTechMain.LOGGER.error("value is null, this should not happen");
                continue;
            }
            PlantTechMain.LOGGER.error("value type is null, this should not happen");
        }
        return results;
    }
}

