/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import java.util.List;
import net.kaneka.planttech2.items.CreditCardItem;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryUtils {
    public static boolean enoughSpace(Inventory inv, int neededSpace) {
        if (neededSpace <= 0) {
            return true;
        }
        int freeSlots = 0;
        for (int i = 0; i < 36; ++i) {
            if (!inv.m_8020_(i).m_41619_() || ++freeSlots < neededSpace) continue;
            return true;
        }
        return false;
    }

    public static boolean hasList(Inventory inv, List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack.m_41619_() || inv.m_18947_(stack.m_41720_()) >= stack.m_41613_()) continue;
            return false;
        }
        return true;
    }

    public static boolean addList(Inventory inv, List<ItemStack> stacks) {
        boolean flag = true;
        for (ItemStack stack : stacks) {
            if (inv.m_36054_(stack)) continue;
            flag = false;
        }
        return flag;
    }

    public static boolean removeList(Inventory inv, List<ItemStack> stacks) {
        boolean flag = true;
        for (ItemStack stack : stacks) {
            if (PlayerInventoryUtils.remove(inv, stack)) continue;
            flag = false;
        }
        return flag;
    }

    public static boolean remove(Inventory inv, ItemStack stack) {
        int count = stack.m_41613_();
        for (int j = 0; j < 36; ++j) {
            ItemStack invstack = inv.m_8020_(j);
            if (invstack.m_41619_() || invstack.m_41720_() != stack.m_41720_()) continue;
            int k = Math.min(count, invstack.m_41613_());
            count -= k;
            invstack.m_41774_(k);
            if (invstack.m_41619_()) {
                inv.m_6836_(j, ItemStack.f_41583_);
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean enoughCredits(Inventory inv, int amount) {
        if (amount <= 0) {
            return true;
        }
        int count = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack invstack = inv.m_8020_(i);
            if (invstack.m_41619_() || !(invstack.m_41720_() instanceof CreditCardItem) || (count += CreditCardItem.getCredits(invstack)) < amount) continue;
            return true;
        }
        return false;
    }

    public static boolean removeCredits(Inventory inv, int amount) {
        int count = amount;
        if (count <= 0) {
            return true;
        }
        for (int i = 0; i < 36; ++i) {
            ItemStack invstack = inv.m_8020_(i);
            if (invstack.m_41619_() || !(invstack.m_41720_() instanceof CreditCardItem)) continue;
            int credits = CreditCardItem.getCredits(invstack);
            if ((count -= (credits -= CreditCardItem.shrinkCredits(invstack, count))) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean addCredits(Inventory inv, int amount) {
        for (int i = 0; i < 36; ++i) {
            ItemStack invstack = inv.m_8020_(i);
            if (invstack.m_41619_() || !(invstack.m_41720_() instanceof CreditCardItem)) continue;
            CreditCardItem.addCredits(invstack, amount);
        }
        return false;
    }
}

