/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.world.planttopia;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import net.kaneka.planttech2.registries.ModDimensions;
import net.kaneka.planttech2.world.planttopia.layers.GenLayerUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.newbiome.layer.Layer;

public class PlanttopiaBiomeProvider
extends BiomeSource {
    private final Layer genLayer;
    public static final Codec<PlanttopiaBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().orElseGet(() -> ModDimensions.seed).forGetter(obj -> obj.seed), (App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_122885_).forGetter(provider -> provider.biomeReg)).apply((Applicative)instance, instance.stable(PlanttopiaBiomeProvider::new)));
    private final Registry<Biome> biomeReg;
    private final long seed;

    public PlanttopiaBiomeProvider(Registry<Biome> registryIn) {
        this(0L, registryIn);
    }

    public PlanttopiaBiomeProvider(long seed, Registry<Biome> registryIn) {
        super(registryIn.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("planttech2")).map(Map.Entry::getValue).collect(Collectors.toList()));
        this.genLayer = GenLayerUtils.genLayers(seed, registryIn);
        this.biomeReg = registryIn;
        this.seed = seed;
    }

    public Biome m_7158_(int x, int y, int z) {
        return this.genLayer.m_76715_(this.biomeReg, x, z);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public BiomeSource m_7206_(long seed) {
        return new PlanttopiaBiomeProvider(seed, this.biomeReg);
    }
}

