/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.world.planttopia.layers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import net.kaneka.planttech2.world.planttopia.layers.GenLayerBase;
import net.kaneka.planttech2.world.planttopia.layers.GenLayerPhase;
import net.kaneka.planttech2.world.planttopia.layers.GenLayerRiver;
import net.kaneka.planttech2.world.utils.BiomeHolder;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.area.AreaFactory;
import net.minecraft.world.level.newbiome.context.BigContext;
import net.minecraft.world.level.newbiome.context.LazyAreaContext;
import net.minecraft.world.level.newbiome.layer.Layer;
import net.minecraft.world.level.newbiome.layer.ZoomLayer;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer1;

public class GenLayerUtils {
    protected static final List<BiomeHolder> BIOMES = (List)Util.m_137469_(new ArrayList(), list -> {
        list.add(new BiomeHolder("meadows", BiomeHolder.RARITY.COMMON, 0));
        list.add(new BiomeHolder("icy_meadows", BiomeHolder.RARITY.COMMON, 0));
        list.add(new BiomeHolder("radiated_wastelands", BiomeHolder.RARITY.COMMON, 0));
        list.add(new BiomeHolder("wetlands", BiomeHolder.RARITY.UNCOMMON, 0));
        list.add(new BiomeHolder("nightmare_forest", BiomeHolder.RARITY.UNCOMMON, 0));
        list.add(new BiomeHolder("flower_meadows", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("meadows"));
        list.add(new BiomeHolder("lake", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("meadows", true));
        list.add(new BiomeHolder("llama_meadow", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("meadows"));
        list.add(new BiomeHolder("icy_cliffs", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("icy_meadows", true));
        list.add(new BiomeHolder("dried_lake", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("radiated_wastelands", true));
        list.add(new BiomeHolder("vulcano", BiomeHolder.RARITY.RARE, 1).addTarget("radiated_wastelands", true));
        list.add(new BiomeHolder("wasteland_mesa", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("radiated_wastelands", true));
        list.add(new BiomeHolder("radiated_wetlands", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("radiated_wastelands", true));
        list.add(new BiomeHolder("energized_forest", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("radiated_wastelands"));
        list.add(new BiomeHolder("dark_wetlands", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("wetlands"));
        list.add(new BiomeHolder("chorus_forest", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("nightmare_forest"));
        list.add(new BiomeHolder("dead_forest", BiomeHolder.RARITY.COMMON, 1).addTarget("nightmare_forest"));
        list.add(new BiomeHolder("dream_forest", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("nightmare_forest"));
        list.add(new BiomeHolder("mushroom_forest", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("nightmare_forest"));
        list.add(new BiomeHolder("pumpkin_forest", BiomeHolder.RARITY.UNCOMMON, 1).addTarget("nightmare_forest"));
        list.add(new BiomeHolder("flower_hills", BiomeHolder.RARITY.UNCOMMON, 2).addTarget("flower_meadows"));
        list.add(new BiomeHolder("bee_forest", BiomeHolder.RARITY.UNCOMMON, 2).addTarget("dream_forest"));
        list.add(new BiomeHolder("mushroom_hills", BiomeHolder.RARITY.UNCOMMON, 2).addTarget("mushroom_hills"));
        list.add(new BiomeHolder("flower_mountains", BiomeHolder.RARITY.UNCOMMON, 3).addTarget("flower_hills", true));
        list.add(new BiomeHolder("river", BiomeHolder.RARITY.COMMON, -1));
    });

    private static <T extends Area, C extends BigContext<T>> AreaFactory<T> genLayers(LongFunction<C> seed, Registry<Biome> registry) {
        HashMap<Integer, List<Integer>> category = new HashMap<Integer, List<Integer>>();
        GenLayerUtils.idByPhase(0, registry).forEach(h -> category.put((Integer)h, (List<Integer>)new ArrayList<Integer>(){
            {
                this.add(h);
            }
        }));
        HashMap<Integer, HashMap<Integer, HashMap<BiomeHolder.RARITY, List<Integer>>>> replacemap = new HashMap<Integer, HashMap<Integer, HashMap<BiomeHolder.RARITY, List<Integer>>>>();
        HashMap<Integer, HashMap<Integer, HashMap<BiomeHolder.RARITY, List<Integer>>>> replacemap_border = new HashMap<Integer, HashMap<Integer, HashMap<BiomeHolder.RARITY, List<Integer>>>>();
        for (int i = 1; i <= 3; ++i) {
            replacemap.put(i, new HashMap());
            replacemap_border.put(i, new HashMap());
            for (BiomeHolder holder : GenLayerUtils.biomeByPhase(i)) {
                if (!holder.hasTarget()) continue;
                int id = holder.getBiomeId(registry);
                int targetid = holder.getTargetId(registry);
                for (Map.Entry<Integer, List<Integer>> entry : category.entrySet()) {
                    if (!entry.getValue().contains(targetid)) continue;
                    category.get(entry.getKey()).add(id);
                }
                if (!holder.isOnlyInside()) {
                    GenLayerUtils.fillInnerReplaceMap(replacemap_border, i, targetid, holder.getRarity(), id);
                }
                GenLayerUtils.fillInnerReplaceMap(replacemap, i, targetid, holder.getRarity(), id);
            }
        }
        AreaFactory<T> biomes = new GenLayerBase().setup(GenLayerUtils.idByPhaseWithRarity(0, registry)).m_76984_((BigContext)seed.apply(1L));
        biomes = GenLayerUtils.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, biomes, 1, seed);
        biomes = new GenLayerPhase().setup(1, (HashMap)replacemap.get(1), (HashMap)replacemap_border.get(1), category).m_77002_((BigContext)seed.apply(1L), biomes);
        biomes = GenLayerUtils.repeat(1001L, (AreaTransformer1)ZoomLayer.NORMAL, biomes, 2, seed);
        biomes = new GenLayerPhase().setup(2, replacemap.get(2), replacemap_border.get(2), category).m_77002_((BigContext)seed.apply(1L), biomes);
        biomes = GenLayerUtils.repeat(1002L, (AreaTransformer1)ZoomLayer.NORMAL, biomes, 2, seed);
        biomes = new GenLayerPhase().setup(3, replacemap.get(3), replacemap_border.get(3), category).m_77002_((BigContext)seed.apply(1L), biomes);
        biomes = new GenLayerRiver().setup(GenLayerUtils.getRiverId(registry), category).m_77002_((BigContext)seed.apply(1L), (AreaFactory)biomes);
        biomes = GenLayerUtils.repeat(1003L, (AreaTransformer1)ZoomLayer.NORMAL, biomes, 1, seed);
        return biomes;
    }

    private static int getRiverId(Registry<Biome> reg) {
        for (BiomeHolder holder : BIOMES) {
            if (!holder.isRiver()) continue;
            return holder.getBiomeId(reg);
        }
        return 0;
    }

    private static void fillInnerReplaceMap(HashMap<Integer, HashMap<Integer, HashMap<BiomeHolder.RARITY, List<Integer>>>> replacemap, int phase, int targetid, BiomeHolder.RARITY rarity, int biomeid) {
        if (!replacemap.get(phase).containsKey(targetid)) {
            replacemap.get(phase).put(targetid, new HashMap<BiomeHolder.RARITY, List<Integer>>(){
                {
                    this.put(BiomeHolder.RARITY.COMMON, new ArrayList());
                    this.put(BiomeHolder.RARITY.UNCOMMON, new ArrayList());
                    this.put(BiomeHolder.RARITY.RARE, new ArrayList());
                }
            });
        }
        replacemap.get(phase).get(targetid).get((Object)rarity).add(biomeid);
    }

    public static Layer genLayers(long seed, Registry<Biome> registry) {
        AreaFactory areaFactory = GenLayerUtils.genLayers(context -> new LazyAreaContext(25, seed, context), registry);
        return new Layer(areaFactory);
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> repeat(long seed, AreaTransformer1 parent, AreaFactory<T> iareafactoryparent, int count, LongFunction<C> contextFactory) {
        AreaFactory iareafactory = iareafactoryparent;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.m_77002_((BigContext)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static List<BiomeHolder> biomeByPhase(int phase) {
        ArrayList<BiomeHolder> list = new ArrayList<BiomeHolder>();
        for (BiomeHolder holder : BIOMES) {
            if (holder.getPhase() != phase) continue;
            list.add(holder);
        }
        return list;
    }

    public static List<Integer> idByPhase(int phase, Registry<Biome> reg) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (BiomeHolder holder : BIOMES) {
            if (holder.getPhase() != phase) continue;
            list.add(holder.getBiomeId(reg));
        }
        return list;
    }

    public static HashMap<BiomeHolder.RARITY, List<BiomeHolder>> idByPhaseWithRarity(int phase) {
        HashMap hmap = (HashMap)Util.m_137469_(new HashMap(), s -> {
            s.put(BiomeHolder.RARITY.COMMON, new ArrayList());
            s.put(BiomeHolder.RARITY.UNCOMMON, new ArrayList());
            s.put(BiomeHolder.RARITY.RARE, new ArrayList());
        });
        for (BiomeHolder holder : BIOMES) {
            if (holder.getPhase() != phase) continue;
            ((List)hmap.get((Object)holder.getRarity())).add(holder);
        }
        return hmap;
    }

    public static HashMap<BiomeHolder.RARITY, List<Integer>> idByPhaseWithRarity(int phase, Registry<Biome> reg) {
        HashMap hmap = (HashMap)Util.m_137469_(new HashMap(), s -> {
            s.put(BiomeHolder.RARITY.COMMON, new ArrayList());
            s.put(BiomeHolder.RARITY.UNCOMMON, new ArrayList());
            s.put(BiomeHolder.RARITY.RARE, new ArrayList());
        });
        for (BiomeHolder holder : BIOMES) {
            if (holder.getPhase() != phase) continue;
            ((List)hmap.get((Object)holder.getRarity())).add(holder.getBiomeId(reg));
        }
        return hmap;
    }
}

