/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.world.utils;

import net.kaneka.planttech2.registries.ModReferences;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeHolder {
    private final ResourceKey<Biome> biome;
    private ResourceKey<Biome> targetBiome;
    private final RARITY rarity;
    private final int phase;
    private boolean onlyInside = false;
    private boolean isRiver = false;
    private int id = -1;
    private int targetId = -1;

    public BiomeHolder(String biome, RARITY rarity, int phase) {
        this.biome = this.getBiomeRegistryKey(biome);
        this.rarity = rarity;
        this.phase = phase;
    }

    public BiomeHolder addTarget(String targetBiome, boolean onlyInside) {
        this.targetBiome = this.getBiomeRegistryKey(targetBiome);
        this.onlyInside = onlyInside;
        return this;
    }

    public BiomeHolder addTarget(String targetBiome) {
        return this.addTarget(targetBiome, false);
    }

    public BiomeHolder river() {
        this.isRiver = true;
        return this;
    }

    public boolean isRiver() {
        return this.isRiver;
    }

    public int getBiomeId(Registry<Biome> registry) {
        if (this.id == -1) {
            this.id = registry.m_7447_((Object)((Biome)registry.m_6246_(this.biome)));
        }
        return this.id;
    }

    public int getTargetId(Registry<Biome> registry) {
        if (this.hasTarget()) {
            if (this.targetId == -1) {
                this.targetId = registry.m_7447_((Object)((Biome)registry.m_6246_(this.targetBiome)));
            }
            return this.targetId;
        }
        return -1;
    }

    public boolean hasTarget() {
        return this.targetBiome != null;
    }

    private ResourceKey<Biome> getBiomeRegistryKey(String s) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)ModReferences.prefix(s));
    }

    public int getPhase() {
        return this.phase;
    }

    public RARITY getRarity() {
        return this.rarity;
    }

    public boolean isOnlyInside() {
        return this.onlyInside;
    }

    public static enum RARITY {
        COMMON(0),
        UNCOMMON(1),
        RARE(2);

        private int value;

        private RARITY(int value) {
            this.value = value;
        }

        public int getRarity() {
            return this.value;
        }
    }
}

