/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft;

import com.mojang.brigadier.CommandDispatcher;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.client.ClientSetup;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.capabilities.CapabilityAirHandler;
import me.desht.pneumaticcraft.common.capabilities.CapabilityHacking;
import me.desht.pneumaticcraft.common.capabilities.CapabilityHeat;
import me.desht.pneumaticcraft.common.commands.ModCommands;
import me.desht.pneumaticcraft.common.config.ConfigHolder;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigHandler;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModDecorators;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModHarvestHandlers;
import me.desht.pneumaticcraft.common.core.ModHoeHandlers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModParticleTypes;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.core.ModVillagers;
import me.desht.pneumaticcraft.common.dispenser.BehaviorDispenseDrone;
import me.desht.pneumaticcraft.common.event.DroneSpecialVariableHandler;
import me.desht.pneumaticcraft.common.event.EventHandlerAmadron;
import me.desht.pneumaticcraft.common.event.EventHandlerPneumaticArmor;
import me.desht.pneumaticcraft.common.event.EventHandlerPneumaticCraft;
import me.desht.pneumaticcraft.common.event.EventHandlerUniversalSensor;
import me.desht.pneumaticcraft.common.event.HackTickHandler;
import me.desht.pneumaticcraft.common.event.TickHandlerPneumaticCraft;
import me.desht.pneumaticcraft.common.fluid.FluidSetup;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.Reflections;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradesDBSetup;
import me.desht.pneumaticcraft.common.villages.VillageStructures;
import me.desht.pneumaticcraft.common.worldgen.ModWorldGen;
import me.desht.pneumaticcraft.datagen.ModBlockTagsProvider;
import me.desht.pneumaticcraft.datagen.ModFluidTagsProvider;
import me.desht.pneumaticcraft.datagen.ModItemTagsProvider;
import me.desht.pneumaticcraft.datagen.ModLootTablesProvider;
import me.desht.pneumaticcraft.datagen.ModRecipeProvider;
import me.desht.pneumaticcraft.datagen.loot.ModLootFunctions;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.DispenserBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="pneumaticcraft")
public class PneumaticCraftRepressurized {
    public PneumaticCraftRepressurized() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHolder.init();
        AuxConfigHandler.preInit();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::initEarly);
        modBus.addListener(this::modConstructSetup);
        modBus.addListener(this::commonSetup);
        forgeBus.addListener(this::serverStarted);
        forgeBus.addListener(this::serverStopping);
        forgeBus.addListener(this::addReloadListeners);
        forgeBus.addListener(this::registerCommands);
        this.registerAllDeferredRegistryObjects(modBus);
        Reflections.init();
        PneumaticRegistry.init(PneumaticCraftAPIHandler.getInstance());
        ModLootFunctions.init();
        forgeBus.register((Object)new TickHandlerPneumaticCraft());
        forgeBus.register((Object)new EventHandlerPneumaticCraft());
        forgeBus.register((Object)new EventHandlerAmadron());
        forgeBus.register((Object)new EventHandlerPneumaticArmor());
        forgeBus.register((Object)new EventHandlerUniversalSensor());
        forgeBus.register((Object)new DroneSpecialVariableHandler());
        forgeBus.register(ItemGPSAreaTool.EventHandler.class);
        forgeBus.register((Object)HackTickHandler.instance());
        forgeBus.addListener(EventPriority.HIGH, ModWorldGen::onBiomeLoading);
    }

    private void registerAllDeferredRegistryObjects(IEventBus modBus) {
        ModBlocks.BLOCKS.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModFluids.FLUIDS.register(modBus);
        ModSounds.SOUNDS.register(modBus);
        ModTileEntities.TILE_ENTITIES.register(modBus);
        ModEntities.ENTITIES.register(modBus);
        ModContainers.CONTAINERS.register(modBus);
        ModParticleTypes.PARTICLES.register(modBus);
        ModRecipes.RECIPES.register(modBus);
        ModDecorators.DECORATORS.register(modBus);
        ModVillagers.POI.register(modBus);
        ModVillagers.PROFESSIONS.register(modBus);
        ModHarvestHandlers.HARVEST_HANDLERS_DEFERRED.register(modBus);
        ModHoeHandlers.HOE_HANDLERS_DEFERRED.register(modBus);
        ModProgWidgets.PROG_WIDGETS_DEFERRED.register(modBus);
    }

    private void modConstructSetup(FMLConstructModEvent event) {
        ThirdPartyManager.instance().preInit();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Log.info("PneumaticCraft: Repressurized is loading!", new Object[0]);
        ThirdPartyManager.instance().init();
        this.registerCapabilities();
        NetworkHandler.init();
        FluidSetup.init();
        ArmorUpgradeRegistry.init();
        HackableHandler.addDefaultEntries();
        SensorHandler.getInstance().init();
        UpgradesDBSetup.init();
        VillageStructures.init();
        ModNameCache.init();
        HeatBehaviourManager.getInstance().init();
        event.enqueueWork(() -> {
            ModWorldGen.registerConfiguredFeatures();
            AdvancementTriggers.registerTriggers();
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.DRONE.get()), (IDispenseItemBehavior)new BehaviorDispenseDrone());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.LOGISTICS_DRONE.get()), (IDispenseItemBehavior)new BehaviorDispenseDrone());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.HARVESTING_DRONE.get()), (IDispenseItemBehavior)new BehaviorDispenseDrone());
            ThirdPartyManager.instance().postInit();
            for (RegistryObject block : ModBlocks.BLOCKS.getEntries()) {
                if (!(block.get() instanceof IUpgradeAcceptor)) continue;
                PneumaticRegistry.getInstance().getItemRegistry().registerUpgradeAcceptor((IUpgradeAcceptor)block.get());
            }
            for (RegistryObject item : ModItems.ITEMS.getEntries()) {
                if (!(item.get() instanceof IUpgradeAcceptor)) continue;
                PneumaticRegistry.getInstance().getItemRegistry().registerUpgradeAcceptor((IUpgradeAcceptor)item.get());
            }
        });
    }

    private void registerCapabilities() {
        CapabilityAirHandler.register();
        CapabilityHeat.register();
        CapabilityHacking.register();
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)PneumaticCraftRecipeType.getCacheReloadListener());
    }

    private void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void serverStarted(FMLServerStartedEvent event) {
        AuxConfigHandler.postInit();
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        AmadronOfferManager.getInstance().saveAll();
        AuxConfigHandler.clearPerWorldConfigs();
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class DataGenerators {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            if (event.includeServer()) {
                generator.func_200390_a((IDataProvider)new ModRecipeProvider(generator));
                generator.func_200390_a((IDataProvider)new ModLootTablesProvider(generator));
                ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(generator, event.getExistingFileHelper());
                generator.func_200390_a((IDataProvider)blockTagsProvider);
                generator.func_200390_a((IDataProvider)new ModItemTagsProvider(generator, blockTagsProvider, event.getExistingFileHelper()));
                generator.func_200390_a((IDataProvider)new ModFluidTagsProvider(generator, event.getExistingFileHelper()));
            }
        }
    }
}

