/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidIngredient
extends Ingredient {
    private List<Fluid> fluids;
    private final int amount;
    private ItemStack[] cachedStacks;
    private final ResourceLocation tagId;
    private final ResourceLocation fluidId;
    public static final FluidIngredient EMPTY = new FluidIngredient();

    private FluidIngredient() {
        super(Stream.empty());
        this.fluids = Collections.emptyList();
        this.amount = 0;
        this.tagId = null;
        this.fluidId = null;
    }

    public FluidIngredient(Collection<Fluid> fluids, int amount) {
        super(Stream.empty());
        this.fluids = ImmutableList.copyOf(fluids);
        this.amount = amount;
        this.tagId = null;
        this.fluidId = null;
    }

    private FluidIngredient(ResourceLocation fluidId, int amount, boolean isFluid) {
        super(Stream.empty());
        this.fluids = null;
        this.amount = amount;
        if (isFluid) {
            this.tagId = null;
            this.fluidId = fluidId;
        } else {
            this.tagId = fluidId;
            this.fluidId = null;
        }
    }

    public static FluidIngredient of(int amount, Fluid ... fluids) {
        return new FluidIngredient(Arrays.asList(fluids), amount);
    }

    public static FluidIngredient of(int amount, ITag.INamedTag<Fluid> fluid) {
        return new FluidIngredient(fluid.func_230234_a_(), amount, false);
    }

    public static FluidIngredient of(int amount, ResourceLocation fluidId) {
        return new FluidIngredient(fluidId, amount, true);
    }

    private Collection<Fluid> getFluidList() {
        if (this.fluids == null && (this.tagId != null || this.fluidId != null)) {
            if (this.tagId != null) {
                ITag tag = FluidTags.func_226157_a_().func_199910_a(this.tagId);
                this.fluids = tag == null ? Collections.emptyList() : ImmutableList.copyOf((Collection)tag.func_230236_b_());
            } else {
                Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(this.fluidId);
                if (f != null && f != Fluids.field_204541_a) {
                    this.fluids = Collections.singletonList(f);
                }
            }
        }
        return this.fluids;
    }

    public boolean func_203189_d() {
        return this.getFluidList().isEmpty();
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && FluidUtil.getFluidContained((ItemStack)stack).map(this::testFluid).orElse(false) != false;
    }

    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            for (Fluid f : this.getFluidList()) {
                FluidStack fluidStack = new FluidStack(f, 1000);
                ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)fluidStack);
                if (!bucket.func_190926_b()) {
                    l.add(bucket);
                }
                this.maybeAddTank(l, (Block)ModBlocks.TANK_SMALL.get(), fluidStack);
                this.maybeAddTank(l, (Block)ModBlocks.TANK_MEDIUM.get(), fluidStack);
                this.maybeAddTank(l, (Block)ModBlocks.TANK_LARGE.get(), fluidStack);
                this.maybeAddTank(l, (Block)ModBlocks.TANK_HUGE.get(), fluidStack);
            }
            this.cachedStacks = l.toArray(new ItemStack[0]);
        }
        return this.cachedStacks;
    }

    private void maybeAddTank(List<ItemStack> l, Block tankBlock, FluidStack stack) {
        ItemStack tank = new ItemStack((IItemProvider)tankBlock);
        tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
            h.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            l.add(h.getContainer());
        });
    }

    public boolean testFluid(FluidStack fluidStack) {
        return this.getFluidList().stream().anyMatch(f -> fluidStack.getFluid() == f && fluidStack.getAmount() >= this.amount);
    }

    public boolean testFluid(Fluid otherFluid) {
        return this.getFluidList().stream().anyMatch(f -> f == otherFluid);
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        if (this.tagId != null) {
            json.addProperty("tag", this.tagId.toString());
        } else if (this.fluidId != null) {
            json.addProperty("fluid", this.fluidId.toString());
        } else if (!this.fluids.isEmpty()) {
            json.addProperty("fluid", this.fluids.get(0).getRegistryName().toString());
        } else {
            throw new IllegalStateException("ingredient has no ID, tag or fluid!");
        }
        json.addProperty("amount", (Number)this.amount);
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<FluidStack> getFluidStacks() {
        return this.getFluidList().stream().map(f -> new FluidStack(f, this.amount)).collect(Collectors.toList());
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:fluid");

        public FluidIngredient parse(PacketBuffer buffer) {
            int n = buffer.func_150792_a();
            int amount = buffer.func_150792_a();
            HashSet<Fluid> fluids = new HashSet<Fluid>();
            for (int i = 0; i < n; ++i) {
                fluids.add((Fluid)buffer.readRegistryId());
            }
            return new FluidIngredient(fluids, amount);
        }

        public FluidIngredient parse(JsonObject json) {
            int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
            if (json.has("tag")) {
                ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
                if (TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(rl) == null) {
                    throw new JsonSyntaxException("Unknown fluid tag '" + rl + "'");
                }
                return new FluidIngredient(rl, amount, false);
            }
            if (json.has("fluid")) {
                ResourceLocation fluidName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
                if (fluid == null || fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
                }
                return new FluidIngredient(Collections.singletonList(fluid), amount);
            }
            throw new JsonSyntaxException("fluid ingredient must have 'fluid' or 'tag' field!");
        }

        public void write(PacketBuffer buffer, FluidIngredient ingredient) {
            buffer.func_150787_b(ingredient.getFluidList().size());
            buffer.func_150787_b(ingredient.amount);
            for (Fluid fluid : ingredient.getFluidList()) {
                buffer.writeRegistryId((IForgeRegistryEntry)fluid);
            }
        }
    }
}

