/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.heat;

import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public interface IHeatExhangerAdapter
extends IHeatExchangerLogic {
    @Override
    default public void tick() {
    }

    @Override
    default public void initializeAsHull(World world, BlockPos pos, BiPredicate<IWorld, BlockPos> blockFilter, Direction ... validSides) {
    }

    @Override
    default public void initializeAmbientTemperature(World world, BlockPos pos) {
    }

    @Override
    default public void setTemperature(double temperature) {
    }

    @Override
    default public int getTemperatureAsInt() {
        return (int)this.getTemperature();
    }

    @Override
    default public void setThermalResistance(double thermalResistance) {
    }

    @Override
    default public void setThermalCapacity(double capacity) {
    }

    public static abstract class Simple<CAP>
    implements IHeatExhangerAdapter {
        protected final Direction side;
        protected final LazyOptional<CAP> foreignHeatCap;
        protected final double ambientTemperature;

        public Simple(Direction side, LazyOptional<CAP> foreignHeatCap, double ambientTemperature) {
            this.side = side;
            this.foreignHeatCap = foreignHeatCap;
            this.ambientTemperature = ambientTemperature;
        }

        @Override
        public double getAmbientTemperature() {
            return this.ambientTemperature;
        }

        @Override
        public boolean isSideConnected(Direction side) {
            return this.side == side;
        }
    }
}

