/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.IKeyListener;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyHandler {
    private static final String DESCRIPTION_ARMOR_OPTIONS = "pneumaticcraft.armor.options";
    private static final String DESCRIPTION_HELMET_HACK = "pneumaticcraft.helmet.hack";
    private static final String DESCRIPTION_HELMET_DEBUGGING_DRONE = "pneumaticcraft.helmet.debugging.drone";
    private static final String DESCRIPTION_BOOTS_KICK = "pneumaticcraft.boots.kick";
    private static final String DESCRIPTION_LAUNCHER = "pneumaticcraft.chestplate.launcher";
    private static final KeyHandler INSTANCE = new KeyHandler();
    public final KeyBinding keybindOpenOptions;
    public final KeyBinding keybindHack;
    public final KeyBinding keybindDebuggingDrone;
    public final KeyBinding keybindKick;
    public final KeyBinding keybindLauncher;
    private final List<IKeyListener> keyListeners = new ArrayList<IKeyListener>();
    private final List<KeyBinding> keys = new ArrayList<KeyBinding>();

    public static KeyHandler getInstance() {
        return INSTANCE;
    }

    private KeyHandler() {
        this.registerKeyListener(HUDHandler.getInstance());
        this.keybindOpenOptions = this.registerKeyBinding(new KeyBinding(DESCRIPTION_ARMOR_OPTIONS, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, 85, "key.pneumaticcraft.category.main"));
        this.keybindHack = this.registerKeyBinding(new KeyBinding(DESCRIPTION_HELMET_HACK, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, 72, "key.pneumaticcraft.category.main"));
        this.keybindDebuggingDrone = this.registerKeyBinding(new KeyBinding(DESCRIPTION_HELMET_DEBUGGING_DRONE, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, 89, "key.pneumaticcraft.category.main"));
        this.keybindKick = this.registerKeyBinding(new KeyBinding(DESCRIPTION_BOOTS_KICK, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputMappings.Type.KEYSYM, 88, "key.pneumaticcraft.category.main"));
        this.keybindLauncher = this.registerKeyBinding(new KeyBinding(DESCRIPTION_LAUNCHER, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputMappings.Type.KEYSYM, 67, "key.pneumaticcraft.category.main"));
    }

    private KeyBinding registerKeyBinding(KeyBinding keyBinding) {
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        this.keys.add(keyBinding);
        return keyBinding;
    }

    private void registerKeyListener(IKeyListener listener) {
        this.keyListeners.add(listener);
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        for (KeyBinding key : this.keys) {
            if (!key.func_151468_f()) continue;
            this.dispatchInput(key);
        }
    }

    @SubscribeEvent
    public void onMouse(InputEvent.MouseInputEvent event) {
        for (KeyBinding key : this.keys) {
            if (!key.func_151468_f()) continue;
            this.dispatchInput(key);
        }
    }

    private void dispatchInput(KeyBinding keybinding) {
        for (IKeyListener listener : this.keyListeners) {
            listener.handleInput(keybinding);
        }
    }
}

