/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiInventorySearcher;
import me.desht.pneumaticcraft.client.gui.GuiItemSearcher;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsLiquidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadronAddTrade;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class GuiAmadronAddTrade
extends GuiPneumaticContainerBase<ContainerAmadronAddTrade, TileEntityBase> {
    private GuiItemSearcher searchGui;
    private GuiInventorySearcher invSearchGui;
    private GuiInventorySearcher gpsSearchGui;
    private GuiLogisticsLiquidFilter fluidGui;
    private int settingSlot;
    private final WidgetFluidFilter[] fluidFilters = new WidgetFluidFilter[2];
    private final WidgetTextFieldNumber[] amountFields = new WidgetTextFieldNumber[2];
    private final BlockPos[] positions = new BlockPos[2];
    private Button addButton;
    private boolean openingSubGUI = false;

    public GuiAmadronAddTrade(ContainerAmadronAddTrade container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_146999_f = 183;
        this.field_147000_g = 202;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.searchGui != null) {
            this.setStack(this.settingSlot, this.searchGui.getSearchStack());
        } else if (this.invSearchGui != null) {
            this.setStack(this.settingSlot, this.invSearchGui.getSearchStack());
        } else if (this.fluidGui != null) {
            this.setFluid(this.settingSlot, this.fluidGui.getFilter());
        } else if (this.gpsSearchGui != null) {
            this.positions[this.settingSlot] = this.gpsSearchGui.getSearchStack().func_190926_b() ? null : ItemGPSTool.getGPSLocation(this.gpsSearchGui.getSearchStack());
        }
        this.openingSubGUI = false;
        this.searchGui = null;
        this.fluidGui = null;
        this.invSearchGui = null;
        this.gpsSearchGui = null;
        this.initSide(0);
        this.initSide(1);
        this.func_231035_a_((IGuiEventListener)this.amountFields[0]);
        this.addButton = new WidgetButtonExtended(this.field_147003_i + 50, this.field_147009_r + 171, 85, 20, "Add Trade", b -> this.addTrade());
        this.func_230480_a_((Widget)this.addButton);
        this.addJeiFilterInfoTab();
    }

    public void setStack(int slot, ItemStack stack) {
        this.fluidFilters[slot].setFluid(Fluids.field_204541_a);
        ((ContainerAmadronAddTrade)this.field_147002_h).setStack(slot, stack);
    }

    public void setFluid(int slot, Fluid stack) {
        ((ContainerAmadronAddTrade)this.field_147002_h).setStack(slot, ItemStack.field_190927_a);
        this.fluidFilters[slot].setFluid(stack);
    }

    private void initSide(int slot) {
        int xOffset = slot == 0 ? 0 : 89;
        String s = slot == 0 ? "selling" : "buying";
        this.func_230480_a_(new WidgetLabel(this.field_147003_i + 48 + xOffset, this.field_147009_r + 7, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.addTrade." + s, new Object[0]), -1).setAlignment(WidgetLabel.Alignment.CENTRE));
        this.func_230480_a_((Widget)new WidgetButtonExtended(this.field_147003_i + 4 + xOffset, this.field_147009_r + 20, 85, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchItem", new Object[0]), b -> this.openItemSearchGui(slot)));
        this.func_230480_a_((Widget)new WidgetButtonExtended(this.field_147003_i + 4 + xOffset, this.field_147009_r + 42, 85, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchInventory", new Object[0]), b -> this.openInventorySearchGui(slot)));
        this.func_230480_a_((Widget)new WidgetButtonExtended(this.field_147003_i + 4 + xOffset, this.field_147009_r + 64, 85, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchFluid", new Object[0]), b -> this.openFluidSearchGui(slot)));
        Fluid prev = this.fluidFilters[slot] != null ? this.fluidFilters[slot].getFluid() : Fluids.field_204541_a;
        this.fluidFilters[slot] = new WidgetFluidFilter(this.field_147003_i + 37 + xOffset, this.field_147009_r + 90, prev);
        this.func_230480_a_(this.fluidFilters[slot]);
        String tip = slot == 0 ? "pneumaticcraft.gui.amadron.button.selectSellingBlock.tooltip" : "pneumaticcraft.gui.amadron.button.selectPaymentBlock.tooltip";
        this.func_230480_a_((Widget)new WidgetButtonExtended(this.field_147003_i + 10 + xOffset, this.field_147009_r + 115, 20, 20, "", b -> this.openGPSGui(slot)).setRenderStacks(new ItemStack((IItemProvider)ModItems.GPS_TOOL.get())).setTooltipKey(tip, new Object[0]));
        int coarse = this.fluidFilters[slot].getFluid() == Fluids.field_204541_a ? 10 : 1000;
        int max = this.fluidFilters[slot].getFluid() == Fluids.field_204541_a ? 64 : Integer.MAX_VALUE;
        this.field_230712_o_.getClass();
        this.amountFields[slot] = new WidgetTextFieldNumber(this.field_230712_o_, this.field_147003_i + 22 + xOffset, this.field_147009_r + 145, 40, 9).setValue(this.amountFields[slot] != null ? (double)this.amountFields[slot].getValue() : 1.0).setRange(1, max).setAdjustments(1.0, coarse);
        this.func_230480_a_((Widget)this.amountFields[slot]);
        this.func_230480_a_(new WidgetLabel(this.field_147003_i + 65 + xOffset, this.field_147009_r + 145, (ITextComponent)new StringTextComponent(this.fluidFilters[slot].getFluid() != Fluids.field_204541_a ? "mB" : ""), -1));
        GlobalPos p = this.getPosition(slot);
        if (p != null && GlobalPosHelper.isSameWorld(p, (World)this.field_230706_i_.field_71441_e)) {
            BlockState state = this.field_230706_i_.field_71441_e.func_180495_p(p.func_218180_b());
            ITextComponent name = new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()).func_200301_q();
            ((WidgetLabel)this.func_230480_a_(new WidgetLabel(this.field_147003_i + 32 + xOffset, this.field_147009_r + 118, name, -1))).setScale(0.5f);
            ((WidgetLabel)this.func_230480_a_(new WidgetLabel(this.field_147003_i + 32 + xOffset, this.field_147009_r + 124, (ITextComponent)new StringTextComponent(" @ " + this.posToString(p.func_218180_b())), -1))).setScale(0.5f);
        }
        if (this.positions[slot] == null) {
            ((WidgetLabel)this.func_230480_a_(new WidgetLabel(this.field_147003_i + 32 + xOffset, this.field_147009_r + 130, (ITextComponent)new StringTextComponent("[Default]"), -4144960))).setScale(0.5f);
        }
    }

    private String posToString(BlockPos pos) {
        return pos == null ? "[Default]" : PneumaticCraftUtils.posToString(pos);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    @Override
    public void func_231164_f_() {
        if (!this.openingSubGUI) {
            NetworkHandler.sendToServer(new PacketGuiButton("showAmadron"));
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.func_231164_f_();
            return true;
        }
        if (keyCode == 258) {
            WidgetTextFieldNumber amountIn = this.amountFields[0];
            WidgetTextFieldNumber amountOut = this.amountFields[1];
            if (amountIn.func_230999_j_()) {
                amountIn.func_146190_e(amountIn.func_146198_h());
                amountIn.func_146195_b(false);
                this.func_231035_a_((IGuiEventListener)amountOut);
                amountOut.func_146190_e(0);
                amountOut.func_146199_i(amountOut.func_146179_b().length());
            } else if (amountOut.func_230999_j_()) {
                amountOut.func_146190_e(amountOut.func_146198_h());
                amountOut.func_146195_b(false);
                this.func_231035_a_((IGuiEventListener)amountIn);
                amountIn.func_146190_e(0);
                amountIn.func_146199_i(amountIn.func_146179_b().length());
            }
        }
        if (this.func_241217_q_() instanceof WidgetTextField) {
            WidgetTextField tf = (WidgetTextField)this.func_241217_q_();
            return tf.func_231046_a_(keyCode, scanCode, modifiers) || tf.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    protected int getBackgroundTint() {
        return -16347604;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON_ADD_TRADE;
    }

    private void openItemSearchGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.ITEM_SEARCHER.get()), (ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.amadron.addTrade.itemSearch"));
        if (this.field_230706_i_.field_71462_r instanceof GuiItemSearcher) {
            this.settingSlot = slot;
            this.searchGui = (GuiItemSearcher)this.field_230706_i_.field_71462_r;
            this.searchGui.setSearchStack(((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot));
        }
    }

    private void openInventorySearchGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.INVENTORY_SEARCHER.get()), (ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.amadron.addTrade.invSearch"));
        if (this.field_230706_i_.field_71462_r instanceof GuiInventorySearcher) {
            this.settingSlot = slot;
            this.invSearchGui = (GuiInventorySearcher)this.field_230706_i_.field_71462_r;
            this.invSearchGui.setSearchStack(((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot));
        }
    }

    private void openFluidSearchGui(int slot) {
        this.openingSubGUI = true;
        this.settingSlot = slot;
        this.fluidGui = new GuiLogisticsLiquidFilter((Screen)this);
        this.fluidGui.setFilter(this.fluidFilters[slot].getFluid());
        this.field_230706_i_.func_147108_a((Screen)this.fluidGui);
    }

    private void openGPSGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.INVENTORY_SEARCHER.get()), (ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.amadron.addTrade.gpsSearch"));
        if (this.field_230706_i_.field_71462_r instanceof GuiInventorySearcher) {
            this.gpsSearchGui = (GuiInventorySearcher)this.field_230706_i_.field_71462_r;
            this.gpsSearchGui.setStackPredicate(itemStack -> itemStack.func_77973_b() instanceof IPositionProvider);
            this.settingSlot = slot;
            ItemStack gps = new ItemStack((IItemProvider)ModItems.GPS_TOOL.get());
            GlobalPos gPos = this.getPosition(slot);
            if (gPos != null) {
                ItemGPSTool.setGPSLocation(gps, gPos.func_218180_b());
            }
            this.gpsSearchGui.setSearchStack(ItemGPSTool.getGPSLocation(gps) != null ? gps : ItemStack.field_190927_a);
        }
    }

    private void addTrade() {
        AmadronTradeResource[] resources = new AmadronTradeResource[2];
        for (int slot = 0; slot < resources.length; ++slot) {
            resources[slot] = !((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot).func_190926_b() ? AmadronTradeResource.of(ItemHandlerHelper.copyStackWithSize((ItemStack)((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot), (int)this.amountFields[slot].getValue())) : AmadronTradeResource.of(new FluidStack(this.fluidFilters[slot].getFluid(), this.amountFields[slot].getValue()));
        }
        String id = this.field_230706_i_.field_71439_g.func_200200_C_().func_150261_e().toLowerCase() + "_" + System.currentTimeMillis() / 1000L;
        AmadronPlayerOffer trade = new AmadronPlayerOffer(PneumaticCraftUtils.RL(id), resources[1], resources[0], (PlayerEntity)this.field_230706_i_.field_71439_g).setProvidingPosition(this.getPosition(0)).setReturningPosition(this.getPosition(1));
        NetworkHandler.sendToServer(new PacketAmadronTradeAddCustom(trade));
    }

    private GlobalPos getPosition(int slot) {
        if (this.positions[slot] != null) {
            return GlobalPosHelper.makeGlobalPos(this.field_213127_e.field_70458_d.field_70170_p, this.positions[slot]);
        }
        if (!((ContainerAmadronAddTrade)this.field_147002_h).getStack(slot).func_190926_b()) {
            return ItemAmadronTablet.getItemProvidingLocation(this.field_213127_e.field_70458_d.func_184614_ca());
        }
        if (this.fluidFilters[slot].getFluid() != Fluids.field_204541_a) {
            return ItemAmadronTablet.getFluidProvidingLocation(this.field_213127_e.field_70458_d.func_184614_ca());
        }
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        GlobalPos inPos = this.getPosition(0);
        GlobalPos outPos = this.getPosition(1);
        this.addButton.field_230693_o_ = !(this.amountFields[0].getValue() <= 0 || this.amountFields[1].getValue() <= 0 || this.fluidFilters[0].getFluid() == Fluids.field_204541_a && ((ContainerAmadronAddTrade)this.field_147002_h).getInputStack().func_190926_b() || this.fluidFilters[1].getFluid() == Fluids.field_204541_a && ((ContainerAmadronAddTrade)this.field_147002_h).getOutputStack().func_190926_b() || inPos == null || outPos == null);
    }

    @Override
    protected void addProblems(List<ITextComponent> curInfo) {
        if (this.getPosition(0) == null || this.getPosition(1) == null) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.amadron.addTrade.problems.noSellingOrPayingBlock", new Object[0]));
        }
        super.addProblems(curInfo);
    }
}

