/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiItemSearcher;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAphorismTileUpdate;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.drama.DramaGenerator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GuiAphorismTile
extends Screen
implements Slider.ISlider {
    private static final int PANEL_HEIGHT = 88;
    public final TileEntityAphorismTile tile;
    private String[] textLines;
    public int cursorY;
    public int cursorX;
    public int updateCounter;
    private GuiItemSearcher itemSearchGui;
    private int panelWidth;

    public GuiAphorismTile(TileEntityAphorismTile tile, boolean placing) {
        super(new ItemStack((IItemProvider)ModBlocks.APHORISM_TILE.get()).func_200301_q());
        this.tile = tile;
        this.textLines = tile.getTextLines();
        tile.needMaxLineWidthRecalc();
        if (PNCConfig.Client.aphorismDrama && placing && this.textLines.length == 1 && this.textLines[0].equals("")) {
            List<String> l = PneumaticCraftUtils.splitString(DramaGenerator.generateDrama(), 20);
            tile.setTextLines(l.toArray(new String[0]));
            this.textLines = tile.getTextLines();
            NetworkHandler.sendToServer(new PacketAphorismTileUpdate(tile));
        }
        Pair<Integer, Integer> cursor = tile.getCursorPos();
        this.cursorX = (Integer)cursor.getLeft();
        this.cursorY = (Integer)cursor.getRight();
    }

    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int yPos = (this.field_230709_l_ - 88) / 2;
        this.func_230480_a_((Widget)new Slider(5, yPos, 90, 16, (ITextComponent)new StringTextComponent("Margin: "), StringTextComponent.field_240750_d_, 0.0, 9.0, (double)this.tile.getMarginSize(), false, true, b -> {}, (Slider.ISlider)this));
        WidgetCheckBox cb = new WidgetCheckBox(5, yPos + 22, 0xFFFFFF, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.invisible", new Object[0]), b -> this.tile.setInvisible(b.checked)).setChecked(this.tile.isInvisible());
        this.func_230480_a_(cb);
        this.func_230480_a_(new WidgetLabel(5, yPos + 38, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.aphorismTile.insert", new Object[0]), -128));
        TranslationTextComponent txt = PneumaticCraftUtils.xlate("pneumaticcraft.gui.aphorismTile.insertItem", new Object[0]);
        WidgetButtonExtended itemButton = new WidgetButtonExtended(10, yPos + 50, this.field_230712_o_.func_238414_a_((ITextProperties)txt) + 10, 18, (ITextComponent)txt, b -> this.openItemSelector());
        this.func_230480_a_((Widget)itemButton);
        txt = PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstone", new Object[0]);
        WidgetButtonExtended rsButton = new WidgetButtonExtended(10, yPos + 70, this.field_230712_o_.func_238414_a_((ITextProperties)txt) + 10, 18, (ITextComponent)txt, b -> {
            this.textLines[this.cursorY] = this.textLines[this.cursorY] + "{redstone}";
            this.tile.setTextLines(this.textLines);
        });
        this.func_230480_a_((Widget)rsButton);
        this.panelWidth = Math.max(100, Math.max(cb.func_230998_h_(), Math.max(rsButton.func_230998_h_(), itemButton.func_230998_h_()))) + 5;
        if (this.itemSearchGui != null && !this.itemSearchGui.getSearchStack().func_190926_b()) {
            String text;
            this.textLines[this.cursorY] = text = "{item:" + this.itemSearchGui.getSearchStack().func_77973_b().getRegistryName().toString() + "}";
            this.cursorX = text.length();
            this.tile.setTextLines(this.textLines);
            this.itemSearchGui = null;
        }
    }

    private void openItemSelector() {
        ClientUtils.openContainerGui((ContainerType<? extends Container>)((ContainerType)ModContainers.ITEM_SEARCHER.get()), (ITextComponent)new StringTextComponent("Searcher"));
        if (this.field_230706_i_.field_71462_r instanceof GuiItemSearcher) {
            this.itemSearchGui = (GuiItemSearcher)this.field_230706_i_.field_71462_r;
        }
    }

    public static void openGui(TileEntityAphorismTile te, boolean placing) {
        if (te != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiAphorismTile(te, placing));
        }
    }

    public void func_231023_e_() {
        ++this.updateCounter;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawPanel(matrixStack, -5, (this.field_230709_l_ - 88) / 2, 88, this.panelWidth);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(matrixStack, this, this.field_230712_o_, GuiUtils.xlateAndSplit("pneumaticcraft.gui.aphorismTile.helpText", new Object[0]));
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean updateTE = false;
        String curLine = this.textLines[this.cursorY];
        float p = curLine.isEmpty() ? 0.0f : (float)this.cursorX / (float)curLine.length();
        switch (keyCode) {
            case 256: {
                NetworkHandler.sendToServer(new PacketAphorismTileUpdate(this.tile));
                break;
            }
            case 265: {
                --this.cursorY;
                if (this.cursorY < 0) {
                    this.cursorY = this.textLines.length - 1;
                }
                this.cursorX = (int)((float)this.textLines[this.cursorY].length() * p);
                break;
            }
            case 264: 
            case 335: {
                ++this.cursorY;
                if (this.cursorY >= this.textLines.length) {
                    this.cursorY = 0;
                }
                this.cursorX = (int)((float)this.textLines[this.cursorY].length() * p);
                break;
            }
            case 263: {
                if (this.cursorX > 0) {
                    --this.cursorX;
                    if (this.cursorX <= 0 || curLine.charAt(this.cursorX - 1) != '\u00a7') break;
                    --this.cursorX;
                    break;
                }
                if (this.cursorX != 0 || this.cursorY <= 0) break;
                --this.cursorY;
                this.cursorX = this.textLines[this.cursorY].length();
                break;
            }
            case 262: {
                if (this.cursorX < curLine.length()) {
                    ++this.cursorX;
                    if (this.cursorX >= curLine.length() || curLine.charAt(this.cursorX - 1) != '\u00a7') break;
                    ++this.cursorX;
                    break;
                }
                if (this.cursorY >= this.textLines.length - 1) break;
                ++this.cursorY;
                this.cursorX = 0;
                break;
            }
            case 268: {
                this.cursorX = 0;
                break;
            }
            case 269: {
                this.cursorX = curLine.length();
                break;
            }
            case 257: {
                ++this.cursorY;
                int oldCursorX = this.cursorX;
                this.cursorX = 0;
                this.textLines = this.insertLine(this.textLines[this.cursorY - 1].substring(oldCursorX), this.cursorY);
                this.textLines[this.cursorY - 1] = this.textLines[this.cursorY - 1].substring(0, oldCursorX);
                updateTE = true;
                break;
            }
            case 259: {
                if (curLine.length() > 0 && this.cursorX > 0) {
                    this.textLines[this.cursorY] = curLine.substring(0, this.cursorX - 1) + curLine.substring(Math.min(curLine.length(), this.cursorX));
                    --this.cursorX;
                    if (this.cursorX > 0 && this.textLines[this.cursorY].charAt(this.cursorX - 1) == '\u00a7') {
                        this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.cursorX - 1) + this.textLines[this.cursorY].substring(Math.min(this.textLines[this.cursorY].length(), this.cursorX));
                        --this.cursorX;
                    }
                } else if (this.textLines.length > 1 && this.cursorY > 0) {
                    String line = this.textLines[this.cursorY];
                    this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)this.cursorY);
                    if (this.cursorY > 0) {
                        --this.cursorY;
                    }
                    this.cursorX = this.textLines[this.cursorY].length();
                    this.textLines[this.cursorY] = this.textLines[this.cursorY] + line;
                }
                updateTE = true;
                break;
            }
            case 261: {
                if (Screen.func_231173_s_()) {
                    this.textLines = new String[1];
                    this.textLines[0] = "";
                    this.cursorY = 0;
                    this.cursorX = 0;
                } else if (Screen.func_231174_t_()) {
                    if (this.textLines.length > 1) {
                        this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)this.cursorY);
                        if (this.cursorY > this.textLines.length - 1) {
                            this.cursorY = this.textLines.length - 1;
                        }
                    } else {
                        this.textLines[0] = "";
                        this.cursorX = 0;
                    }
                } else if (curLine.length() > 0 && this.cursorX < curLine.length()) {
                    int n = curLine.charAt(this.cursorX) == '\u00a7' && this.cursorX < curLine.length() - 1 ? 2 : 1;
                    this.textLines[this.cursorY] = curLine.substring(0, this.cursorX) + curLine.substring(this.cursorX + n);
                } else if (this.cursorY < this.textLines.length - 1) {
                    this.textLines[this.cursorY] = curLine + this.textLines[this.cursorY + 1];
                    this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)(this.cursorY + 1));
                }
                if (this.cursorX > this.textLines[this.cursorY].length()) {
                    this.cursorX = (int)((float)this.textLines[this.cursorY].length() * p);
                }
                updateTE = true;
            }
        }
        this.tile.setCursorPos(this.cursorX, this.cursorY);
        if (updateTE) {
            this.tile.setTextLines(this.textLines);
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char ch, int keyCode) {
        if (SharedConstants.func_71566_a((char)ch)) {
            if (Screen.func_231174_t_()) {
                if (ch >= 'a' && ch <= 'f' || ch >= 'l' && ch <= 'o' || ch == 'r' || ch >= '0' && ch <= '9') {
                    this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.cursorX) + "\u00a7" + ch + this.textLines[this.cursorY].substring(this.cursorX);
                }
                ++this.cursorX;
            } else {
                this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.cursorX) + ch + this.textLines[this.cursorY].substring(this.cursorX);
            }
            ++this.cursorX;
            this.tile.setTextLines(this.textLines);
        }
        return super.func_231042_a_(ch, keyCode);
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        this.tile.needMaxLineWidthRecalc();
        super.func_231164_f_();
    }

    private String[] insertLine(String line, int pos) {
        String[] newLines = new String[this.textLines.length + 1];
        newLines[pos] = line;
        if (pos > 0) {
            System.arraycopy(this.textLines, 0, newLines, 0, pos);
        }
        if (pos < this.textLines.length) {
            System.arraycopy(this.textLines, pos, newLines, pos + 1, this.textLines.length - pos);
        }
        return newLines;
    }

    public void onChangeSliderValue(Slider slider) {
        this.tile.setMarginSize((byte)slider.getValueInt());
    }
}

