/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerLiquidHopper;
import me.desht.pneumaticcraft.common.tileentity.TileEntityLiquidHopper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.IFluidTank;

public class GuiLiquidHopper
extends GuiPneumaticContainerBase<ContainerLiquidHopper, TileEntityLiquidHopper> {
    private WidgetAnimatedStat statusStat;
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[2];

    public GuiLiquidHopper(ContainerLiquidHopper container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new WidgetTank(this.field_147003_i + 116, this.field_147009_r + 15, (IFluidTank)((TileEntityLiquidHopper)this.te).getTank()));
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.hopperStatus", new Object[0]), new ItemStack((IItemProvider)ModBlocks.LIQUID_HOPPER.get()), -22016, false);
        WidgetAnimatedStat optionStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode", new Object[0]), new ItemStack((IItemProvider)Blocks.field_150442_at), -13312, false);
        optionStat.setMinimumExpandedDimensions(50, 43);
        WidgetButtonExtended button = new WidgetButtonExtended(20, 20, 20, 20, StringTextComponent.field_240750_d_).withTag("empty");
        button.setRenderStacks(new ItemStack((IItemProvider)Items.field_151133_ar));
        button.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidHopper.mode.empty", new Object[0]));
        optionStat.addSubWidget((Widget)button);
        this.modeButtons[0] = button;
        button = new WidgetButtonExtended(45, 20, 20, 20, StringTextComponent.field_240750_d_).withTag("leave");
        button.setRenderStacks(new ItemStack((IItemProvider)Items.field_151131_as));
        button.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidHopper.mode.leaveLiquid", new Object[0]));
        optionStat.addSubWidget((Widget)button);
        this.modeButtons[1] = button;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -1);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.statusStat.setText(this.getStatus());
        this.modeButtons[0].field_230693_o_ = ((TileEntityLiquidHopper)this.te).doesLeaveMaterial();
        this.modeButtons[1].field_230693_o_ = !((TileEntityLiquidHopper)this.te).doesLeaveMaterial();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_HOPPER;
    }

    private List<ITextComponent> getStatus() {
        ArrayList<ITextComponent> textList = new ArrayList<ITextComponent>();
        int itemsPer = ((TileEntityLiquidHopper)this.te).getMaxItems();
        if (itemsPer > 1) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.liquidTransferPerTick", itemsPer * 100));
        } else {
            int transferInterval = ((TileEntityLiquidHopper)this.te).getItemTransferInterval();
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.liquidTransferPerSecond", transferInterval == 0 ? "2000" : PneumaticCraftUtils.roundNumberTo(2000.0f / (float)transferInterval, 1)));
        }
        return textList;
    }

    @Override
    protected void addExtraUpgradeText(List<ITextComponent> text) {
        if (PNCConfig.Common.Machines.liquidHopperDispenser) {
            text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.upgrades.tile.liquid_hopper.dispenser", new Object[0]));
        }
    }
}

