/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.gui.GuiChargingUpgradeManager;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationUpgradeManager;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiPneumaticArmor
extends GuiChargingUpgradeManager {
    private final String registryName;
    private WidgetAnimatedStat statusStat;
    private final EquipmentSlotType equipmentSlot;

    public GuiPneumaticArmor(ContainerChargingStationUpgradeManager container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.registryName = this.itemStack.func_77973_b().getRegistryName().func_110623_a();
        this.equipmentSlot = ((ArmorItem)this.itemStack.func_77973_b()).func_185083_B_();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), Textures.GUI_INFO_LOCATION, -7829249, true).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.item." + this.registryName, new Object[0]));
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), this.itemStack, -22016, false);
        this.addUpgradeTabs(this.itemStack.func_77973_b(), "armor." + this.equipmentSlot.toString().toLowerCase(Locale.ROOT), "armor.generic");
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        CommonArmorHandler.getHandlerForPlayer().initArmorInventory(this.equipmentSlot);
        this.statusStat.setText(this.getStatusText());
    }

    private List<ITextComponent> getStatusText() {
        ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
        TextFormatting black = TextFormatting.BLACK;
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.pneumatic_armor.usage", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        float totalUsage = commonArmorHandler.getIdleAirUsage(this.equipmentSlot, true);
        if (totalUsage > 0.0f) {
            List<IArmorUpgradeHandler> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(this.equipmentSlot);
            for (int i = 0; i < handlers.size(); ++i) {
                IArmorUpgradeHandler handler;
                float upgradeUsage;
                if (!commonArmorHandler.isUpgradeInserted(this.equipmentSlot, i) || !((upgradeUsage = (handler = handlers.get(i)).getIdleAirUsage(commonArmorHandler)) > 0.0f)) continue;
                text.add((ITextComponent)new StringTextComponent(PneumaticCraftUtils.roundNumberTo(upgradeUsage, 1) + " mL/t (" + handler.getID() + ")").func_240699_a_(black));
            }
            text.add((ITextComponent)new StringTextComponent("--------+").func_240699_a_(black));
            text.add((ITextComponent)new StringTextComponent(PneumaticCraftUtils.roundNumberTo(totalUsage, 1) + " mL/t").func_240699_a_(black));
        } else {
            text.add((ITextComponent)new StringTextComponent("0.0 mL/t").func_240699_a_(black));
        }
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.pneumatic_armor.timeRemaining", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        int airLeft = (Integer)this.itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(IAirHandler::getAir).orElseThrow(RuntimeException::new);
        if (totalUsage == 0.0f) {
            if (airLeft > 0) {
                text.add((ITextComponent)new StringTextComponent("\u221e").func_240699_a_(black));
            } else {
                text.add((ITextComponent)new StringTextComponent("0s").func_240699_a_(black));
            }
        } else {
            text.add((ITextComponent)new StringTextComponent(PneumaticCraftUtils.convertTicksToMinutesAndSeconds((int)((float)airLeft / totalUsage), false)).func_240699_a_(black));
        }
        return text;
    }

    @Override
    protected int getDefaultVolume() {
        return ((ItemPneumaticArmor)this.itemStack.func_77973_b()).getBaseVolume();
    }
}

