/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.ITickableWidget;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.TextVariableParser;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;

public abstract class GuiPneumaticContainerBase<C extends ContainerPneumaticBase<T>, T extends TileEntityBase>
extends ContainerScreen<C> {
    public final T te;
    private IGuiAnimatedStat lastLeftStat;
    private IGuiAnimatedStat lastRightStat;
    private WidgetAnimatedStat pressureStat;
    private WidgetAnimatedStat redstoneTab;
    WidgetAnimatedStat problemTab;
    private final List<WidgetButtonExtended> redstoneButtons = new ArrayList<WidgetButtonExtended>();
    boolean firstUpdate = true;
    private final List<IGuiAnimatedStat> statWidgets = new ArrayList<IGuiAnimatedStat>();
    private int sendDelay = -1;

    public GuiPneumaticContainerBase(C container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.te = ((ContainerPneumaticBase)container).te;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.lastRightStat = null;
        this.lastLeftStat = null;
        if (this.shouldAddPressureTab() && this.te instanceof TileEntityPneumaticBase) {
            this.pressureStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.pressure", new Object[0]), new ItemStack((IItemProvider)ModBlocks.PRESSURE_TUBE.get()), -16733696, false);
            this.pressureStat.setForegroundColor(-16777216);
        }
        if (this.shouldAddProblemTab()) {
            this.problemTab = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems", new Object[0]), -6250336, false);
            this.problemTab.setForegroundColor(-16777216);
            this.problemTab.setMinimumExpandedDimensions(0, 16);
        }
        if (this.te != null) {
            if (this.shouldAddInfoTab()) {
                this.addInfoTab(GuiUtils.xlateAndSplit(ICustomTooltipName.getTranslationKey(new ItemStack((IItemProvider)this.te.func_195044_w().func_177230_c()), false), new Object[0]));
            }
            if (this.shouldAddRedstoneTab() && this.te instanceof IRedstoneControl) {
                this.addRedstoneTab(((IRedstoneControl)this.te).getRedstoneController());
            }
            if (this.te instanceof IHeatExchangingTE) {
                this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.heat.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151065_br), -2075392, false).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.heat", new Object[0]));
            }
            if (this.shouldAddUpgradeTab()) {
                this.addUpgradeTab();
            }
            if (this.shouldAddSideConfigTabs()) {
                this.addSideConfiguratorTabs();
            }
            if (this.te instanceof TileEntityPneumaticBase) {
                ((TileEntityPneumaticBase)this.te).initializeHullAirHandlers();
            }
        }
    }

    private WidgetAnimatedStat addAnimatedStat(ITextComponent title, WidgetAnimatedStat.StatIcon icon, int color, boolean leftSided) {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        WidgetAnimatedStat stat = new WidgetAnimatedStat((Screen)this, title, icon, xStart + (leftSided ? 0 : this.field_146999_f + 1), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : yStart + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        stat.setBeveled(true);
        this.func_230480_a_(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        this.statWidgets.add(stat);
        return stat;
    }

    protected WidgetAnimatedStat addAnimatedStat(ITextComponent title, @Nonnull ItemStack icon, int backgroundColor, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.of(icon), backgroundColor, leftSided);
    }

    protected WidgetAnimatedStat addAnimatedStat(ITextComponent title, ResourceLocation icon, int backgroundColor, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.of(icon), backgroundColor, leftSided);
    }

    protected WidgetAnimatedStat addAnimatedStat(ITextComponent title, int backgroundColor, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.NONE, backgroundColor, leftSided);
    }

    protected void addLabel(ITextComponent text, int x, int y) {
        this.func_230480_a_(new WidgetLabel(x, y, text));
    }

    protected void addLabel(ITextComponent text, int x, int y, int color) {
        this.func_230480_a_(new WidgetLabel(x, y, text, color));
    }

    void removeWidget(Widget widget) {
        this.field_230710_m_.remove(widget);
        this.field_230705_e_.remove(widget);
        if (widget instanceof IGuiAnimatedStat) {
            this.statWidgets.remove(widget);
        }
    }

    public List<IGuiAnimatedStat> getStatWidgets() {
        return this.statWidgets;
    }

    private void addRedstoneTab(RedstoneController<?> redstoneController) {
        this.redstoneTab = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour", new Object[0]), new ItemStack((IItemProvider)Items.field_151137_ax), -3407872, true);
        this.redstoneButtons.clear();
        int nModes = redstoneController.getModeCount();
        int bx = -23 * nModes;
        for (int i = 0; i < nModes; ++i) {
            this.redstoneButtons.add(this.createRedstoneModeButton(bx, i, redstoneController.getModeDetails(i)));
            bx += 23;
        }
        this.redstoneButtons.forEach(b -> this.redstoneTab.addSubWidget((Widget)b));
        this.redstoneTab.setText(redstoneController.getRedstoneTabTitle());
        this.redstoneTab.setMinimumExpandedDimensions(23 * nModes + 5, 46);
    }

    private WidgetButtonExtended createRedstoneModeButton(int x, int idx, RedstoneController.RedstoneMode<?> mode) {
        WidgetButtonExtended b = new WidgetButtonExtended(x, 24, 20, 20, StringTextComponent.field_240750_d_).withTag("redstone:" + idx);
        mode.getTexture().ifLeft(xva$0 -> b.setRenderStacks((ItemStack)xva$0)).ifRight(b::setRenderedIcon);
        b.setTooltipKey(mode.getTranslationKey(), new Object[0]);
        return b;
    }

    protected void addJeiFilterInfoTab() {
        if (ModList.get().isLoaded("jei")) {
            this.addAnimatedStat((ITextComponent)new StringTextComponent("JEI"), Textures.GUI_JEI_LOGO, -3215922, true).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.filterDrag", new Object[0]).func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    protected String upgradeCategory() {
        return this.te.func_200662_C().getRegistryName().func_110623_a();
    }

    private void addUpgradeTab() {
        ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
        ((TileEntityBase)this.te).getApplicableUpgrades().keySet().stream().sorted(Comparator.comparing(o -> o.getItemStack().func_200301_q().getString())).forEach(upgrade -> {
            int max = ((TileEntityBase)this.te).getApplicableUpgrades().get(upgrade);
            text.add((ITextComponent)upgrade.getItemStack().func_200301_q().func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.WHITE, TextFormatting.UNDERLINE}));
            text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.upgrades.max", max).func_240699_a_(TextFormatting.GRAY));
            String upgradeName = upgrade.toString().toLowerCase(Locale.ROOT);
            String k = "pneumaticcraft.gui.tab.upgrades." + this.upgradeCategory() + "." + upgradeName;
            text.addAll(I18n.func_188566_a((String)k) ? GuiUtils.xlateAndSplit(k, new Object[0]) : GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.upgrades.generic." + upgradeName, new Object[0]));
            text.add(StringTextComponent.field_240750_d_);
        });
        if (!text.isEmpty()) {
            this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.upgrades", new Object[0]), Textures.GUI_UPGRADES_LOCATION, -14398541, true).setText(text).setForegroundColor(-16777216);
        }
    }

    protected void addExtraUpgradeText(List<ITextComponent> upgradeText) {
    }

    private void addSideConfiguratorTabs() {
        for (SideConfigurator<?> sc : ((ISideConfigurable)this.te).getSideConfigurators()) {
            WidgetAnimatedStat stat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate(sc.getTranslationKey(), new Object[0]), new ItemStack((IItemProvider)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -7290656, false);
            stat.setMinimumExpandedDimensions(80, 80);
            int yTop = 15;
            int xLeft = 25;
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
        }
    }

    private WidgetButtonExtended makeSideConfButton(SideConfigurator<?> sideConfigurator, SideConfigurator.RelativeFace relativeFace, int x, int y) {
        WidgetButtonExtended button = new WidgetButtonExtended(x, y, 20, 20, StringTextComponent.field_240750_d_, b -> {
            WidgetButtonExtended gbs = (WidgetButtonExtended)b;
            ((ISideConfigurable)this.te).getSideConfigurators().stream().filter(sc -> sc.handleButtonPress(gbs.getTag())).findFirst().ifPresent(sc -> this.setupSideConfiguratorButton((SideConfigurator<?>)sc, gbs));
        }).withTag("SideConf." + relativeFace.toString());
        this.setupSideConfiguratorButton(sideConfigurator, button);
        return button;
    }

    private void setupSideConfiguratorButton(SideConfigurator<?> sc, WidgetButtonExtended button) {
        try {
            SideConfigurator.RelativeFace relativeFace = SideConfigurator.RelativeFace.valueOf(button.getTag().split("\\.")[1]);
            SideConfigurator.ConnectionEntry<?> c = sc.getEntry(relativeFace);
            if (c != null && c.getTexture() != null) {
                button.setTexture(c.getTexture());
            } else {
                button.setRenderedIcon(Textures.GUI_X_BUTTON);
            }
            button.setTooltipText((List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent(relativeFace.toString()).func_240699_a_(TextFormatting.YELLOW), (Object)sc.getFaceLabel(relativeFace)));
        }
        catch (IllegalArgumentException e) {
            Log.warning("Bad tag '" + button.getTag() + "'", new Object[0]);
        }
    }

    protected void addInfoTab(List<ITextComponent> info) {
        WidgetAnimatedStat stat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), Textures.GUI_INFO_LOCATION, -7829249, true);
        stat.setForegroundColor(-16777216);
        stat.setText(info);
        if (!ThirdPartyManager.instance().getDocsProvider().isInstalled()) {
            stat.appendText(Arrays.asList(StringTextComponent.field_240750_d_, PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.installDocsProvider", new Object[0])));
        }
    }

    protected void addInfoTab(ITextComponent info) {
        this.addInfoTab(Collections.singletonList(info));
    }

    protected boolean shouldAddRedstoneTab() {
        return true;
    }

    protected boolean shouldAddPressureTab() {
        return true;
    }

    protected boolean shouldAddUpgradeTab() {
        return true;
    }

    protected boolean shouldAddInfoTab() {
        return true;
    }

    protected boolean shouldAddProblemTab() {
        return true;
    }

    protected boolean shouldAddSideConfigTabs() {
        return this.te instanceof ISideConfigurable;
    }

    protected int getBackgroundTint() {
        return 0xFFFFFF;
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int i, int j) {
        if (this.shouldDrawBackground()) {
            GuiUtils.glColorHex(0xFF000000 | this.getBackgroundTint());
            this.bindGuiTexture();
            int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
            int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
            this.func_238474_b_(matrixStack, xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        PointXY gaugeLocation;
        if (this.getInvNameOffset() != null) {
            this.field_230712_o_.func_238422_b_(matrixStack, this.field_230704_d_.func_241878_f(), (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2.0f + (float)this.getInvNameOffset().x, (float)(5 + this.getInvNameOffset().y), this.getTitleColor());
        }
        if (this.getInvTextOffset() != null) {
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), (float)(8 + this.getInvTextOffset().x), (float)(this.field_147000_g - 94 + this.getInvTextOffset().y), 0x404040);
        }
        if (this.pressureStat != null && (gaugeLocation = this.getGaugeLocation()) != null) {
            TileEntityPneumaticBase pneu = (TileEntityPneumaticBase)this.te;
            float minWorking = this.te instanceof IMinWorkingPressure ? ((IMinWorkingPressure)this.te).getMinWorkingPressure() : -3.4028235E38f;
            PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.field_230712_o_, -1.0f, pneu.criticalPressure, pneu.dangerPressure, minWorking, pneu.getPressure(), gaugeLocation.x - this.field_147003_i, gaugeLocation.y - this.field_147009_r);
        }
    }

    void bindGuiTexture() {
        ResourceLocation guiTexture = this.getGuiTexture();
        if (guiTexture != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(guiTexture);
            RenderSystem.enableTexture();
        }
    }

    protected abstract ResourceLocation getGuiTexture();

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        for (IGuiAnimatedStat w : this.statWidgets) {
            if (!w.func_231045_a_(mouseX, mouseY, mouseButton, dragX, dragY)) continue;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTick) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, x, y, partialTick);
        this.func_230459_a_(matrixStack, x, y);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof ITooltipProvider) || !widget.func_230449_g_() || !widget.field_230694_p_) continue;
            ((ITooltipProvider)widget).addTooltip(x, y, tooltip, Screen.func_231173_s_());
        }
        if (this.shouldParseVariablesInTooltips()) {
            for (int i = 0; i < tooltip.size(); ++i) {
                tooltip.set(i, (ITextComponent)new StringTextComponent(new TextVariableParser(((ITextComponent)tooltip.get(i)).getString()).parse()));
            }
        }
        if (!tooltip.isEmpty()) {
            int max = Math.min(this.field_146999_f * 4 / 3, this.field_230708_k_ / 3);
            this.func_238654_b_(matrixStack, GuiUtils.wrapTextComponentList(tooltip, max, this.field_230712_o_), x, y);
        }
    }

    protected PointXY getGaugeLocation() {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        return new PointXY(xStart + this.field_146999_f * 3 / 4, yStart + this.field_147000_g / 4 + 4);
    }

    protected int getTitleColor() {
        return 0x404040;
    }

    protected PointXY getInvNameOffset() {
        return PointXY.ZERO;
    }

    protected PointXY getInvTextOffset() {
        return PointXY.ZERO;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.doDelayedAction();
            this.sendDelay = -1;
        }
        this.field_230710_m_.stream().filter(w -> w instanceof ITickableWidget).forEach(w -> ((ITickableWidget)w).tickWidget());
        if (this.pressureStat != null && this.pressureStat.isDoneExpanding()) {
            ArrayList<ITextComponent> pressureText = new ArrayList<ITextComponent>();
            this.addPressureStatInfo(pressureText);
            this.pressureStat.setText(pressureText);
        }
        if (this.problemTab != null && ((Minecraft.func_71410_x().field_71441_e.func_82737_E() & 7L) == 0L || this.firstUpdate)) {
            this.handleProblemsTab();
        }
        if (this.redstoneTab != null && this.te instanceof IRedstoneControl) {
            this.redstoneTab.setExtraTooltipText(Collections.singletonList(((IRedstoneControl)this.te).getRedstoneController().getDescription()));
            int rsMode = ((IRedstoneControl)this.te).getRedstoneMode();
            for (int i = 0; i < this.redstoneButtons.size(); ++i) {
                this.redstoneButtons.get((int)i).field_230693_o_ = i != rsMode;
            }
        }
        this.firstUpdate = false;
    }

    private void handleProblemsTab() {
        ArrayList<ITextComponent> problemText = new ArrayList<ITextComponent>();
        this.addProblems(problemText);
        int nProbs = problemText.size();
        this.addWarnings(problemText);
        int nWarnings = problemText.size() - nProbs;
        this.addInformation(problemText);
        if (nProbs > 0) {
            this.problemTab.setTexture(Textures.GUI_PROBLEMS_TEXTURE);
            this.problemTab.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems", new Object[0]));
            this.problemTab.setBackgroundColor(-65536);
        } else if (nWarnings > 0) {
            this.problemTab.setTexture(Textures.GUI_WARNING_TEXTURE);
            this.problemTab.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.warning", new Object[0]));
            this.problemTab.setBackgroundColor(-4145152);
        } else {
            this.problemTab.setTexture(Textures.GUI_NO_PROBLEMS_TEXTURE);
            this.problemTab.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.noProblems", new Object[0]));
            this.problemTab.setBackgroundColor(-8331136);
        }
        this.problemTab.setText(problemText);
    }

    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        this.te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(airHandler -> {
            float curPressure = airHandler.getPressure();
            int volume = airHandler.getVolume();
            int upgrades = ((TileEntityBase)this.te).getUpgrades(EnumUpgrade.VOLUME);
            airHandler.setVolumeUpgrades(upgrades);
            this.addPressureInfo(pressureStatText, curPressure, volume, airHandler.getBaseVolume(), upgrades);
        });
    }

    void addPressureInfo(List<ITextComponent> text, float curPressure, int volume, int baseVolume, int upgrades) {
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(curPressure, 2)));
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.air", String.format("%,d", Math.round(curPressure * (float)volume))));
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.baseVolume", String.format("%,d", baseVolume)));
        if (volume > baseVolume) {
            text.add((ITextComponent)new StringTextComponent("\u25b6 " + upgrades + " x ").func_230529_a_(EnumUpgrade.VOLUME.getItemStack().func_200301_q()));
            this.addExtraVolumeModifierInfo(text);
            text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.effectiveVolume", String.format("%,d", volume)));
        }
    }

    protected void addExtraVolumeModifierInfo(List<ITextComponent> text) {
    }

    protected void addProblems(List<ITextComponent> curInfo) {
        if (this.te instanceof IMinWorkingPressure) {
            float min = ((IMinWorkingPressure)this.te).getMinWorkingPressure();
            float pressure = ((TileEntityPneumaticBase)this.te).getPressure();
            if (min > 0.0f && pressure < min) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.notEnoughPressure", new Object[0]));
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.applyPressure", Float.valueOf(min)));
            } else if (min < 0.0f && pressure > min) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.notEnoughVacuum", new Object[0]));
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.applyVacuum", Float.valueOf(min)));
            }
        }
    }

    protected void addInformation(List<ITextComponent> curInfo) {
    }

    protected void addWarnings(List<ITextComponent> curInfo) {
        IRedstoneControl teR;
        if (this.te instanceof IRedstoneControl && !(teR = (IRedstoneControl)this.te).getRedstoneController().isEmitter() && !teR.getRedstoneController().shouldRun()) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.redstoneDisallows", new Object[0]));
            if (teR.getRedstoneMode() == 1) {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.provideRedstone", new Object[0]));
            } else {
                curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.removeRedstone", new Object[0]));
            }
        }
    }

    void sendGUIButtonPacketToServer(String tag) {
        NetworkHandler.sendToServer(new PacketGuiButton(tag));
    }

    void drawHoveringString(MatrixStack matrixStack, List<? extends ITextProperties> text, int x, int y, FontRenderer fontRenderer) {
        net.minecraftforge.fml.client.gui.GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)fontRenderer);
    }

    WidgetButtonExtended getButtonFromRectangle(String tag, Rectangle2d buttonSize, String buttonText, Button.IPressable pressable) {
        return new WidgetButtonExtended(buttonSize.func_199318_a(), buttonSize.func_199319_b(), buttonSize.func_199316_c(), buttonSize.func_199317_d(), buttonText, pressable).withTag(tag);
    }

    WidgetButtonExtended getInvisibleButtonFromRectangle(String tag, Rectangle2d buttonSize, Button.IPressable pressable) {
        return new WidgetButtonExtended(buttonSize.func_199318_a(), buttonSize.func_199319_b(), buttonSize.func_199316_c(), buttonSize.func_199317_d(), StringTextComponent.field_240750_d_, pressable).withTag(tag);
    }

    WidgetTextField getTextFieldFromRectangle(Rectangle2d textFieldSize) {
        return new WidgetTextField(this.field_230712_o_, textFieldSize.func_199318_a(), textFieldSize.func_199319_b(), textFieldSize.func_199316_c(), textFieldSize.func_199317_d());
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public List<Rectangle2d> getTabRectangles() {
        return this.getStatWidgets().stream().map(IGuiAnimatedStat::getBounds).collect(Collectors.toList());
    }

    void refreshScreen() {
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        int i = mw.func_198107_o();
        int j = mw.func_198087_p();
        this.func_231158_b_(Minecraft.func_71410_x(), i, j);
        this.field_230710_m_.stream().filter(widget -> widget instanceof ITickable).forEach(w -> ((ITickable)w).func_110550_d());
    }

    protected void sendDelayed(int ticks) {
        this.sendDelay = ticks;
    }

    protected void doDelayedAction() {
    }

    public void func_231164_f_() {
        if (this.sendDelay > 0) {
            this.doDelayedAction();
        }
        super.func_231164_f_();
    }

    protected boolean shouldParseVariablesInTooltips() {
        return false;
    }

    public void onGuiUpdate() {
    }

    public Collection<ItemStack> getTargetItems() {
        return Collections.emptyList();
    }

    public Collection<FluidStack> getTargetFluids() {
        return Collections.emptyList();
    }

    <R extends PneumaticCraftRecipe> Optional<R> getCurrentRecipe(PneumaticCraftRecipeType<R> type) {
        String id = ((TileEntityBase)this.te).getCurrentRecipeIdSynced();
        return id.isEmpty() ? Optional.empty() : Optional.ofNullable(type.getRecipe(ClientUtils.getClientWorld(), new ResourceLocation(id)));
    }
}

