/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRangeToggleButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.render.RenderHackSimulation;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationMain;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.tileentity.IRangedTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.GuiConstants;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiSecurityStationInventory
extends GuiPneumaticContainerBase<ContainerSecurityStationMain, TileEntitySecurityStation> {
    private WidgetAnimatedStat statusStat;
    private WidgetAnimatedStat accessStat;
    private WidgetButtonExtended addUserButton;
    private Button rebootButton;
    private WidgetTextField sharedUserTextField;
    private List<WidgetButtonExtended> sharedUserList;
    private RenderHackSimulation hackRenderer;
    private HackSimulation hackSimulation;
    private boolean reInitBG;

    public GuiSecurityStationInventory(ContainerSecurityStationMain container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 239;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.status", new Object[0]), new ItemStack((IItemProvider)ModBlocks.SECURITY_STATION.get()), -3112960, false);
        this.accessStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.sharedUsers", new Object[0]), new ItemStack((IItemProvider)Items.field_196184_dx), -16755456, false);
        Rectangle2d accessButtonRectangle = new Rectangle2d(105, 12, 16, 16);
        this.addUserButton = this.getButtonFromRectangle(null, accessButtonRectangle, "+", b -> {
            if (!this.sharedUserTextField.func_146179_b().isEmpty()) {
                NetworkHandler.sendToServer(new PacketGuiButton("add:" + this.sharedUserTextField.func_146179_b()));
                this.sharedUserTextField.func_146180_a("");
            }
        });
        this.sharedUserTextField = new WidgetTextField(this.field_230712_o_, 20, 15, 80, 10);
        this.accessStat.addSubWidget((Widget)this.sharedUserTextField);
        this.accessStat.addSubWidget((Widget)this.addUserButton);
        this.accessStat.setMinimumExpandedDimensions(125, 40);
        this.rebootButton = new WidgetButtonExtended(this.field_147003_i + 110, this.field_147009_r + 17, 60, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.reboot", new Object[0])).withTag("reboot");
        this.func_230480_a_((Widget)this.rebootButton);
        ((WidgetButtonExtended)this.func_230480_a_((Widget)new WidgetButtonExtended(this.field_147003_i + 110, this.field_147009_r + 107, 60, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.test", new Object[0])))).withTag("test");
        this.func_230480_a_((Widget)new WidgetRangeToggleButton(this.field_147003_i + 154, this.field_147009_r + 130, (IRangedTE)((Object)this.te)));
        this.updateUserList();
        this.initConnectionRendering();
    }

    private void initConnectionRendering() {
        this.hackRenderer = new RenderHackSimulation(this.field_147003_i + 25, this.field_147009_r + 27, 18);
        this.hackSimulation = HackSimulation.dummySimulation();
        this.hackSimulation.wakeUp();
        for (int i = 0; i < ((TileEntitySecurityStation)this.te).getPrimaryInventory().getSlots(); ++i) {
            this.hackSimulation.addNode(i, ((TileEntitySecurityStation)this.te).getPrimaryInventory().getStackInSlot(i));
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SECURITY_STATION;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float opacity, int x, int y) {
        super.func_230450_a_(matrixStack, opacity, x, y);
        this.hackRenderer.render(matrixStack, this.hackSimulation, -14540033);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.reInitBG) {
            this.initConnectionRendering();
            this.reInitBG = false;
        }
        this.hackSimulation.tick();
        this.statusStat.setText(this.getStatusText());
        this.accessStat.setText(this.getAccessText());
        Object rebootButtonString = ((TileEntitySecurityStation)this.te).getRebootTime() > 0 ? (((TileEntitySecurityStation)this.te).getRebootTime() % 100 < 20 ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.rebooting", new Object[0]) : new StringTextComponent(PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntitySecurityStation)this.te).getRebootTime(), false))) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.reboot", new Object[0]).func_240699_a_(TextFormatting.RED);
        this.rebootButton.func_238482_a_((ITextComponent)rebootButtonString);
        this.addUserButton.field_230694_p_ = this.accessStat.isDoneExpanding();
        for (WidgetButtonExtended button : this.sharedUserList) {
            button.field_230693_o_ = this.accessStat.isDoneExpanding();
        }
        if (this.sharedUserList.size() != ((TileEntitySecurityStation)this.te).sharedUsers.size()) {
            this.updateUserList();
        }
        this.rebootButton.field_230693_o_ = ((TileEntitySecurityStation)this.te).getRebootTime() == 0;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.sharedUserTextField.func_230999_j_() && !this.sharedUserTextField.func_146179_b().isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton("add:" + this.sharedUserTextField.func_146179_b()));
            this.sharedUserTextField.func_146180_a("");
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void addProblems(List<ITextComponent> text) {
        super.addProblems(text);
        if (((TileEntitySecurityStation)this.te).getRebootTime() > 0) {
            text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.security_station.rebooting", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntitySecurityStation)this.te).getRebootTime(), false)));
        } else if (((TileEntitySecurityStation)this.te).isHacked()) {
            text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.security_station.hacked", new Object[0]));
        }
        if (!((TileEntitySecurityStation)this.te).hasValidNetwork()) {
            text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.security_station.invalidNetwork", new Object[0]).func_240699_a_(TextFormatting.WHITE));
            TileEntitySecurityStation.EnumNetworkValidityProblem problem = ((TileEntitySecurityStation)this.te).checkForNetworkValidity();
            if (problem != TileEntitySecurityStation.EnumNetworkValidityProblem.NONE) {
                text.addAll(GuiUtils.xlateAndSplit(problem.getTranslationKey(), new Object[0]));
            }
        }
    }

    private List<ITextComponent> getStatusText() {
        ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
        StringTextComponent space = new StringTextComponent("  ");
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.protection", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        if (((TileEntitySecurityStation)this.te).getRebootTime() > 0) {
            text.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.rebooting", new Object[0])).func_240699_a_(TextFormatting.DARK_RED));
        } else if (((TileEntitySecurityStation)this.te).isHacked()) {
            text.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.hackedBy", new Object[0])).func_240699_a_(TextFormatting.DARK_RED));
            for (GameProfile hacker : ((TileEntitySecurityStation)this.te).hackedUsers) {
                text.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)GuiConstants.bullet()).func_240702_b_(hacker.getName()).func_240699_a_(TextFormatting.RED));
            }
        } else {
            text.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.secure", new Object[0])).func_240699_a_(TextFormatting.GREEN));
        }
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityLevel", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        text.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new StringTextComponent("L" + ((TileEntitySecurityStation)this.te).getSecurityLevel())).func_240699_a_(TextFormatting.BLACK));
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.detectChance", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        text.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new StringTextComponent(((TileEntitySecurityStation)this.te).getDetectionChance() + "%")).func_240699_a_(TextFormatting.BLACK));
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityRange", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        text.add((ITextComponent)new StringTextComponent("  ").func_230529_a_((ITextComponent)new StringTextComponent(((TileEntitySecurityStation)this.te).getRange() * 2 + 1 + "m\u00b2")).func_240699_a_(TextFormatting.BLACK));
        return text;
    }

    private List<ITextComponent> getAccessText() {
        ArrayList<ITextComponent> textList = new ArrayList<ITextComponent>();
        textList.add(StringTextComponent.field_240750_d_);
        textList.add(StringTextComponent.field_240750_d_);
        boolean first = true;
        List names = ((TileEntitySecurityStation)this.te).sharedUsers.stream().map(GameProfile::getName).sorted().collect(Collectors.toList());
        for (String name : names) {
            String str = first ? name + " \u2654" : name;
            textList.add((ITextComponent)GuiConstants.bullet().func_240702_b_(str).func_240699_a_(first ? TextFormatting.YELLOW : TextFormatting.WHITE));
            first = false;
        }
        return textList;
    }

    private void updateUserList() {
        if (this.sharedUserList != null) {
            for (WidgetButtonExtended button : this.sharedUserList) {
                this.accessStat.removeSubWidget((Widget)button);
            }
        }
        this.sharedUserList = new ArrayList<WidgetButtonExtended>();
        int n = 0;
        List names = ((TileEntitySecurityStation)this.te).sharedUsers.stream().map(GameProfile::getName).sorted().collect(Collectors.toList());
        for (String name : names) {
            this.field_230712_o_.getClass();
            Rectangle2d rect = new Rectangle2d(24, 30 + n * (9 + 1), this.field_230712_o_.func_78256_a(name), 8);
            WidgetButtonExtended button = this.getInvisibleButtonFromRectangle("remove:" + name, rect, b -> {});
            button.setInvisibleHoverColor(-2130771968);
            button.setVisible(false);
            this.accessStat.addSubWidget((Widget)button);
            this.sharedUserList.add(button);
            button.field_230694_p_ = !name.equals(this.field_230706_i_.field_71439_g.func_146103_bH().getName());
            ++n;
        }
    }

    public static void reinitConnectionRendering() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiSecurityStationInventory) {
            ((GuiSecurityStationInventory)Minecraft.func_71410_x().field_71462_r).reInitBG = true;
        }
    }
}

