/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.inventory.ContainerSentryTurret;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySentryTurret;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiSentryTurret
extends GuiPneumaticContainerBase<ContainerSentryTurret, TileEntitySentryTurret> {
    private WidgetTextField entityFilter;
    private WidgetButtonExtended errorButton;
    private String prevFilterText = "";

    public GuiSentryTurret(ContainerSentryTurret container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SENTRY_TURRET;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230712_o_.getClass();
        this.entityFilter = new WidgetTextField(this.field_230712_o_, this.field_147003_i + 80, this.field_147009_r + 63, 70, 9);
        this.func_230480_a_((Widget)this.entityFilter);
        this.entityFilter.func_146203_f(256);
        this.entityFilter.func_146195_b(true);
        this.func_231035_a_((IGuiEventListener)this.entityFilter);
        this.errorButton = new WidgetButtonExtended(this.field_147003_i + 155, this.field_147009_r + 52, 16, 16, StringTextComponent.field_240750_d_);
        this.func_230480_a_((Widget)this.errorButton);
        this.errorButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE).setVisible(false);
    }

    @Override
    public void func_231023_e_() {
        if (this.firstUpdate) {
            this.prevFilterText = ((TileEntitySentryTurret)this.te).getText(0);
            this.entityFilter.func_146180_a(((TileEntitySentryTurret)this.te).getText(0));
            this.entityFilter.func_212954_a(this::onEntityFilterChanged);
        }
        super.func_231023_e_();
        this.errorButton.field_230694_p_ = this.errorButton.hasTooltip();
    }

    private void onEntityFilterChanged(String newText) {
        try {
            if (!newText.equals(this.prevFilterText)) {
                new EntityFilter(newText);
                this.errorButton.setTooltipText(Collections.emptyList());
                this.sendDelayed(5);
                this.prevFilterText = newText;
            }
        }
        catch (IllegalArgumentException e) {
            this.errorButton.setTooltipText((ITextComponent)new StringTextComponent(e.getMessage()));
        }
    }

    @Override
    protected void doDelayedAction() {
        ((TileEntitySentryTurret)this.te).setText(0, this.entityFilter.func_146179_b());
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"pneumaticcraft.gui.sentryTurret.ammo", (Object[])new Object[0]), 80.0f, 19.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"pneumaticcraft.gui.sentryTurret.targetFilter", (Object[])new Object[0]), 80.0f, 53.0f, 0x404040);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(matrixStack, (Screen)this, this.field_230712_o_, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
        } else if (x >= this.field_147003_i + 76 && y >= this.field_147009_r + 51 && x <= this.field_147003_i + 153 && y <= this.field_147009_r + 74) {
            String str = I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter.holdF1", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrixStack, str, (float)(this.field_146999_f - this.field_230712_o_.func_78256_a(str)) / 2.0f, (float)(this.field_147000_g + 5), 0x808080);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return this.entityFilter.func_231046_a_(keyCode, scanCode, modifiers) || this.entityFilter.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void addProblems(List<ITextComponent> curInfo) {
        super.addProblems(curInfo);
        boolean hasAmmo = false;
        for (int i = 0; i < ((TileEntitySentryTurret)this.te).getPrimaryInventory().getSlots(); ++i) {
            if (((TileEntitySentryTurret)this.te).getPrimaryInventory().getStackInSlot(i).func_190926_b()) continue;
            hasAmmo = true;
            break;
        }
        if (!hasAmmo) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.sentryTurret.noAmmo", new Object[0]));
        }
    }
}

