/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerSmartChest;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.tileentity.RangeManager;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySmartChest;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class GuiSmartChest
extends GuiPneumaticContainerBase<ContainerSmartChest, TileEntitySmartChest> {
    private List<Pair<Integer, ItemStack>> filter;
    private IGuiAnimatedStat statusStat;
    private WidgetButtonExtended showRangeButton;

    public GuiSmartChest(ContainerSmartChest container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_146999_f = 234;
        this.field_147000_g = 216;
        this.filter = ((TileEntitySmartChest)this.te).getFilter();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.smart_chest.slots.title", new Object[0]), Textures.GUI_MOUSE_LOCATION, -16740144, true).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.smart_chest.slots", new Object[0]));
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((IItemProvider)ModBlocks.SMART_CHEST.get()), -22016, false);
        this.addPushPullTab();
        this.showRangeButton = new WidgetButtonExtended(this.field_147003_i + 196, this.field_147009_r + 189, 12, 12, "A", b -> this.previewRange());
        this.func_230480_a_((Widget)this.showRangeButton);
    }

    private void previewRange() {
        if (AreaRenderManager.getInstance().isShowing(this.te)) {
            AreaRenderManager.getInstance().removeHandlers(this.te);
        } else if (((TileEntitySmartChest)this.te).getUpgrades(EnumUpgrade.MAGNET) > 0) {
            int range = ((TileEntitySmartChest)this.te).getUpgrades(EnumUpgrade.RANGE) + 1;
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            for (SideConfigurator.RelativeFace face : SideConfigurator.RelativeFace.values()) {
                if (((TileEntitySmartChest)this.te).getPushPullMode(face) != TileEntitySmartChest.PushPullMode.PULL) continue;
                Direction dir = ((TileEntitySmartChest)this.te).getAbsoluteFacing(face, ((TileEntitySmartChest)this.te).getRotation());
                BlockPos pos = ((TileEntitySmartChest)this.te).func_174877_v().func_177967_a(dir, range + 1);
                posSet.addAll(RangeManager.getFrame(new AxisAlignedBB(pos, pos).func_186662_g((double)range)));
            }
            AreaRenderManager.getInstance().showArea(posSet, 0x4000FFFF, this.te, false);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.smartChestStatus.header", new Object[0]));
        text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.smartChestStatus.itemsPerOperation", ((TileEntitySmartChest)this.te).getMaxItems()));
        text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.smartChestStatus.tickInterval", ((TileEntitySmartChest)this.te).getTickRate()));
        this.statusStat.setText(text);
        if (((TileEntitySmartChest)this.te).getUpgrades(EnumUpgrade.MAGNET) > 0) {
            this.showRangeButton.setVisible(true);
            if (AreaRenderManager.getInstance().isShowing(this.te)) {
                this.showRangeButton.func_238482_a_((ITextComponent)new StringTextComponent("R").func_240699_a_(TextFormatting.AQUA));
                this.showRangeButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.stopShowingArea", new Object[0]));
            } else {
                this.showRangeButton.func_238482_a_((ITextComponent)new StringTextComponent("R").func_240699_a_(TextFormatting.GRAY));
                this.showRangeButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showArea", new Object[0]));
            }
        } else {
            this.showRangeButton.setVisible(false);
        }
    }

    private void addPushPullTab() {
        WidgetAnimatedStat stat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.smart_chest.push_pull.title", new Object[0]), new ItemStack((IItemProvider)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -7290656, false);
        stat.setMinimumExpandedDimensions(80, 80);
        int yTop = 15;
        int xLeft = 25;
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
    }

    private WidgetButtonExtended makePushPullButton(SideConfigurator.RelativeFace face, int x, int y) {
        WidgetButtonExtended button = new WidgetButtonExtended(x, y, 20, 20, StringTextComponent.field_240750_d_, b -> {
            ((TileEntitySmartChest)this.te).cycleMode(face);
            this.setupPushPullButton((WidgetButtonExtended)b, face);
        }).withTag("push_pull:" + face.toString());
        this.setupPushPullButton(button, face);
        return button;
    }

    private void setupPushPullButton(WidgetButtonExtended button, SideConfigurator.RelativeFace face) {
        TileEntitySmartChest.PushPullMode mode = ((TileEntitySmartChest)this.te).getPushPullMode(face);
        switch (mode) {
            case NONE: {
                button.setRenderedIcon(Textures.GUI_X_BUTTON);
                break;
            }
            case PUSH: {
                button.setRenderStacks(new ItemStack((IItemProvider)Blocks.field_150331_J));
                break;
            }
            case PULL: {
                button.setRenderStacks(new ItemStack((IItemProvider)Blocks.field_150320_F));
            }
        }
        button.setTooltipText((List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent(face.toString()).func_240699_a_(TextFormatting.YELLOW), (Object)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0])));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SMART_CHEST;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return true;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTick) {
        super.func_230430_a_(matrixStack, x, y, partialTick);
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75211_c().func_190926_b() && this.field_147006_u.field_75222_d < 72 && !((TileEntitySmartChest)this.te).getFilter(this.field_147006_u.field_75222_d).func_190926_b()) {
            ItemStack stack = ((TileEntitySmartChest)this.te).getFilter(this.field_147006_u.field_75222_d);
            List<IReorderingProcessor> l = GuiUtils.wrapTextComponentList(GuiUtils.xlateAndSplit("pneumaticcraft.gui.smart_chest.filter", stack.func_200301_q().getString(), stack.func_190916_E()), this.field_146999_f, this.field_230712_o_);
            this.func_238654_b_(matrixStack, l, x, y);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        super.func_230450_a_(matrixStack, partialTicks, x, y);
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (Pair<Integer, ItemStack> p : this.filter) {
            int slot = (Integer)p.getLeft();
            if (slot >= ((TileEntitySmartChest)this.te).getLastSlot() || !((Slot)((ContainerSmartChest)this.field_147002_h).field_75151_b.get(slot)).func_75216_d()) continue;
            int sx = this.field_147003_i + 8 + slot % 12 * 18;
            int sy = this.field_147009_r + 18 + slot / 12 * 18;
            GuiSmartChest.func_238467_a_((MatrixStack)matrixStack, (int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)-2139041664);
        }
        for (int slot = ((TileEntitySmartChest)this.te).getLastSlot(); slot < 72; ++slot) {
            int sx = this.field_147003_i + 8 + slot % 12 * 18;
            int sy = this.field_147009_r + 18 + slot / 12 * 18;
            GuiSmartChest.func_238467_a_((MatrixStack)matrixStack, (int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)1090478176);
        }
        RenderSystem.disableBlend();
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (Pair<Integer, ItemStack> p : this.filter) {
            int slot = (Integer)p.getLeft();
            if (slot >= ((TileEntitySmartChest)this.te).getLastSlot()) continue;
            int sx = 8 + slot % 12 * 18;
            int sy = 18 + slot / 12 * 18;
            matrixStack.func_227860_a_();
            ItemStack stack = (ItemStack)p.getRight();
            GuiUtils.renderItemStack(matrixStack, stack, sx, sy);
            String label = "[" + stack.func_190916_E() + "]";
            matrixStack.func_227861_a_(0.0, 0.0, 300.0);
            if (!((Slot)((ContainerSmartChest)this.field_147002_h).field_75151_b.get(slot)).func_75216_d()) {
                GuiSmartChest.func_238467_a_((MatrixStack)matrixStack, (int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)1619054720);
            }
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.field_230712_o_.func_238405_a_(matrixStack, label, 2.0f * ((float)(sx + 16) - (float)this.field_230712_o_.func_78256_a(label) / 2.0f), (float)(2 * (sy + 1)), -96);
            matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
            matrixStack.func_227865_b_();
        }
        RenderSystem.disableBlend();
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null && slotId < 72 && mouseButton == 0 && Screen.func_231174_t_()) {
            ItemStack stack = slotIn.func_75211_c();
            if (stack.func_190926_b() && slotId > 0 && ((TileEntitySmartChest)this.te).getFilter(slotId).func_190926_b()) {
                if (this.field_213127_e.func_70445_o().func_190926_b()) {
                    if (slotId == ((TileEntitySmartChest)this.te).getLastSlot()) {
                        ((TileEntitySmartChest)this.te).setLastSlot(72);
                    } else {
                        for (int i = slotId; i < 72; ++i) {
                            if (((Slot)((ContainerSmartChest)this.field_147002_h).field_75151_b.get(i)).func_75211_c().func_190926_b()) continue;
                            return;
                        }
                        ((TileEntitySmartChest)this.te).setLastSlot(slotId);
                    }
                } else {
                    ItemStack inHand = this.field_213127_e.func_70445_o().func_77946_l();
                    if (GuiSmartChest.func_231173_s_()) {
                        inHand.func_190920_e(inHand.func_77976_d());
                    }
                    ((TileEntitySmartChest)this.te).setFilter(slotId, inHand);
                    if (((TileEntitySmartChest)this.te).getLastSlot() <= slotId) {
                        ((TileEntitySmartChest)this.te).setLastSlot(slotId + 1);
                    }
                    this.filter = ((TileEntitySmartChest)this.te).getFilter();
                }
                NetworkHandler.sendToServer(new PacketSyncSmartChest((TileEntitySmartChest)this.te));
            } else {
                if (((TileEntitySmartChest)this.te).getFilter(slotId).func_190926_b()) {
                    ((TileEntitySmartChest)this.te).setFilter(slotId, GuiSmartChest.func_231173_s_() ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.func_77976_d()) : stack);
                } else {
                    ((TileEntitySmartChest)this.te).setFilter(slotId, ItemStack.field_190927_a);
                }
                this.filter = ((TileEntitySmartChest)this.te).getFilter();
                NetworkHandler.sendToServer(new PacketSyncSmartChest((TileEntitySmartChest)this.te));
            }
        } else {
            super.func_184098_a(slotIn, slotId, mouseButton, type);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dir) {
        Slot s = this.getSlotUnderMouse();
        if (Screen.func_231174_t_() && s != null && s.field_75222_d < 72) {
            ItemStack stack = ((TileEntitySmartChest)this.te).getFilter(s.field_75222_d);
            if (!stack.func_190926_b()) {
                int newSize = GuiSmartChest.func_231173_s_() ? (dir > 0.0 ? stack.func_190916_E() * 2 : stack.func_190916_E() / 2) : stack.func_190916_E() + (int)dir;
                newSize = MathHelper.func_76125_a((int)newSize, (int)1, (int)stack.func_77976_d());
                if (newSize != stack.func_190916_E()) {
                    ((TileEntitySmartChest)this.te).setFilter(s.field_75222_d, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)newSize));
                    this.filter = ((TileEntitySmartChest)this.te).getFilter();
                    this.sendDelayed(5);
                }
            }
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, dir);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        ItemStack stack;
        Slot s = this.getSlotUnderMouse();
        if (Screen.func_231174_t_() && s != null && s.field_75222_d < 72 && !(stack = ((TileEntitySmartChest)this.te).getFilter(s.field_75222_d)).func_190926_b()) {
            int newSize = stack.func_190916_E();
            switch (keyCode) {
                case 265: {
                    newSize = Screen.func_231173_s_() ? newSize * 2 : newSize + 1;
                    break;
                }
                case 264: {
                    newSize = Screen.func_231173_s_() ? newSize / 2 : newSize - 1;
                }
            }
            newSize = MathHelper.func_76125_a((int)newSize, (int)1, (int)stack.func_77976_d());
            if (newSize != stack.func_190916_E()) {
                ((TileEntitySmartChest)this.te).setFilter(s.field_75222_d, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)newSize));
                this.filter = ((TileEntitySmartChest)this.te).getFilter();
                this.sendDelayed(5);
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketSyncSmartChest((TileEntitySmartChest)this.te));
    }
}

