/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorSetting;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRangeToggleButton;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerUniversalSensor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.tileentity.IRangedTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUniversalSensor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiUniversalSensor
extends GuiPneumaticContainerBase<ContainerUniversalSensor, TileEntityUniversalSensor> {
    private static final int MAX_TEXTFIELD_LENGTH = 256;
    private WidgetAnimatedStat sensorInfoStat;
    private TextFieldWidget nameFilterField;
    private int page;
    private int maxPage;
    private static final int MAX_SENSORS_PER_PAGE = 4;
    private int ticksExisted;
    private final List<Widget> sensorButtons = new ArrayList<Widget>();

    public GuiUniversalSensor(ContainerUniversalSensor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 239;
    }

    public static void maybeUpdateButtons() {
        Screen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiUniversalSensor) {
            ((GuiUniversalSensor)guiScreen).updateButtons();
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_UNIVERSAL_SENSOR;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.sensorInfoStat = this.addAnimatedStat((ITextComponent)new StringTextComponent("Sensor Info"), new ItemStack((IItemProvider)ModBlocks.UNIVERSAL_SENSOR.get()), -22016, false);
        this.sensorInfoStat.setForegroundColor(-16777216);
        this.nameFilterField = new TextFieldWidget(this.field_230712_o_, xStart + 70, yStart + 58, 98, 10, StringTextComponent.field_240750_d_);
        this.nameFilterField.func_146203_f(256);
        this.nameFilterField.func_146180_a(((TileEntityUniversalSensor)this.te).getText(0));
        this.nameFilterField.func_212954_a(s -> this.sendDelayed(5));
        this.func_230480_a_((Widget)this.nameFilterField);
        this.updateButtons();
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        String[] folders;
        super.func_230451_b_(matrixStack, x, y);
        if (this.maxPage > 1) {
            this.field_230712_o_.func_238421_b_(matrixStack, this.page + "/" + this.maxPage, 110.0f, 134.0f, 0x404040);
        }
        if ((folders = ((TileEntityUniversalSensor)this.te).getSensorSetting().split("/")).length == 1 && !folders[0].isEmpty()) {
            Set<EnumUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText(folders[0]);
            int curX = 92;
            for (EnumUpgrade upgrade : requiredUpgrades) {
                GuiUtils.renderItemStack(matrixStack, upgrade.getItemStack(), curX, 20);
                curX += 18;
            }
        } else {
            int xSpace = this.field_146999_f - 96;
            int size = this.field_230712_o_.func_78256_a(folders[folders.length - 1]);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(92.0, 24.0, 0.0);
            if (size > xSpace) {
                matrixStack.func_227862_a_((float)xSpace / (float)size, 1.0f, 1.0f);
            }
            this.field_230712_o_.func_238421_b_(matrixStack, folders[folders.length - 1], 0.0f, 0.0f, 0x4040A0);
            matrixStack.func_227865_b_();
        }
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        if (sensor != null) {
            ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
            sensor.getAdditionalInfo(info);
            int yOff = 0;
            for (ITextComponent line : info) {
                this.field_230712_o_.func_238422_b_(matrixStack, line.func_241878_f(), 70.0f, (float)(48 + yOff), 0x404040);
                this.field_230712_o_.getClass();
                yOff += 9;
            }
            this.nameFilterField.field_230691_m_ = this.field_147009_r + 48 + yOff + 2;
        }
        if (this.nameFilterField.field_230694_p_ && sensor != null && sensor.isEntityFilter()) {
            if (ClientUtils.isKeyDown(290)) {
                GuiUtils.showPopupHelpScreen(matrixStack, (Screen)this, this.field_230712_o_, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
            } else {
                String str = I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter.holdF1", (Object[])new Object[0]);
                this.field_230712_o_.func_238421_b_(matrixStack, str, (float)(this.field_146999_f - this.field_230712_o_.func_78256_a(str)) / 2.0f, (float)(this.field_147000_g + 5), 0x808080);
            }
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return this.nameFilterField.func_231046_a_(keyCode, scanCode, modifiers) || this.nameFilterField.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        return new PointXY(xStart + 34, yStart + this.field_147000_g / 4 - 18);
    }

    private void updateButtons() {
        this.sensorButtons.forEach(w -> {
            this.field_230710_m_.remove(w);
            this.field_230705_e_.remove(w);
        });
        this.sensorButtons.clear();
        String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(((TileEntityUniversalSensor)this.te).getSensorSetting());
        if (!((TileEntityUniversalSensor)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((Widget)new WidgetButtonExtended(this.field_147003_i + 70, this.field_147009_r + 20, 16, 16, "\u27f5").withTag("back"));
        }
        if (directories.length == 0 || ((TileEntityUniversalSensor)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((Widget)new WidgetRangeToggleButton(this.field_147003_i + 150, this.field_147009_r + 130, (IRangedTE)((Object)this.te)));
        }
        this.maxPage = (directories.length - 1) / 4 + 1;
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.maxPage > 1) {
            this.addButtonLocal((Widget)new WidgetButtonExtended(this.field_147003_i + 70, this.field_147009_r + 40 + 88, 30, 20, "\u25c0", b -> {
                --this.page;
                if (this.page <= 0) {
                    this.page = this.maxPage;
                }
                this.updateButtons();
            }));
            this.addButtonLocal((Widget)new WidgetButtonExtended(this.field_147003_i + 138, this.field_147009_r + 40 + 88, 30, 20, "\u25b6", b -> {
                ++this.page;
                if (this.page > this.maxPage) {
                    this.page = 1;
                }
                this.updateButtons();
            }));
        }
        int buttonsOnPage = 4;
        if (this.page == this.maxPage && (directories.length % 4 > 0 || directories.length == 0)) {
            buttonsOnPage = directories.length % 4;
        }
        for (int i = 0; i < buttonsOnPage; ++i) {
            String buttonText = directories[i + (this.page - 1) * 4];
            if (SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting() + "/" + buttonText) != null) {
                buttonText = TextFormatting.YELLOW + buttonText;
            }
            int buttonID = i * 10 + 10 + (this.page - 1) * 4 * 10;
            int buttonX = this.field_147003_i + 70;
            int buttonY = this.field_147009_r + 40 + i * 22;
            int buttonWidth = 98;
            int buttonHeight = 20;
            if (((TileEntityUniversalSensor)this.te).getSensorSetting().equals("")) {
                Set<EnumUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText(buttonText);
                WidgetButtonExtended button = new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, "").withTag("set:" + buttonID);
                button.setRenderStacks((ItemStack[])requiredUpgrades.stream().map(EnumUpgrade::getItemStack).toArray(ItemStack[]::new));
                button.field_230693_o_ = (((TileEntityUniversalSensor)this.te).sensorStatus == TileEntityUniversalSensor.SensorStatus.OK || ((TileEntityUniversalSensor)this.te).sensorStatus == TileEntityUniversalSensor.SensorStatus.NO_SENSOR) && ((TileEntityUniversalSensor)this.te).areGivenUpgradesInserted(requiredUpgrades);
                this.addButtonLocal((Widget)button);
                continue;
            }
            this.addButtonLocal((Widget)new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, buttonText).withTag("set:" + buttonID));
        }
        this.sensorInfoStat.setText(this.getSensorInfo());
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        boolean textboxEnabled = sensor != null && sensor.needsTextBox();
        this.nameFilterField.func_146189_e(textboxEnabled);
        if (textboxEnabled) {
            this.func_231035_a_((IGuiEventListener)this.nameFilterField);
            RangedInteger range = sensor.getTextboxIntRange();
            if (range != null) {
                this.nameFilterField.func_200675_a(s -> this.validateTextValue((String)s, range));
                String max = Integer.toString(range.func_233019_b_());
                this.nameFilterField.func_146203_f(max.length() + 1);
                this.nameFilterField.func_230991_b_(this.field_230712_o_.func_78256_a(max) + 10);
            } else {
                this.nameFilterField.func_200675_a(Objects::nonNull);
                this.nameFilterField.func_146203_f(256);
                this.nameFilterField.func_230991_b_(98);
            }
        }
        this.nameFilterField.func_146195_b(textboxEnabled);
    }

    private boolean validateTextValue(String s, RangedInteger r) {
        if (PneumaticCraftUtils.isInteger(s)) {
            int n = s.isEmpty() || s.equals("-") ? 0 : Integer.parseInt(s);
            return n >= r.func_233016_a_() && n < r.func_233019_b_();
        }
        return false;
    }

    private void addButtonLocal(Widget w) {
        this.func_230480_a_(w);
        this.sensorButtons.add(w);
    }

    @Override
    protected void doDelayedAction() {
        ((TileEntityUniversalSensor)this.te).setText(0, this.nameFilterField.func_146179_b());
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (((TileEntityUniversalSensor)this.te).getSensorSetting().isEmpty() && this.ticksExisted++ > 5) {
            this.ticksExisted = 0;
            this.updateButtons();
        }
        if (!this.nameFilterField.func_230999_j_()) {
            this.nameFilterField.func_146180_a(((TileEntityUniversalSensor)this.te).getText(0));
        }
    }

    private List<ITextComponent> getSensorInfo() {
        ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((TileEntityUniversalSensor)this.te).getSensorSetting());
        if (sensor != null) {
            String[] folders = ((TileEntityUniversalSensor)this.te).getSensorSetting().split("/");
            text.add((ITextComponent)new StringTextComponent(folders[folders.length - 1]).func_240699_a_(TextFormatting.WHITE));
            text.addAll(GuiUtils.xlateAndSplit(sensor.getDescription().get(0), new Object[0]));
        } else {
            text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]).func_240699_a_(TextFormatting.BLACK));
        }
        return text;
    }

    @Override
    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityUniversalSensor)this.te).isSensorActive) {
            pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.airUsage", 1).func_240699_a_(TextFormatting.BLACK));
        }
    }

    @Override
    protected void addWarnings(List<ITextComponent> curInfo) {
        super.addWarnings(curInfo);
        if (!((TileEntityUniversalSensor)this.te).getPrimaryInventory().getStackInSlot(0).func_190926_b() && ((TileEntityUniversalSensor)this.te).outOfRange > 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.universalSensor.outOfRange", ((TileEntityUniversalSensor)this.te).outOfRange));
        }
    }

    @Override
    protected void addProblems(List<ITextComponent> curInfo) {
        super.addProblems(curInfo);
        if (!((TileEntityUniversalSensor)this.te).lastSensorExceptionText.isEmpty()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.universalSensor.sensorException", ((TileEntityUniversalSensor)this.te).lastSensorExceptionText));
        }
        if (((TileEntityUniversalSensor)this.te).sensorStatus != TileEntityUniversalSensor.SensorStatus.OK) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((TileEntityUniversalSensor)this.te).sensorStatus.getTranslationKey(), new Object[0]));
        }
    }
}

