/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens;

import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiMoveStat;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.AbstractSliderOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsClientHandler;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class JetBootsOptions
extends AbstractSliderOptions<JetBootsClientHandler> {
    private WidgetKeybindCheckBox checkBoxBuilderMode;
    private WidgetKeybindCheckBox checkBoxStabilizers;

    public JetBootsOptions(IGuiScreen screen, JetBootsClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        super.populateGui(gui);
        this.checkBoxBuilderMode = WidgetKeybindCheckBox.getOrCreate(PneumaticCraftUtils.RL("jet_boots.module.builder_mode"), 5, 45, -1, b -> this.setFlag("JetBootsBuilderMode", 3, (WidgetKeybindCheckBox)b)).withOwnerUpgradeID(((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler().getID());
        gui.addWidget(this.checkBoxBuilderMode);
        this.checkBoxStabilizers = WidgetKeybindCheckBox.getOrCreate(PneumaticCraftUtils.RL("jet_boots.module.flight_stabilizers"), 5, 65, -1, b -> this.setFlag("JetBootsStabilizers", 4, (WidgetKeybindCheckBox)b)).withOwnerUpgradeID(((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler().getID());
        gui.addWidget(this.checkBoxStabilizers);
        gui.addWidget(new WidgetButtonExtended(30, 128, 150, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.moveStatScreen", new Object[0]), b -> {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiMoveStat((IArmorUpgradeClientHandler)this.getClientUpgradeHandler(), ArmorHUDLayout.LayoutType.JET_BOOTS));
        }));
    }

    @Override
    protected PointXY getSliderPos() {
        return new PointXY(30, 80);
    }

    private void setFlag(String flagName, int minTier, WidgetKeybindCheckBox cb) {
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        if (commonArmorHandler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= minTier) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a(flagName, cb.checked);
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlotType.FEET, tag));
            CommonArmorHandler.getHandlerForPlayer().onDataFieldUpdated(flagName, tag.func_74781_a(flagName));
            ResourceLocation ownerId = ((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler().getID();
            HUDHandler.getInstance().addFeatureToggleMessage(ArmorUpgradeRegistry.getStringKey(ownerId), ArmorUpgradeRegistry.getStringKey(cb.getUpgradeId()), cb.checked);
        }
    }

    @Override
    public void tick() {
        super.tick();
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
        this.checkBoxBuilderMode.field_230693_o_ = handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= 3;
        this.checkBoxStabilizers.field_230693_o_ = handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= 4;
    }

    @Override
    protected String getTagName() {
        return "JetBootsPower";
    }

    @Override
    protected ITextComponent getPrefix() {
        return new StringTextComponent("Power: ");
    }

    @Override
    protected ITextComponent getSuffix() {
        return new StringTextComponent("%");
    }
}

