/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiTubeModule;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetColorSelector;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.DyeColor;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiRedstoneModule
extends GuiTubeModule<ModuleRedstone> {
    private WidgetComboBox comboBox;
    private WidgetLabel constLabel;
    private WidgetTextFieldNumber textField;
    private WidgetLabel otherColorLabel;
    private WidgetColorSelector otherColorButton;
    private int ourColor;
    private int otherColor;
    private WidgetCheckBox invertCheckBox;
    private WidgetCheckBox comparatorInputCheckBox;
    private boolean upgraded;
    private boolean output;
    private final List<IReorderingProcessor> lowerText = new ArrayList<IReorderingProcessor>();

    public GuiRedstoneModule(ModuleRedstone module) {
        super(module);
        this.ySize = module.getRedstoneDirection() == ModuleRedstone.EnumRedstoneDirection.OUTPUT ? 202 : 57;
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.output ? Textures.GUI_WIDGET_OPTIONS : Textures.GUI_MODULE_SIMPLE;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.upgraded = ((ModuleRedstone)this.module).isUpgraded();
        this.output = ((ModuleRedstone)this.module).getRedstoneDirection() == ModuleRedstone.EnumRedstoneDirection.OUTPUT;
        this.ourColor = ((ModuleRedstone)this.module).getColorChannel();
        this.otherColor = ((ModuleRedstone)this.module).getOtherColor();
        this.func_230480_a_((Widget)new WidgetButtonExtended(this.guiLeft + this.xSize - 22, this.guiTop + 2, 18, 12, this.getDirText((ModuleRedstone)this.module), b -> this.toggleRedstoneDirection()).setTooltipText((List<ITextComponent>)ImmutableList.of((Object)PneumaticCraftUtils.xlate(((ModuleRedstone)this.module).getRedstoneDirection().getTranslationKey(), new Object[0]), (Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.clickToToggle", new Object[0]).func_240699_a_(TextFormatting.GRAY))));
        this.func_230480_a_(new WidgetLabel(this.guiLeft + this.xSize / 2, this.guiTop + 5, this.func_231171_q_()).setAlignment(WidgetLabel.Alignment.CENTRE));
        WidgetLabel ourColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 25, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.channel", new Object[0]));
        this.func_230480_a_(ourColorLabel);
        WidgetLabel opLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 45, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.operation", new Object[0]));
        this.func_230480_a_(opLabel);
        opLabel.field_230694_p_ = this.output;
        this.otherColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 65, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.otherChannel", new Object[0]));
        this.otherColorLabel.field_230694_p_ = this.output;
        this.func_230480_a_(this.otherColorLabel);
        this.constLabel = new WidgetLabel(this.guiLeft + 15, this.guiTop + 65, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.constant", new Object[0]));
        this.func_230480_a_(this.constLabel);
        this.constLabel.field_230694_p_ = this.output;
        int w = 0;
        for (WidgetLabel label : ImmutableList.of((Object)ourColorLabel, (Object)this.otherColorLabel, (Object)opLabel, (Object)this.constLabel)) {
            w = Math.max(label.func_230998_h_(), w);
        }
        int xBase = this.guiLeft + w + 15;
        this.func_230480_a_((Widget)new WidgetColorSelector(xBase, this.guiTop + 20, b -> {
            this.ourColor = b.getColor().func_196059_a();
        }).withInitialColor(DyeColor.func_196056_a((int)this.ourColor)));
        if (!this.output) {
            this.comparatorInputCheckBox = new WidgetCheckBox(this.guiLeft + 10, this.guiTop + 40, -12566464, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.comparatorInput", new Object[0]));
            this.comparatorInputCheckBox.setChecked(((ModuleRedstone)this.module).isComparatorInput());
            this.comparatorInputCheckBox.setTooltipKey("pneumaticcraft.gui.redstoneModule.comparatorInput.tooltip");
            this.comparatorInputCheckBox.field_230694_p_ = !this.output && this.upgraded;
            this.func_230480_a_(this.comparatorInputCheckBox);
        } else {
            this.comboBox = new WidgetComboBox(this.field_230712_o_, xBase, this.guiTop + 43, this.xSize - xBase + this.guiLeft - 10, 12).initFromEnum(((ModuleRedstone)this.module).getOperation());
            this.comboBox.field_230693_o_ = this.upgraded;
            this.func_230480_a_((Widget)this.comboBox);
            this.otherColorButton = new WidgetColorSelector(xBase, this.guiTop + 60, b -> {
                this.otherColor = b.getColor().func_196059_a();
            }).withInitialColor(DyeColor.func_196056_a((int)this.otherColor));
            this.otherColorButton.field_230693_o_ = this.upgraded;
            this.func_230480_a_((Widget)this.otherColorButton);
            this.textField = new WidgetTextFieldNumber(this.field_230712_o_, xBase, this.guiTop + 63, 30, 12);
            this.textField.minValue = 0;
            this.textField.setDecimals(0);
            this.textField.setValue(((ModuleRedstone)this.module).getConstantVal());
            this.textField.field_230693_o_ = this.upgraded;
            this.func_230480_a_((Widget)this.textField);
            this.invertCheckBox = new WidgetCheckBox(this.guiLeft + 10, this.guiTop + 85, -12566464, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.invert", new Object[0])){

                public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                    if (GuiRedstoneModule.this.comboBox.func_230999_j_()) {
                        return true;
                    }
                    return super.func_231044_a_(mouseX, mouseY, button);
                }
            };
            this.invertCheckBox.setChecked(((ModuleRedstone)this.module).isInverted());
            this.invertCheckBox.setTooltipKey("pneumaticcraft.gui.redstoneModule.invert.tooltip");
            this.func_230480_a_(this.invertCheckBox);
            this.updateWidgetVisibility();
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.output) {
            if (this.upgraded) {
                this.updateWidgetVisibility();
            }
            this.updateLowerText();
        }
    }

    private void updateWidgetVisibility() {
        ModuleRedstone.Operation op = this.getSelectedOp();
        this.constLabel.field_230694_p_ = op.useConst();
        this.textField.func_146189_e(op.useConst());
        this.textField.setRange(op.getMin(), op.getMax());
        this.otherColorLabel.field_230694_p_ = op.useOtherColor();
        this.otherColorButton.field_230694_p_ = op.useOtherColor();
        this.otherColorButton.setVisible(op.useOtherColor());
    }

    private void updateLowerText() {
        this.lowerText.clear();
        ModuleRedstone.Operation op = this.getSelectedOp();
        String key = op.getTranslationKey() + ".tooltip";
        ArrayList<ITextComponent> l = new ArrayList<ITextComponent>();
        if (op.useConst()) {
            l.add((ITextComponent)PneumaticCraftUtils.xlate(key, PneumaticCraftUtils.dyeColorDesc(this.ourColor), this.textField.getValue()));
        } else if (op.useOtherColor()) {
            l.add((ITextComponent)PneumaticCraftUtils.xlate(key, PneumaticCraftUtils.dyeColorDesc(this.ourColor), PneumaticCraftUtils.dyeColorDesc(this.otherColor)));
        } else {
            l.add((ITextComponent)PneumaticCraftUtils.xlate(key, PneumaticCraftUtils.dyeColorDesc(this.ourColor)));
        }
        if (!this.upgraded) {
            l.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.addAdvancedPCB", new Object[0]).func_240699_a_(TextFormatting.DARK_BLUE));
        }
        this.lowerText.addAll(GuiUtils.wrapTextComponentList(l, this.xSize - 20, this.field_230712_o_));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int n = this.lowerText.size();
        this.field_230712_o_.getClass();
        int yBase = this.guiTop + this.ySize - n * 9 - 10;
        for (int i = 0; i < this.lowerText.size(); ++i) {
            float f = this.guiLeft + 10;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238422_b_(matrixStack, this.lowerText.get(i), f, (float)(yBase + i * 9), -12566464);
        }
    }

    private ModuleRedstone.Operation getSelectedOp() {
        return ModuleRedstone.Operation.values()[this.comboBox.getSelectedElementIndex()];
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ((ModuleRedstone)this.module).setColorChannel(this.ourColor);
        if (this.output) {
            ((ModuleRedstone)this.module).setInverted(this.invertCheckBox.checked);
            ((ModuleRedstone)this.module).setOperation(this.getSelectedOp(), this.otherColor, this.textField.getValue());
        } else {
            ((ModuleRedstone)this.module).setComparatorInput(this.comparatorInputCheckBox.checked);
        }
        NetworkHandler.sendToServer(new PacketSyncRedstoneModuleToServer((ModuleRedstone)this.module));
    }

    private void toggleRedstoneDirection() {
        ((ModuleRedstone)this.module).setRedstoneDirection(((ModuleRedstone)this.module).getRedstoneDirection().toggle());
        this.func_231164_f_();
        this.field_230706_i_.func_147108_a((Screen)new GuiRedstoneModule((ModuleRedstone)this.module));
        this.field_230706_i_.field_71439_g.func_184185_a((SoundEvent)ModSounds.INTERFACE_DOOR.get(), 0.7f, 2.0f);
    }

    private String getDirText(ModuleRedstone module) {
        return module.getRedstoneDirection() == ModuleRedstone.EnumRedstoneDirection.INPUT ? TextFormatting.DARK_RED + "\u25c0" : TextFormatting.RED + "\u25b6";
    }
}

