/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class WidgetAmadronOffer
extends Widget
implements ITooltipProvider {
    private final AmadronOffer offer;
    private final List<Widget> subWidgets = new ArrayList<Widget>();
    private int shoppingAmount;
    private boolean canBuy;
    private final Rectangle2d[] tooltipRectangles = new Rectangle2d[2];
    private boolean renderBackground = true;

    public WidgetAmadronOffer(int x, int y, AmadronOffer offer) {
        super(x, y, 73, 35, StringTextComponent.field_240750_d_);
        this.offer = offer;
        if (offer.getInput().getType() == AmadronTradeResource.Type.FLUID) {
            this.subWidgets.add(new WidgetFluidStack(x + 6, y + 15, offer.getInput().getFluid().copy(), null));
        }
        if (offer.getOutput().getType() == AmadronTradeResource.Type.FLUID) {
            this.subWidgets.add(new WidgetFluidStack(x + 51, y + 15, offer.getOutput().getFluid().copy(), null));
        }
        if (offer.isRemovableBy((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            ArrayList<ITextComponent> l = new ArrayList<ITextComponent>(GuiUtils.xlateAndSplit("pneumaticcraft.gui.amadron.amadronWidget.sneakRightClickToRemove", new Object[0]));
            l.add(StringTextComponent.field_240750_d_);
            this.subWidgets.add((Widget)new WidgetButtonExtended(x + 57, y + 1, 11, 11, (ITextComponent)new StringTextComponent(TextFormatting.RED + "x"), b -> NetworkHandler.sendToServer(new PacketGuiButton("remove:" + offer.func_199560_c()))).setTooltipText(l));
        }
        this.tooltipRectangles[0] = new Rectangle2d(x + 5, y + 14, 18, 18);
        this.tooltipRectangles[1] = new Rectangle2d(x + 50, y + 14, 18, 18);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.subWidgets.forEach(w -> w.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return this.subWidgets.stream().anyMatch(w -> w.func_231044_a_(mouseX, mouseY, button));
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.field_230694_p_) {
            String str;
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            if (this.renderBackground) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_AMADRON_OFFER);
                RenderSystem.color4f((float)1.0f, (float)(this.canBuy ? 1.0f : 0.4f), (float)(this.canBuy ? 1.0f : 0.4f), (float)1.0f);
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)256, (int)256);
            }
            IReorderingProcessor r = (IReorderingProcessor)fr.func_238425_b_((ITextProperties)new StringTextComponent(this.offer.getVendor()).func_240699_a_(this.canBuy ? TextFormatting.BLACK : TextFormatting.DARK_GRAY), 73).get(0);
            fr.func_238422_b_(matrixStack, r, (float)(this.field_230690_l_ + 2), (float)(this.field_230691_m_ + 2), -16777216);
            if (this.shoppingAmount > 0) {
                str = "" + this.shoppingAmount;
                fr.func_238421_b_(matrixStack, str, (float)(this.field_230690_l_ + 36) - (float)fr.func_78256_a(str) / 2.0f, (float)(this.field_230691_m_ + (this.offer.getStock() >= 0 ? 15 : 20)), -16777216);
            }
            if (this.offer.getStock() >= 0) {
                str = TextFormatting.DARK_BLUE.toString() + this.offer.getStock();
                fr.func_238421_b_(matrixStack, str, (float)(this.field_230690_l_ + 36) - (float)fr.func_78256_a(str) / 2.0f, (float)(this.field_230691_m_ + 25), -16777216);
            }
        }
    }

    public WidgetAmadronOffer setDrawBackground(boolean drawBackground) {
        this.renderBackground = drawBackground;
        return this;
    }

    public WidgetAmadronOffer setCanBuy(boolean canBuy) {
        this.canBuy = canBuy;
        return this;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shiftPressed) {
        for (Widget widget : this.subWidgets) {
            if (!widget.func_230449_g_() || !(widget instanceof ITooltipProvider)) continue;
            ((ITooltipProvider)widget).addTooltip(mouseX, mouseY, curTip, shiftPressed);
        }
        boolean isInBounds = false;
        for (Rectangle2d rect : this.tooltipRectangles) {
            if (!rect.func_199315_b((int)mouseX, (int)mouseY)) continue;
            isInBounds = true;
        }
        if (!isInBounds) {
            curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.vendor", this.offer.getVendor()));
            curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.selling", this.offer.getOutput().toString()));
            curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.buying", this.offer.getInput().toString()));
            if (this.offer.getStock() >= 0) {
                curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.stock", this.offer.getStock()));
            }
            curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.inBasket", this.shoppingAmount));
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                curTip.add((ITextComponent)new StringTextComponent(this.offer.func_199560_c().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }

    public AmadronOffer getOffer() {
        return this.offer;
    }

    public void setShoppingAmount(int amount) {
        this.shoppingAmount = amount;
    }
}

