/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class WidgetButtonExtended
extends ExtendedButton
implements ITaggedWidget,
ITooltipProvider {
    private int iconSpacing = 18;
    private ItemStack[] renderedStacks;
    private ResourceLocation resLoc;
    private final List<ITextComponent> tooltipText = new ArrayList<ITextComponent>();
    private final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private int invisibleHoverColor;
    private boolean thisVisible = true;
    private IconPosition iconPosition = IconPosition.MIDDLE;
    private String tag = null;

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, ITextComponent buttonText, Button.IPressable pressable) {
        super(startX, startY, xSize, ySize, buttonText, pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, ITextComponent buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText, Button.IPressable pressable) {
        super(startX, startY, xSize, ySize, (ITextComponent)new StringTextComponent(buttonText), pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize) {
        this(startX, startY, xSize, ySize, StringTextComponent.field_240750_d_, b -> {});
    }

    public WidgetButtonExtended withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public void func_230930_b_() {
        super.func_230930_b_();
        if (this.tag != null && !this.tag.isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton(this.tag));
        }
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public WidgetButtonExtended setVisible(boolean visible) {
        this.thisVisible = visible;
        return this;
    }

    public WidgetButtonExtended setInvisibleHoverColor(int color) {
        this.invisibleHoverColor = color;
        return this;
    }

    public WidgetButtonExtended setIconPosition(IconPosition iconPosition) {
        this.iconPosition = iconPosition;
        return this;
    }

    public WidgetButtonExtended setRenderStacks(ItemStack ... renderedStacks) {
        this.renderedStacks = renderedStacks;
        this.resLoc = null;
        return this;
    }

    public WidgetButtonExtended setRenderedIcon(ResourceLocation resLoc) {
        this.resLoc = resLoc;
        this.renderedStacks = null;
        return this;
    }

    public WidgetButtonExtended setIconSpacing(int spacing) {
        this.iconSpacing = spacing;
        return this;
    }

    public WidgetButtonExtended setTexture(Object texture) {
        if (texture instanceof ItemStack) {
            this.setRenderStacks((ItemStack)texture);
        } else if (texture instanceof ResourceLocation) {
            this.setRenderedIcon((ResourceLocation)texture);
        } else {
            throw new IllegalArgumentException("texture must be an ItemStack or ResourceLocation!");
        }
        return this;
    }

    public WidgetButtonExtended setTooltipKey(String key, Object ... params) {
        return this.setTooltipText(GuiUtils.xlateAndSplit(key, params));
    }

    public WidgetButtonExtended setTooltipText(ITextComponent tooltip) {
        return this.setTooltipText(Collections.singletonList(tooltip));
    }

    public WidgetButtonExtended setTooltipText(List<ITextComponent> tooltip) {
        this.tooltipText.clear();
        this.tooltipText.addAll(tooltip);
        return this;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shift) {
        curTip.addAll(this.tooltipText);
    }

    public boolean hasTooltip() {
        return !this.tooltipText.isEmpty();
    }

    public List<ITextComponent> getTooltip() {
        return this.tooltipText;
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    public int getHeight() {
        return this.field_230689_k_;
    }

    public void func_230431_b_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        if (this.thisVisible) {
            super.func_230431_b_(matrixStack, x, y, partialTicks);
        }
        if (this.field_230694_p_) {
            if (this.renderedStacks != null) {
                int startX = this.getIconX();
                RenderHelper.func_227780_a_();
                for (int i = this.renderedStacks.length - 1; i >= 0; --i) {
                    GuiUtils.renderItemStack(matrixStack, this.renderedStacks[i], startX + i * this.iconSpacing, this.field_230691_m_ + 2);
                }
                RenderHelper.func_74518_a();
            }
            if (this.resLoc != null) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                GuiUtils.drawTexture(matrixStack, this.resLoc, this.field_230690_l_ + this.field_230688_j_ / 2 - 8, this.field_230691_m_ + 2);
                RenderSystem.disableBlend();
            }
            if (this.field_230693_o_ && !this.thisVisible && x >= this.field_230690_l_ && y >= this.field_230691_m_ && x < this.field_230690_l_ + this.field_230688_j_ && y < this.field_230691_m_ + this.field_230689_k_) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)this.invisibleHoverColor);
            }
        }
    }

    private int getIconX() {
        switch (this.iconPosition) {
            case LEFT: {
                return this.field_230690_l_ - 1 - 18 * this.renderedStacks.length;
            }
            case RIGHT: {
                return this.field_230690_l_ + this.field_230688_j_ + 1;
            }
        }
        return this.field_230690_l_ + this.field_230688_j_ / 2 - this.renderedStacks.length * 9 + 1;
    }

    public static enum IconPosition {
        MIDDLE,
        LEFT,
        RIGHT;

    }
}

