/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class WidgetCheckBox
extends Widget
implements ITaggedWidget,
ITooltipProvider {
    public boolean checked;
    private final int color;
    private List<ITextComponent> tooltip = new ArrayList<ITextComponent>();
    private final Consumer<WidgetCheckBox> pressable;
    private static final int CHECKBOX_WIDTH = 10;
    private static final int CHECKBOX_HEIGHT = 10;
    private String tag = null;

    public WidgetCheckBox(int x, int y, int color, ITextComponent text, Consumer<WidgetCheckBox> pressable) {
        super(x, y, 10, 10, text);
        this.field_230690_l_ = x;
        this.field_230691_m_ = y;
        this.field_230688_j_ = 13 + Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)text);
        this.color = color;
        this.pressable = pressable;
    }

    public WidgetCheckBox(int x, int y, int color, ITextComponent text) {
        this(x, y, color, text, null);
    }

    public WidgetCheckBox withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.field_230694_p_) {
            WidgetCheckBox.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + 10), (int)(this.field_230691_m_ + 10), (int)(this.field_230693_o_ ? -6250336 : -6710887));
            WidgetCheckBox.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (int)(this.field_230690_l_ + 10 - 1), (int)(this.field_230691_m_ + 10 - 1), (int)(this.field_230693_o_ ? -14671840 : -5592406));
            if (this.checked) {
                this.drawTick(matrixStack);
            }
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            IReorderingProcessor iReorderingProcessor = this.func_230458_i_().func_241878_f();
            float f = this.field_230690_l_ + 3 + 10;
            float f2 = (float)this.field_230691_m_ + 5.0f;
            fr.getClass();
            fr.func_238422_b_(matrixStack, iReorderingProcessor, f, f2 - 9.0f / 2.0f, this.field_230693_o_ ? this.color : -7829368);
        }
    }

    private void drawTick(MatrixStack matrixStack) {
        int b;
        int g;
        int r;
        RenderSystem.disableTexture();
        if (this.field_230693_o_) {
            r = 128;
            g = 255;
            b = 128;
        } else {
            b = 192;
            g = 192;
            r = 192;
        }
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.lineWidth((float)3.0f);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        wr.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        wr.func_227888_a_(posMat, (float)(this.field_230690_l_ + 2), (float)(this.field_230691_m_ + 5), 0.0f).func_225586_a_(r, g, b, 255).func_181675_d();
        wr.func_227888_a_(posMat, (float)(this.field_230690_l_ + 5), (float)(this.field_230691_m_ + 7), 0.0f).func_225586_a_(r, g, b, 255).func_181675_d();
        wr.func_227888_a_(posMat, (float)(this.field_230690_l_ + 8), (float)(this.field_230691_m_ + 3), 0.0f).func_225586_a_(r, g, b, 255).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        if (this.field_230693_o_) {
            boolean bl = this.checked = !this.checked;
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            if (this.tag != null) {
                NetworkHandler.sendToServer(new PacketGuiButton(this.tag));
            }
        }
    }

    public WidgetCheckBox setTooltip(List<ITextComponent> tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public WidgetCheckBox setTooltipKey(String translationKey) {
        return this.setTooltip(Collections.singletonList(PneumaticCraftUtils.xlate(translationKey, new Object[0])));
    }

    public List<ITextComponent> getTooltip() {
        return this.tooltip;
    }

    public WidgetCheckBox setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shift) {
        curTip.addAll(this.tooltip);
    }
}

