/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class WidgetKeybindCheckBox
extends WidgetCheckBox
implements ITooltipProvider {
    private static WidgetKeybindCheckBox coreComponents;
    private final ResourceLocation upgradeID;
    private ResourceLocation ownerUpgradeID = null;
    private boolean isListeningForBinding;
    private ITextComponent oldCheckboxText;

    private WidgetKeybindCheckBox(ResourceLocation upgradeID, int x, int y, int color, Consumer<WidgetCheckBox> pressable) {
        super(x, y, color, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.enableModule", PneumaticCraftUtils.xlate(ArmorUpgradeRegistry.getStringKey(upgradeID), new Object[0])), pressable);
        this.upgradeID = upgradeID;
    }

    public static WidgetKeybindCheckBox getOrCreate(ResourceLocation upgradeID, int x, int y, int color, Consumer<WidgetCheckBox> pressable) {
        WidgetKeybindCheckBox newCheckBox = (WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get(upgradeID);
        if (newCheckBox == null) {
            newCheckBox = new WidgetKeybindCheckBox(upgradeID, x, y, color, pressable);
            newCheckBox.checked = ArmorFeatureStatus.INSTANCE.isUpgradeEnabled(upgradeID);
            KeyDispatcher.id2checkBox.put(upgradeID, newCheckBox);
            KeyBinding keyBinding = ArmorUpgradeClientRegistry.getInstance().getKeybindingForUpgrade(upgradeID);
            if (keyBinding != null) {
                KeyDispatcher.desc2checkbox.put(keyBinding.func_151464_g(), newCheckBox);
            }
            if (upgradeID.equals((Object)ArmorUpgradeRegistry.getInstance().coreComponentsHandler.getID())) {
                coreComponents = newCheckBox;
            }
        }
        return newCheckBox;
    }

    public static WidgetKeybindCheckBox get(ResourceLocation upgradeID) {
        return (WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get(upgradeID);
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeHandler handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeClientHandler handler) {
        return WidgetKeybindCheckBox.get(handler.getCommonHandler().getID());
    }

    public static WidgetKeybindCheckBox getCoreComponents() {
        return coreComponents;
    }

    public WidgetKeybindCheckBox withOwnerUpgradeID(ResourceLocation ownerUpgradeID) {
        this.ownerUpgradeID = ownerUpgradeID;
        return this;
    }

    public static boolean isHandlerEnabled(IArmorUpgradeHandler handler) {
        return WidgetKeybindCheckBox.forUpgrade((IArmorUpgradeHandler)handler).checked;
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (this.func_230992_c_(x, y)) {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            if (this.handleClick(x, y, button)) {
                return true;
            }
            if (this.isListeningForBinding) {
                InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(button);
                this.updateBinding(input);
                return true;
            }
        }
        return false;
    }

    private boolean handleClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            byte idx;
            EquipmentSlotType slot;
            if (!WidgetKeybindCheckBox.coreComponents.checked && this != coreComponents) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 2.0f);
                return true;
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            ArmorUpgradeRegistry.ArmorUpgradeEntry entry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.upgradeID);
            ArmorUpgradeRegistry.ArmorUpgradeEntry ownerEntry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.ownerUpgradeID);
            if (!this.checked && (entry != null ? this != coreComponents && !commonArmorHandler.isArmorReady(entry.getSlot()) : ownerEntry != null && !commonArmorHandler.isArmorReady(ownerEntry.getSlot()))) {
                return true;
            }
            super.func_230982_a_(mouseX, mouseY);
            ArmorFeatureStatus.INSTANCE.setUpgradeEnabled(this.upgradeID, this.checked);
            ArmorFeatureStatus.INSTANCE.tryWriteToFile();
            if (entry != null && commonArmorHandler.isUpgradeInserted(slot = entry.getSlot(), idx = (byte)entry.getIndex())) {
                this.toggleUpgrade(commonArmorHandler, slot, idx);
            }
            if (this == coreComponents) {
                this.toggleAllUpgrades(commonArmorHandler);
            }
            return true;
        }
        if (button == 1) {
            if (Screen.func_231173_s_()) {
                this.updateBinding(InputMappings.field_197958_a);
            } else {
                boolean bl = this.isListeningForBinding = !this.isListeningForBinding;
                if (this.isListeningForBinding) {
                    this.oldCheckboxText = this.func_230458_i_();
                    this.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.setKeybind", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
                } else {
                    this.func_238482_a_(this.oldCheckboxText);
                }
            }
            return true;
        }
        return false;
    }

    private void toggleUpgrade(CommonArmorHandler commonArmorHandler, EquipmentSlotType slot, byte idx) {
        NetworkHandler.sendToServer(new PacketToggleArmorFeature(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked));
        commonArmorHandler.setUpgradeEnabled(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked);
        HUDHandler.getInstance().addFeatureToggleMessage(ArmorUpgradeRegistry.getStringKey(this.upgradeID), this.checked);
    }

    private void toggleAllUpgrades(CommonArmorHandler commonArmorHandler) {
        ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting> features = new ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting>();
        ArmorUpgradeRegistry.getInstance().entries().forEach(entry -> {
            boolean state = WidgetKeybindCheckBox.coreComponents.checked && WidgetKeybindCheckBox.forUpgrade((IArmorUpgradeHandler)entry.getHandler()).checked;
            byte idx = (byte)entry.getIndex();
            features.add(new PacketToggleArmorFeatureBulk.FeatureSetting(entry.getSlot(), idx, state));
            commonArmorHandler.setUpgradeEnabled(entry.getSlot(), idx, state);
        });
        NetworkHandler.sendToServer(new PacketToggleArmorFeatureBulk(features));
        if (this.checked) {
            ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().coreComponentsHandler).onResolutionChanged();
        } else {
            Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 0.5f);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.isListeningForBinding) {
            InputMappings.Input input = InputMappings.Type.KEYSYM.func_197944_a(keyCode);
            if (!KeyModifier.isKeyCodeModifier((InputMappings.Input)input)) {
                this.updateBinding(input);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTooltip, boolean shiftPressed) {
        KeyBinding keyBinding = ArmorUpgradeClientRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        if (keyBinding != null) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindBoundKey", ClientUtils.translateKeyBind(keyBinding)));
            if (!this.isListeningForBinding) {
                curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindRightClickToSet", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                if (keyBinding.getKey().func_197937_c() != -1) {
                    curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindShiftRightClickToClear", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                }
            }
        }
    }

    private void updateBinding(InputMappings.Input input) {
        this.isListeningForBinding = false;
        KeyBinding keyBinding = ArmorUpgradeClientRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        if (keyBinding != null) {
            KeyModifier mod = input == InputMappings.field_197958_a ? KeyModifier.NONE : KeyModifier.getActiveModifier();
            keyBinding.setKeyModifierAndCode(mod, input);
            Minecraft.func_71410_x().field_71474_y.func_198014_a(keyBinding, input);
            KeyBinding.func_74508_b();
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_193808_ex, 1.0f, input == InputMappings.field_197958_a ? 0.5f : 1.0f);
        }
        this.func_238482_a_(this.oldCheckboxText);
    }

    public ResourceLocation getUpgradeId() {
        return this.upgradeID;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT})
    public static class KeyDispatcher {
        private static final Map<ResourceLocation, WidgetKeybindCheckBox> id2checkBox = new HashMap<ResourceLocation, WidgetKeybindCheckBox>();
        private static final Map<String, WidgetKeybindCheckBox> desc2checkbox = new HashMap<String, WidgetKeybindCheckBox>();
        private static final KeyBindingMap KEY_BINDING_MAP = new KeyBindingMap();

        @SubscribeEvent
        public static void onKeyPress(InputEvent.KeyInputEvent event) {
            KeyBinding binding;
            if (Minecraft.func_71410_x().field_71462_r == null && event.getAction() == 1 && (binding = KEY_BINDING_MAP.lookupActive(InputMappings.Type.KEYSYM.func_197944_a(event.getKey()))) != null) {
                KeyDispatcher.getBoundWidget(binding.func_151464_g()).ifPresent(w -> ((WidgetKeybindCheckBox)w).handleClick(0.0, 0.0, 0));
            }
        }

        @SubscribeEvent
        public static void onMouseClick(InputEvent.MouseInputEvent event) {
            KeyBinding binding;
            if (Minecraft.func_71410_x().field_71462_r == null && event.getAction() == 1 && (binding = KEY_BINDING_MAP.lookupActive(InputMappings.Type.MOUSE.func_197944_a(event.getButton()))) != null) {
                KeyDispatcher.getBoundWidget(binding.func_151464_g()).ifPresent(w -> ((WidgetKeybindCheckBox)w).handleClick(0.0, 0.0, 0));
            }
        }

        private static Optional<WidgetKeybindCheckBox> getBoundWidget(String key) {
            return Optional.ofNullable(desc2checkbox.get(key));
        }
    }
}

