/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class WidgetTextFieldNumber
extends WidgetTextField {
    public int minValue = Integer.MIN_VALUE;
    public int maxValue = Integer.MAX_VALUE;
    private int decimals;
    private double fineAdjust = 1.0;
    private double coarseAdjust = 1000.0;

    public WidgetTextFieldNumber(FontRenderer fontRenderer, int x, int y, int width, int height) {
        super(fontRenderer, x, y, width, height);
        this.setValue(0.0);
        this.func_200675_a(input -> this.decimals == 0 ? PneumaticCraftUtils.isInteger(input) : PneumaticCraftUtils.isNumber(input));
    }

    public WidgetTextFieldNumber setRange(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public WidgetTextFieldNumber setDecimals(int decimals) {
        this.decimals = decimals;
        return this;
    }

    public WidgetTextFieldNumber setValue(double value) {
        this.func_146180_a(PneumaticCraftUtils.roundNumberTo(MathHelper.func_151237_a((double)value, (double)this.minValue, (double)this.maxValue), this.decimals));
        return this;
    }

    public int getValue() {
        return MathHelper.func_76125_a((int)NumberUtils.toInt((String)this.func_146179_b()), (int)this.minValue, (int)this.maxValue);
    }

    public double getDoubleValue() {
        return PneumaticCraftUtils.roundNumberToDouble(MathHelper.func_151237_a((double)NumberUtils.toDouble((String)this.func_146179_b()), (double)this.minValue, (double)this.maxValue), this.decimals);
    }

    public WidgetTextFieldNumber setAdjustments(double fineAdjust, double coarseAdjust) {
        this.fineAdjust = fineAdjust;
        this.coarseAdjust = coarseAdjust;
        return this;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        double adj;
        double d = adj = ClientUtils.hasShiftDown() ? this.coarseAdjust : this.fineAdjust;
        if (this.decimals > 0) {
            this.setValue(MathHelper.func_151237_a((double)(this.getDoubleValue() + (delta > 0.0 ? adj : -adj)), (double)this.minValue, (double)this.maxValue));
        } else {
            int v = this.getValue();
            if (v == 1 && adj % 10.0 == 0.0) {
                adj -= 1.0;
            }
            this.setValue(MathHelper.func_151237_a((double)((double)this.getValue() + (delta > 0.0 ? adj : -adj)), (double)this.minValue, (double)this.maxValue));
        }
        return true;
    }
}

