/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;

public class RenderHackSimulation {
    private final int baseX;
    private final int baseY;
    private final int nodeSpacing;

    public RenderHackSimulation(int baseX, int baseY, int nodeSpacing) {
        this.baseX = baseX;
        this.baseY = baseY;
        this.nodeSpacing = nodeSpacing;
    }

    public void render(MatrixStack matrixStack, HackSimulation hackSimulation, int color) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((int)770, (int)771);
        for (HackSimulation.ConnectionEntry entry : hackSimulation.allConnections) {
            RenderUtils.renderProgressingLineGUI(matrixStack, this.makeProgressingLine(entry), color, 3.0f);
        }
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    private ProgressingLine makeProgressingLine(HackSimulation.ConnectionEntry entry) {
        int xOff = 0;
        int yOff = 0;
        int delta = entry.from - entry.to;
        if (delta == 5) {
            xOff = 1;
        } else if (delta == -5) {
            xOff = -1;
        } else {
            yOff = delta < 0 ? -1 : 1;
        }
        int startX = this.baseX + xOff + entry.from % 5 * this.nodeSpacing;
        int startY = this.baseY + yOff + entry.from / 5 * this.nodeSpacing;
        int endX = this.baseX + xOff + entry.to % 5 * this.nodeSpacing;
        int endY = this.baseY + yOff + entry.to / 5 * this.nodeSpacing;
        return new ProgressingLine(startX, startY, endX, endY).setProgress(entry.progress);
    }
}

