/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelHeatFrame;
import me.desht.pneumaticcraft.client.render.entity.RenderSemiblockBase;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityHeatFrame;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderHeatFrame
extends RenderSemiblockBase<EntityHeatFrame> {
    public static final IRenderFactory<EntityHeatFrame> FACTORY = RenderHeatFrame::new;
    private final ModelHeatFrame model = new ModelHeatFrame();

    private RenderHeatFrame(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(EntityHeatFrame entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        TintColor tint = HeatUtil.getColourForTemperature(entityIn.getSyncedTemperature());
        float[] f = tint.getComponents(null);
        AxisAlignedBB aabb = entityIn.func_174813_aQ();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_((float)aabb.func_216364_b(), (float)aabb.func_216360_c(), (float)aabb.func_216362_d());
        matrixStackIn.func_227861_a_(0.0, -0.5, 0.0);
        if (entityIn.getTimeSinceHit() > 0) {
            this.wobble(entityIn, partialTicks, matrixStackIn);
        }
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getEntityTexture(entityIn)));
        this.model.func_225598_a_(matrixStackIn, builder, this.kludgeLightingLevel(entityIn, packedLightIn), OverlayTexture.func_229200_a_((float)0.0f, (boolean)false), f[0], f[1], f[2], f[3]);
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(EntityHeatFrame entityHeatFrame) {
        return Textures.MODEL_HEAT_FRAME;
    }
}

